@extends('layouts.app')

@section('title','Students')

@section('breadcrumb')
<li class="breadcrumb-item active">Students</li>
@endsection

@section('content')
<div id="students-page" class="page-content">
    <h1 class="mb-4">Student Management</h1>
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="student-list-tab" data-bs-toggle="tab" data-bs-target="#student-list" type="button" role="tab">Student List</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="register-tab" data-bs-toggle="tab" data-bs-target="#register-student" type="button" role="tab">Register Student</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="bulk-upload-tab" data-bs-toggle="tab" data-bs-target="#bulk-upload" type="button" role="tab">Bulk Upload</button>
        </li>
    </ul>

    <div class="tab-content">
        <!-- Student List Tab -->
        <div class="tab-pane fade show active" id="student-list" role="tabpanel">
            @include('students.list')
        </div>

        <!-- Register Student Tab -->
        <div class="tab-pane fade" id="register-student" role="tabpanel">
            @include('students.register')
        </div>

        <!-- Bulk Upload Tab -->
        <div class="tab-pane fade" id="bulk-upload" role="tabpanel">
            @include('students.bluk')
        </div>
    </div>
</div>
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $(document).on('change', '.student-status', function() {
                let checkbox = $(this);
                let student_status = $(this).prop('checked') === true ? 1 : 0;
                $.ajax({
                    type: "PUT",
                    dataType: "json",
                    url: $(this).data('url'),
                    data: {
                        _token: "{{ csrf_token() }}",
                        status: student_status
                    },
                    success: function(data) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: data.message
                        });
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'An error occurred while processing your request.'
                        });
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }

                });
            });

            document.querySelector('input[name="q"]').addEventListener('keydown', e => {
                if (e.key === 'Escape') window.location.href = "{{ route('students.index') }}";
            });

            

        });
    </script>
    <script>
        const classes = @json($classes);

        document.getElementById('class_id').addEventListener('change', function () {
            const classId = this.value;
            const sectionSelect = document.getElementById('section_id');
            sectionSelect.innerHTML = '<option value="">Select Section</option>';

            const selectedClass = classes.find(c => c.id == classId);
            if (selectedClass && selectedClass.sections) {
                selectedClass.sections.forEach(section => {
                    sectionSelect.innerHTML +=
                        `<option value="${section.id}">${section.section_name}</option>`;
                });
            }

        });

    </script>

    <script>
        document.getElementById('class_id').addEventListener('change', function () {
            let classId = this.value;
            let sectionSelect = document.getElementById('section_id');

            sectionSelect.innerHTML = '<option value="">Loading...</option>';
            sectionSelect.disabled = true;

            if (!classId) {
                sectionSelect.innerHTML = '<option value="">All Sections</option>';
                return;
            }

            fetch(`classes/${classId}/sections`)
                .then(res => res.json())
                .then(data => {
                    sectionSelect.innerHTML = '<option value="">All Sections</option>';
                    data.forEach(section => {
                        sectionSelect.innerHTML +=
                            `<option value="${section.id}">${section.section_name}</option>`;
                    });
                    sectionSelect.disabled = false;
                });
        });

        // Auto submit on section change
        document.getElementById('section_id').addEventListener('change', function () {
            this.form.submit();
        });
    </script>


@endsection
