<?php $__env->startSection('content'); ?>

<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5">
        <!-- BEGIN: Horizontal Form -->
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Expense Transaction
                </h2>

            </div>
            <div class="p-5" id="horizontal-form">

                <form id="expenseForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="preview">
                        
                        <div class="intro-y col-span-12 lg:col-span-12">
                            <!-- BEGIN: Input -->
                            <div class="intro-y box">

                                <div class="p-5" id="input">
                                    <div class="preview">
                                        <?php
                                        use Carbon\Carbon;
                                        $financialYear = \App\Models\AccountingYear::current();
                                        $orgId = \App\Models\Organisation::current()->organisation_id;

                                        [$startDate, $endDate] = explode(
                                        ' to ',
                                        $financialYear->accounting_year_financial,
                                        );

                                        $startDate = Carbon::createFromFormat('d-m-Y', trim($startDate));
                                        $endDate = Carbon::createFromFormat('d-m-Y', trim($endDate));

                                        $today = Carbon::today();

                                        if ($today->between($startDate, $endDate)) {
                                        $maxDate = $today->toDateString();
                                        } else {
                                        $maxDate = $endDate->toDateString();
                                        }

                                        $minDate = $startDate->toDateString();
                                        ?>
                                        <div class="w-full -ml-4 -mr-4 flex flex-wrap">

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Organisation <span style="color: red">*</span></label>
                                                    <select id="organisation_id" name="organisation_id"
                                                        class="input w-full border mt-2 custm-drpdwn" disabled>
                                                        <option value="">-- Select Organisation --</option>
                                                        <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($organisation->organisation_id); ?>"
                                                            <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                                            <?php echo e($organisation->organisation_name); ?>

                                                        </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-organisation"></div>
                                                </div>
                                            </div>
                                            <input type="hidden" value="<?php echo e($orgId); ?>" id="organisation_id"
                                                name="organisation_id">
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3" id="accountTypeWrapper">
                                                    <label>Division<span style="color: red">*</span></label>
                                                    <select id="account_type_id" name="account_type_id"
                                                        class="input w-full border mt-2 custm-drpdwn" disabled>
                                                        <option value="">-- Select Division Type --</option>
                                                    </select>
                                                    <small id="accountTypeMsg" class="text-red-500"
                                                        style="display:none;">
                                                        Please select organisation first
                                                    </small>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-account-type"></div>
                                                </div>
                                            </div>

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label class="items-center justify-between"> Expense Head
                                                        <span style="color: red">*</span>

                                                        <button type="button" id="addExpenseHeadBtn"
                                                            class="ml-2 bg-blue-500 text-white px-2 py-1 rounded hidden hover:bg-blue-600"
                                                            style="float: right;">+</button>
                                                    </label>
                                                    <select id="expense_head_id" name="expense_head_id"
                                                        class="input w-full border mt-2 custm-drpdwn">
                                                        <option value="">-- Select Expense Head --</option>
                                                        <?php $__currentLoopData = $expenseHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expenseHead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($expenseHead->expense_head_id); ?>"
                                                            <?php echo e(old('expense_head_id') == $expenseHead->expense_head_id ? 'selected' : ''); ?>>
                                                            <?php echo e($expenseHead->expense_head_name); ?>

                                                        </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-expense-head"></div>
                                                </div>
                                            </div>
                                            <!-- Add Expense Head Modal -->
                                            <div id="expenseHeadModal"
                                                class="hidden fixed inset-0 bg-gray-800 bg-opacity-50 flex items-center justify-center z-50">
                                                <div class="bg-white p-6 rounded-2xl w-96 shadow-lg">
                                                    <h2 class="text-lg font-semibold mb-4">Add Expense Head</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Organisation <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="expense_organisation_id_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select Organisation --
                                                                </option>
                                                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($org->organisation_id); ?>">
                                                                    <?php echo e($org->organisation_name); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-organisation-id"></div>
                                                        </div>
                                                        <div>
                                                            <label class="block">Division <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="expense_account_type_id"
                                                                class="w-full border rounded px-3 py-2 custm-drpdwn"
                                                                disabled>
                                                                <option value="">-- Select --</option>
                                                                <?php $__currentLoopData = $accountTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($type->account_type_id); ?>">
                                                                    <?php echo e($type->account_type_Name); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>

                                                        <div>
                                                            <label class="block">Expense Head Group </label>
                                                            <select id="expense_head_group_id"
                                                                class="w-full border rounded px-3 py-2 custm-drpdwn">
                                                                <option value="">-- Select --</option>
                                                                <?php $__currentLoopData = $expenseGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option
                                                                    value="<?php echo e($group->expense_head_group_ID); ?>">
                                                                    <?php echo e($group->expense_head_group_Name); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>

                                                        <div>
                                                            <label class="block">Expense Head Name <span
                                                                    class="text-red-500">*</span></label>
                                                            <input type="text" id="expense_head_name"
                                                                class="w-full border rounded px-3 py-2">
                                                        </div>

                                                        <div class="flex justify-end space-x-3">
                                                            <button type="button" id="closeExpenseHeadModal"
                                                                class="px-4 py-2 bg-gray-500 text-white rounded">Cancel</button>
                                                            <button type="button" id="saveExpenseHeadBtn"
                                                                class="px-4 py-2 bg-blue-600 text-white rounded">Save</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Success Modal -->
                                            <div id="expenseSuccessModal"
                                                class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Expense Head added successfully.</p>
                                                    <button type="button" id="closeExpenseSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                        Close
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="expenseErrorModal"
                                                class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
                                                <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                    <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                    <p id="expenseErrorMessage" class="text-gray-700"></p>
                                                    <div class="flex justify-end mt-4">
                                                        <button type="button" id="closeExpenseErrorModal"
                                                            class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Voucher / Receipt No. </label>
                                                    <input type="text" class="input w-full border mt-2"
                                                        name="receipt_no" value="<?php echo e(old('receipt_no')); ?>"
                                                        placeholder="Enter Voucher / Receipt Number">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-receipt-number"></div>
                                                </div>
                                            </div>

                                            
                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label class="block font-medium text-gray-700">Expense
                                                        Type

                                                    </label>
                                                    <div class="flex items-center space-x-6 mt-2">
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="type" value="asset"
                                                                class="type-radio w-4 h-4">
                                                            <span>Assets</span>
                                                        </label>
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="type" value="liability"
                                                                class="type-radio w-4 h-4">
                                                            <span>Liabilities</span>
                                                        </label>

                                                        <button type="button" id="clearTypeSelection"
                                                            class="ml-4 px-3 py-1 bg-gray-200 text-gray-700 rounded hover:bg-gray-300">
                                                            Clear
                                                        </button>
                                                    </div>

                                                </div>
                                            </div>

                                            <!-- Add Asset Modal -->
                                            <div id="assetModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                    <h2 class="text-lg font-bold mb-4">Add New Asset</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Organisation <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="organisation_id_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select Organisation --
                                                                </option>
                                                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($org->organisation_id); ?>">
                                                                    <?php echo e($org->organisation_name); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-organisation-id"></div>
                                                        </div>

                                                        <div id="account_type_asset">
                                                            <label>Division <span class="text-red-500">*</span></label>
                                                            <select id="account_type_id_new2"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select Division --
                                                                </option>
                                                                <?php $__currentLoopData = $accountTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($acc->account_type_id); ?>">
                                                                    <?php echo e($acc->account_type_Name); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-account-type-id"></div>
                                                        </div>

                                                        <div>
                                                            <label>Asset Name <span
                                                                    class="text-red-500">*</span></label>
                                                            <input type="text" id="asset_name"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-asset-name"></div>
                                                        </div>

                                                        <div>
                                                            <label>Asset Type </label>
                                                            <input type="text" id="asset_type"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-asset-type"></div>
                                                        </div>

                                                        <div>
                                                            <label>Depreciation (%)</label>
                                                            <input type="text" id="depreciation"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-depreciation"></div>
                                                        </div>


                                                    </div>

                                                    <div class="flex justify-end space-x-2 mt-6">
                                                        <button type="button" id="closeAssetModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="saveAssetBtn"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Success Modal -->
                                            <div id="assetSuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Asset added successfully.</p>
                                                    <button type="button" id="closeAssetSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Close</button>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="assetErrorModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4 text-red-600">Error!</h2>
                                                    <p id="assetErrorMessage"></p>
                                                    <button type="button" id="closeAssetErrorModal"
                                                        class="mt-4 px-4 py-2 bg-red-500 text-white rounded hover:bg-red-600">Close</button>
                                                </div>
                                            </div>

                                            
                                            <div id="liabilityModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                    <h2 class="text-lg font-bold mb-4">Add New Liability</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Organisation <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="liability_organisation_id"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select --</option>
                                                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($org->organisation_id); ?>">
                                                                    <?php echo e($org->organisation_name); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-organisation-id"></div>
                                                        </div>

                                                        <div id="account_type_liability">
                                                            <label>Division <span class="text-red-500">*</span></label>
                                                            <select id="liability_account_type_id"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select --</option>
                                                                <?php $__currentLoopData = $accountTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($acc->account_type_id); ?>">
                                                                    <?php echo e($acc->account_type_Name); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-account-type-id"></div>
                                                        </div>
                                                        <div>
                                                            <label>Liability Name <span
                                                                    class="text-red-500">*</span></label>
                                                            <input type="text" id="liability_name"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-name"></div>
                                                        </div>

                                                        <div>
                                                            <label>Liability Type </label>
                                                            <input type="text" id="liability_type"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-type"></div>
                                                        </div>



                                                    </div>

                                                    <div class="flex justify-end space-x-2 mt-6">
                                                        <button type="button" id="closeLiabilityModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="saveLiabilityBtn"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>

                                            
                                            <div id="liabilitySuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Liability added successfully.</p>
                                                    <button type="button" id="closeLiabilitySuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Close</button>
                                                </div>
                                            </div>

                                            
                                            <div id="liabilityErrorModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4 text-red-600">Error!</h2>
                                                    <p id="liabilityErrorMessage"></p>
                                                    <button type="button" id="closeLiabilityErrorModal"
                                                        class="mt-4 px-4 py-2 bg-red-500 text-white rounded hover:bg-red-600">Close</button>
                                                </div>
                                            </div>

                                            <div class="w-full px-4">
                                                <div id="assetSection" class="mt-3 hidden relative">
                                                    <label>
                                                        <span class="text-gray-700">Select Asset
                                                            <button type="button" id="openAssetModalBtn"
                                                                class="px-2 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 hidden">
                                                                +
                                                            </button>
                                                        </span>
                                                        <input type="text" id="assetInput"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Type to search asset...">

                                                    </label>
                                                    <ul id="assetList"
                                                        class="absolute w-full bg-white border rounded mt-1 max-h-40 overflow-y-auto hidden z-10 custm-drpdwn">
                                                        <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li data-id="<?php echo e($asset->asset_id); ?>"
                                                            class="px-3 py-2 hover:bg-gray-100 cursor-pointer">
                                                            <?php echo e($asset->asset_name); ?>

                                                        </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                    <input type="hidden" name="asset_id" id="assetHidden">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-type-asset"></div>
                                                </div>
                                            </div>

                                            <div class="w-full px-4">
                                                <div id="liabilitySection" class="mt-3 hidden relative">
                                                    <label>
                                                        <span class="text-gray-700">Select Liability
                                                            <button type="button" id="openLiabilityModalBtn"
                                                                class="px-2 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 hidden">
                                                                +
                                                            </button>
                                                        </span>
                                                        <input type="text" id="liabilityInput"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Type to search liability...">
                                                    </label>
                                                    <ul id="liabilityList"
                                                        class="absolute w-full bg-white border rounded mt-1 max-h-40 overflow-y-auto hidden z-10 custm-drpdwn">
                                                        <?php $__currentLoopData = $liabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $liability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li data-id="<?php echo e($liability->liability_id); ?>"
                                                            class="px-3 py-2 hover:bg-gray-100 cursor-pointer">
                                                            <?php echo e($liability->liability_name); ?>

                                                        </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                    <input type="hidden" name="liability_id" id="liabilityHidden">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-type-liability"></div>
                                                </div>
                                            </div>
                                            

                                            
                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label class="block font-medium text-gray-700">Pay To</label>
                                                    <div class="flex items-center space-x-6 mt-2">
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="payee_type" value="internal"
                                                                class="payee-type-radio w-4 h-4">
                                                            <span>Staff</span>
                                                        </label>
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="payee_type" value="external"
                                                                class="payee-type-radio w-4 h-4">
                                                            <span>Vendor</span>
                                                        </label>
                                                        <button type="button" id="clearPayeeSelection"
                                                            class="ml-4 px-3 py-1 bg-gray-200 text-gray-700 rounded hover:bg-gray-300 ">
                                                            Clear
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="mt-3 hidden relative" id="payeeWrapper">
                                                    <label class="flex items-center justify-between">
                                                        <span class="text-gray-700">Select Payee</span>
                                                        <input type="text" id="payeeInput"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Type to search payee...">
                                                        <button type="button" id="addVendorBtn"
                                                            class="ml-2 bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">+</button>
                                                    </label>
                                                    <ul id="payeeList"
                                                        class="absolute w-full bg-white border rounded mt-1 max-h-40 overflow-y-auto hidden z-10 custm-drpdwn">
                                                        <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li data-id="<?php echo e($vendor->vendor_id); ?>"
                                                            data-type="<?php echo e($vendor->vendor_type); ?>"
                                                            class="px-3 py-2 hover:bg-gray-100 cursor-pointer">
                                                            <?php echo e($vendor->vendor_name); ?>

                                                        </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                    <input type="hidden" name="payee_id" id="payeeHidden">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-asset-payee"></div>
                                                </div>
                                                <div class="mt-3 hidden" id="vendorAmountWrapper">
                                                    <label>
                                                        <span class="text-gray-700" style="color: blue;">Total
                                                            Bill
                                                            Amount
                                                            (₹) </span>
                                                        <input type="text" data-type="external"
                                                            name="vendor_total_amount" id="vendorTotalAmount"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Enter total amount">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-asset-payee-amount"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <!-- Vendor Modal -->
                                            <div id="vendorModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                    <h2 class="text-lg font-bold mb-4">Add New Vendor</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Vendor Type <span style="color:red">*</span></label>
                                                            <select id="vendor_type_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select --</option>
                                                                <option value="internal">Staff</option>
                                                                <option value="external">Vendor</option>
                                                            </select>
                                                        </div>
                                                        <!-- <div>
                                                                <label>Vendor Name <span style="color:red">*</span></label>
                                                                <input type="text" id="vendor_name" name="vendor_name"
                                                                    class="w-full border p-2 rounded">
                                                            </div> -->
                                                        <div>
                                                            <label>Vendor Name <span style="color:red">*</span></label>
                                                            <input type="text" id="vendor_name" name="vendor_name" class="w-full border p-2 rounded">
                                                            <p id="error-vendor-name" class="text-red-500 text-sm mt-1"></p> <!-- Error message goes here -->
                                                        </div>

                                                        
                                                        <div>
                                                            <label>Phone</label>
                                                            <input type="text" id="vendor_phone_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        
                                                        <div>
                                                            <label>GST Number</label>
                                                            <input type="text" id="vendor_gst_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        <div>
                                                            <label>PAN Number</label>
                                                            <input type="text" id="vendor_pan_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        
                                                        <div>
                                                            <label>Bank Account No</label>
                                                            <input type="text" id="vendor_bank_account_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        <div>
                                                            <label>Bank IFSC</label>
                                                            <input type="text" id="vendor_bank_ifsc"
                                                                class="w-full border p-2 rounded">
                                                        </div>

                                                    </div>

                                                    <div class="mt-4">
                                                        <label>Address</label>
                                                        <textarea id="vendor_address" class="w-full border p-2 rounded"></textarea>
                                                    </div>

                                                    <div class="flex justify-end space-x-2 mt-6">
                                                        <button type="button" id="closeVendorModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="saveVendor"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Success Modal -->
                                            <div id="vendorSuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Vendor added successfully.</p>
                                                    <button type="button" id="vendorCloseSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                        Close
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="vendorErrorModal"
                                                class="hidden fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50">
                                                <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                    <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                    <p id="vendorErrorMessage" class="text-gray-700"></p>
                                                    <div class="flex justify-end mt-4">
                                                        <button type="button" id="vendorCloseErrorModal"
                                                            class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            



                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Amount Paid (₹) <span style="color: red">*</span></label>
                                                    <input type="text" class="input w-full border mt-2"
                                                        name="transaction_amount"
                                                        value="<?php echo e(old('transaction_amount')); ?>"
                                                        placeholder="Enter Transaction Amount">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-amount"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Payment Type <span style="color: red">*</span>
                                                    </label>
                                                    <select id="payment_type_id" name="payment_type_id"
                                                        class="input w-full border mt-2 custm-drpdwn">
                                                        <option value="">-- Select Payment Type --
                                                        </option>

                                                        <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                        $children = $paymentTypes->where(
                                                        'parent_id',
                                                        $parent->id,
                                                        );
                                                        ?>

                                                        <?php if($children->isEmpty()): ?>
                                                        <option value="<?php echo e($parent->id); ?>"
                                                            <?php echo e(old('payment_type_id') == $parent->id ? 'selected' : ''); ?>>
                                                            <?php echo e($parent->name); ?>

                                                        </option>
                                                        <?php else: ?>
                                                        <optgroup label="<?php echo e($parent->name); ?>">
                                                            <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($child->id); ?>"
                                                                <?php echo e(old('payment_type_id') == $child->id ? 'selected' : ''); ?>>
                                                                <?php echo e($child->name); ?>

                                                            </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </optgroup>
                                                        <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-payment-type"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Date of Transaction <span
                                                            style="color: red">*</span></label>
                                                    <input type="date" class="input w-full border mt-2"
                                                        name="transaction_date" min="<?php echo e($minDate); ?>"
                                                        max="<?php echo e($maxDate); ?>"
                                                        value="<?php echo e(old('transaction_date', now()->toDateString())); ?>"
                                                        onfocus="this.showPicker()" />
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-date"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Transaction Reference No.</label>
                                                    <input id="transaction_reference" type="text"
                                                        class="input w-full border mt-2" name="transaction_reference"
                                                        value="<?php echo e(old('transaction_reference')); ?>"
                                                        placeholder="Enter Transaction Reference">
                                                    <div class="text-gray-500 text-xs mt-1">
                                                        Only letters and numbers allowed, 5–20 characters.
                                                    </div>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-reference"></div>
                                                </div>
                                            </div>
                                            
                                    <!-- Modal -->
                                    <div id="purposeModal"
                                        class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                        <div class="bg-white p-6 rounded-lg shadow-lg w-96">
                                            <h2 class="text-lg font-bold mb-4">Add New Purpose</h2>
                                            <input type="text" id="newPurpose"
                                                class="input w-full border p-2 mb-4"
                                                placeholder="Enter new purpose">

                                            <div class="flex justify-end space-x-2">
                                                <button type="button" id="closeModal"
                                                    class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                <button type="button" id="savePurpose"
                                                    class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Success Modal -->
                                    <div id="purposeSuccessModal"
                                        class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                        <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                            <h2 class="text-lg font-bold mb-4">Success!</h2>
                                            <p>Purpose added successfully.</p>
                                            <button type="button" id="closeSuccessModal"
                                                class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                Close
                                            </button>
                                        </div>
                                    </div>
                                    <!-- Error Modal -->
                                    <div id="purposeErrorModal"
                                        class="hidden fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50">
                                        <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                            <h2 class="text-lg font-semibold text-red-600 mb-2">Error
                                            </h2>
                                            <p id="purposeErrorMessage" class="text-gray-700"></p>
                                            <div class="flex justify-end mt-4">
                                                <button type="button" id="closeErrorModal"
                                                    class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                    Close
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="w-6/12 px-4">
                                        <div class="mt-3">
                                            <label>Transaction Narration </label>
                                            <textarea class="input w-full border mt-2" name="transaction_narration" placeholder="Enter Transaction Narration"><?php echo e(old('transaction_narration')); ?></textarea>
                                            <div class="text-red-500 text-sm mt-1 error-message"
                                                id="error-transaction-narration"></div>
                                        </div>
                                    </div>

                                    <div class="w-full px-4">
                                        <div class="mt-3">
                                            <label>Upload Images</label>
                                            <input type="file" class="w-full border mt-2 p-2 rounded"
                                                name="expense_files[]" id="expense_files"
                                                accept="image/*,application/pdf" multiple>
                                            <ul id="file-list" class="mt-2 text-sm text-gray-600 space-y-1">
                                            </ul>

                                            <div class="text-red-500 text-sm mt-1 error-message"
                                                id="error-expense-files"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    

            </div>
            <div class="sm:pl-5 mt-5">

                <a href="<?php echo e(route('expense.index')); ?>"><span
                        class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                        ← Back
                    </span></a>
                <button type="submit" class="button w-24 bg-theme-1 text-white">Save</button>
            </div>
        </div>
        </form>
    </div>
</div>
<!-- END: Horizontal Form -->
</div>
<!-- END: Select Options -->
</div>


<script>
    //organisation and accountype checking start.
    let purposes = <?php echo json_encode($purposes, 15, 512) ?>;
    let accountTypes = <?php echo json_encode($accountTypes, 15, 512) ?>;
    let orgSelect = document.getElementById('organisation_id');
    let accSelect = document.getElementById('account_type_id');
    let msg = document.getElementById('accountTypeMsg');

    const assets = <?php echo json_encode($assets, 15, 512) ?>;
    const liabilities = <?php echo json_encode($liabilities, 15, 512) ?>;

    let oldOrg = "<?php echo e(old('organisation_id', $orgId)); ?>";
    let oldAcc = "<?php echo e(old('account_type_id')); ?>";

    function populateAccountTypes(orgId) {
        accSelect.innerHTML = '<option value="">-- Select Division --</option>';

        if (orgId) {
            let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

            if (filtered.length > 0) {
                document.getElementById("accountTypeWrapper").style.display = "block";
                filtered.forEach(at => {
                    let option = document.createElement('option');
                    option.value = at.account_type_id;
                    option.textContent = at.account_type_Name;

                    if (oldAcc == at.account_type_id) {
                        option.selected = true;
                    }
                    accSelect.appendChild(option);
                });

                accSelect.disabled = false;
                msg.style.display = "none";
            } else {
                accSelect.disabled = true;
                msg.textContent = "No division found for this organisation.";
                msg.style.display = "block";
                document.getElementById("accountTypeWrapper").style.display = "none";
            }
        } else {
            accSelect.disabled = true;
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
            document.getElementById("accountTypeWrapper").style.display = "block";
        }
    }

    orgSelect.addEventListener('change', function() {
        populateAccountTypes(this.value);
    });

    accSelect.addEventListener('focus', function() {
        if (!orgSelect.value) {
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
            setTimeout(() => msg.style.display = "none", 2000);
        }
    });

    if (oldOrg) {
        populateAccountTypes(oldOrg);
    }
    //organisation and accountype checking end.


    $(document).ready(function() {

        $("input[name='type']").on("click", function(e) {
            const orgId = $("#organisation_id").val();
            const accountTypeId = $("#account_type_id").val();
            const $errorDiv = $("#error-organisation");
            const $errorDiv2 = $("#error-account-type");

            $errorDiv.text("");

            if (!orgId) {
                e.preventDefault();
                $errorDiv.text("Please select Organisation first.");
                return;
            }

            if (orgId != 2 && !accountTypeId) {
                e.preventDefault();
                $errorDiv2.text("Please select Division first.");
                return;
            }
        });

        function toggleExpenseHeadBtn() {
            const orgId = $("#organisation_id").val();
            const accountTypeId = $("#account_type_id").val();

            if (!orgId) {
                $("#addExpenseHeadBtn").addClass("hidden");
                // $("#addVendorBtn").addClass("hidden");
                return;
            }

            if (orgId == 2) {
                $("#addExpenseHeadBtn").removeClass("hidden");
                $("#addVendorBtn").removeClass("hidden");
            } else {
                if (accountTypeId) {
                    $("#addExpenseHeadBtn").removeClass("hidden");
                    $("#addVendorBtn").removeClass("hidden");
                } else {
                    $("#addExpenseHeadBtn").addClass("hidden");
                    $("#addVendorBtn").addClass("hidden");
                }
            }
        }
        $("#organisation_id, #account_type_id").on("change", toggleExpenseHeadBtn);
        toggleExpenseHeadBtn();

        $("#organisation_id").on("change", function() {
            $("#error-organisation").text("");
        });
        $("#account_type_id").on("change", function() {
            $("#error-account-type").text("");
        });




        $("#expenseForm").on("submit", function(e) {
            e.preventDefault();
            let formData = new FormData($('#expenseForm')[0]);

            $(".error-message").text("");
            $("input, select, textarea").removeClass("border-red-500");

            let isValid = true;
            let firstInvalidField = null;

            if ($.trim($("#organisation_id").val()) === "") {
                $("#error-organisation").text("Organisation is required");
                $("#organisation").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#organisation_id");
                isValid = false;
            }

            let orgId = $("#organisation_id").val();
            let filtered = accountTypes.filter(at => at.organisation_id == orgId);

            if (filtered.length > 0) {
                if ($.trim($("#account_type_id").val()) === "") {
                    $("#error-account-type").text("Division is required");
                    $("#account_type_id").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#account_type_id");
                    isValid = false;
                }
            }

            // if (!$hiddenId.val()) {
            //     e.preventDefault();
            //     $("#error-transaction-purpose").text("Purpose not in list . Please add the purpose. ");
            //     $input.addClass("border-red-500");
            // }
            // if (!$.trim($("#transaction_purpose_id").val())) {
            //     $("#error-transaction-purpose").text("Purpose not in list . Please add the purpose.");
            //     $("#transaction_purpose").addClass("border-red-500");
            //     isValid = false;
            // }
            if ($.trim($("#payment_type_id").val()) === "") {
                $("#error-payment-type").text("Payment Type is required");
                $("#payment_type_id").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#payment_type_id");
                isValid = false;
            } else {
                $("#error-payment-type").text("");
                $("#payment_type_id").removeClass("border-red-500");
            }

            if ($.trim($("#expense_head_id").val()) === "") {
                $("#error-expense-head").text("Expense Head is required");
                $("#expense_head_id").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#expense_head_id");
                isValid = false;
            }

            if ($.trim($("input[name='transaction_amount']").val()) === "") {
                $("#error-transaction-amount").text("Transaction Amount is required");
                $("input[name='transaction_amount']").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#transaction_amount");

                isValid = false;
            }

            if ($.trim($("input[name='transaction_date']").val()) === "") {
                $("#error-date").text("Transaction Date is required");
                $("input[name='transaction_date']").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#transaction_date");

                isValid = false;
            }

            // start custom for expense type and vendor list 
            let type = $("input[name='type']:checked").val();
            let payeeType = $("input[name='payee_type']:checked").val();

            if (type === "asset") {
                if ($.trim($("#assetHidden").val()) === "") {
                    $("#error-type-asset").text("Please select an Asset");
                    $("#assetInput").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#assetHidden");

                    isValid = false;
                }
            }

            if (type === "liability") {
                if ($.trim($("#liabilityHidden").val()) === "") {
                    $("#error-type-liability").text("Please select a Liability");
                    $("#liabilityInput").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#liabilityHidden");

                    isValid = false;
                }
            }

            if (payeeType === "internal") {
                if ($.trim($("#payeeHidden").val()) === "") {
                    $("#error-asset-payee").text("Please select a Staff member");
                    $("#payeeInput").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#payeeHidden");

                    isValid = false;
                }
            }

            if (payeeType === "external") {
                if ($.trim($("#vendorTotalAmount").val()) === "") {
                    $("#error-asset-payee-amount").text("Total Amount is required for Vendor payments");
                    $("#vendorTotalAmount").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#vendorTotalAmount");

                    isValid = false;
                }
                if ($.trim($("#payeeHidden").val()) === "") {
                    $("#error-asset-payee").text("Please select a Vendor");
                    $("#payeeInput").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#payeeHidden");

                    isValid = false;
                }

            }

            // end customValidation

            if (!isValid) {
                if (firstInvalidField) {
                    $('html, body').animate({
                        scrollTop: firstInvalidField.offset().top - 100
                    }, 500);
                    // firstInvalidField.focus();
                }
                return;
            }

            $.ajax({
                url: "<?php echo e(route('expense.store')); ?>",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        window.location.href = "<?php echo e(route('expense.index')); ?>";
                    } else {
                        alert("Something went wrong.");
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        let messages = [];
                        for (let key in errors) {
                            messages.push(errors[key][0]);
                        }
                        alert(messages.join("\n"));
                    } else {
                        alert("Something went wrong. Please try again.");
                        alert("Error: " + xhr.status + " - " + xhr.responseText);

                    }
                }
            });
        });

        $("#organisation_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-organisation").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#expense_head_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-expense-head").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#payment_type_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-payment-type").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#account_type_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-account-type").text("");
                $(this).removeClass("border-red-500");
            }
        });
        // $("#transaction_purpose").on("change", function() {
        //     if ($(this).val().trim() !== "") {
        //         $("#error-transaction-purpose").text("");
        //         $(this).removeClass("border-red-500");
        //     }
        // });

        $("input[name='transaction_amount']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-amount").text("");
                $(this).removeClass("border-red-500");
            }
        });

        $("input[name='transaction_reference']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-reference").text("");
                $(this).removeClass("border-red-500");
            }
        });

        $("input[name='transaction_date']").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-date").text("");
                $(this).removeClass("border-red-500");
            }
        });

        $("textarea[name='transaction_narration']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-narration").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#assetList").on("click", "li", function() {
            $("#assetHidden").val($(this).data("id"));
            $("#assetInput").val($(this).text());
            $("#error-type-asset").text("");
            $("#assetInput").removeClass("border-red-500");

            $("#assetList").addClass("hidden");
        });
        $("#liabilityList").on("click", "li", function() {
            $("#liabilityHidden").val($(this).data("id"));
            $("#liabilityInput").val($(this).text());
            $("#error-type-liability").text("");
            $("#liabilityInput").removeClass("border-red-500");

            $("#liabilityList").addClass("hidden");
        });
        $("#payeeList").on("click", "li", function() {
            $("#payeeHidden").val($(this).data("id"));
            $("#payeeInput").val($(this).text());
            $("#error-asset-payee").text("");
            $("#payeeInput").removeClass("border-red-500");

            $("#payeeList").addClass("hidden");
        });
        $("#vendorTotalAmount").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-asset-payee-amount").text("");
                $(this).removeClass("border-red-500");
            }
        });


        //for purposes ::

        // let $input = $("#transaction_purpose");
        // let $hiddenId = $("#transaction_purpose_id");
        // let $suggestionBox = $("#purpose-suggestions");

        // $input.on("input", function() {
        //     let query = $(this).val().toLowerCase();
        //     $suggestionBox.empty();
        //     $hiddenId.val("");

        //     if (query.length > 0) {
        //         let queryWords = query.split(" ");

        //         let matches = purposes.map(p => {
        //                 let name = p.name.toLowerCase();
        //                 let score = 0;
        //                 queryWords.forEach(qw => {
        //                     if (name.includes(qw)) score++;
        //                 });
        //                 return {
        //                     ...p,
        //                     score
        //                 };
        //             }).filter(p => p.score > 0)
        //             .sort((a, b) => b.score - a.score);

        //         if (matches.length > 0) {
        //             $suggestionBox.removeClass("hidden");
        //             $.each(matches, function(i, match) {
        //                 let $li = $("<li>")
        //                     .text(match.name)
        //                     .attr("data-id", match.id)
        //                     .addClass("px-3 py-2 hover:bg-gray-200 cursor-pointer")
        //                     .on("click", function() {
        //                         $input.val(match.name);
        //                         $hiddenId.val(match.id);
        //                         $suggestionBox.addClass("hidden");
        //                         $("#error-transaction-purpose").text("");
        //                     });
        //                 $suggestionBox.append($li);
        //             });
        //         } else {
        //             $suggestionBox.addClass("hidden");
        //         }
        //     } else {
        //         $suggestionBox.addClass("hidden");
        //     }
        // });

        // $(document).on("click", function(e) {
        //     if (!$(e.target).closest("#transaction_purpose, #purpose-suggestions").length) {
        //         $suggestionBox.addClass("hidden");
        //     }
        // });

        // $input.on("input", function() {
        //     let typedVal = $(this).val().trim().toLowerCase();
        //     let matched = purposes.find(p => p.name.toLowerCase() === typedVal);

        //     if (matched) {
        //         $hiddenId.val(matched.id);
        //         $("#error-transaction-purpose").text("");
        //         $input.removeClass("border-red-500");
        //     } else {
        //         $hiddenId.val("");
        //         $("#error-transaction-purpose").text("Purpose not in list . Please add the purpose. ");
        //         $input.addClass("border-red-500");
        //     }

        // });

        //end for purposes 
    });

    $("#transaction_reference").on("input", function() {
        let value = $(this).val();
        value = value.replace(/[^A-Za-z0-9]/g, "");
        if (value.length > 20) {
            value = value.substring(0, 20);
        }
        $(this).val(value);
        let errorDiv = $("#error-transaction-reference");
        if (value.length < 5) {
            errorDiv.text("Transaction reference must be at least 5 characters.");
        } else {
            errorDiv.text("");
        }
    });

    //puRpose add logic::

    // document.getElementById('addPurposeBtn').addEventListener('click', function() {
    //     document.getElementById('purposeModal').classList.remove('hidden');
    // });

    // document.getElementById('closeModal').addEventListener('click', function() {
    //     document.getElementById('purposeModal').classList.add('hidden');
    // });

    // document.getElementById('savePurpose').addEventListener('click', function() {
    //     let newPurpose = document.getElementById('newPurpose').value.trim();
    //     let purpose_for = "expense";
    //     if (newPurpose === "") return;

    //     fetch("<?php echo e(route('purpose.store')); ?>", {
    //             method: "POST",
    //             headers: {
    //                 "Content-Type": "application/json",
    //                 "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
    //             },
    //             body: JSON.stringify({
    //                 purpose: newPurpose,
    //                 purpose_for: purpose_for
    //             })
    //         })
    //         .then(async res => {
    //             let data = await res.json();

    //             if (!res.ok) {
    //                 showErrorModal(data.message || "Something went wrong while saving the purpose.");
    //                 return;
    //             }

    //             if (data.success) {
    //                 purposes.push({
    //                     id: data.purpose.id,
    //                     name: data.purpose.name
    //                 });

    //                 let ul = document.getElementById('purpose-suggestions');
    //                 let li = document.createElement('li');
    //                 li.textContent = data.purpose.name;
    //                 li.setAttribute("data-id", data.purpose.id);
    //                 li.classList.add("px-3", "py-2", "cursor-pointer", "hover:bg-gray-100");
    //                 li.addEventListener("click", function() {
    //                     document.getElementById("transaction_purpose").value = data.purpose
    //                         .name;
    //                     document.getElementById("transaction_purpose_id").value = data.purpose
    //                         .id;
    //                     ul.classList.add("hidden");
    //                 });
    //                 ul.appendChild(li);

    //                 document.getElementById("transaction_purpose").value = data.purpose.name;
    //                 document.getElementById("transaction_purpose_id").value = data.purpose.id;

    //                 document.getElementById('newPurpose').value = "";
    //                 document.getElementById('purposeModal').classList.add('hidden');

    //                 showSuccessModal();
    //             }
    //         })
    //         .catch(err => {
    //             console.error(err);
    //             showErrorModal("Network error. Please try again.");
    //         });
    // });

    // function showSuccessModal() {
    //     const modal = document.getElementById('purposeSuccessModal');
    //     modal.classList.remove('hidden');

    //     document.getElementById('closeSuccessModal').addEventListener('click', function() {
    //         modal.classList.add('hidden');
    //     });

    //     setTimeout(() => {
    //         modal.classList.add('hidden');
    //     }, 3000);
    // }

    // function showErrorModal(message) {
    //     const modal = document.getElementById('purposeErrorModal');
    //     const msgBox = document.getElementById('purposeErrorMessage');

    //     msgBox.textContent = message;
    //     modal.classList.remove('hidden');

    //     document.getElementById('closeErrorModal').addEventListener('click', function() {
    //         modal.classList.add('hidden');
    //     });
    // }

    // purpose add logic ends::


    //for assets and liabilities checkbox logic:
    document.addEventListener("DOMContentLoaded", function() {
        const radios = document.querySelectorAll(".type-radio");
        const assetSection = document.getElementById("assetSection");
        const liabilitySection = document.getElementById("liabilitySection");
        const clearBtn = document.getElementById("clearTypeSelection");

        const assetInput = document.getElementById("assetInput");
        const assetList = document.getElementById("assetList");
        const assetHidden = document.getElementById("assetHidden");

        const liabilityInput = document.getElementById("liabilityInput");
        const liabilityList = document.getElementById("liabilityList");
        const liabilityHidden = document.getElementById("liabilityHidden");

        radios.forEach(radio => {
            radio.addEventListener("change", function() {
                if (this.value === "asset") {
                    assetSection.classList.remove("hidden");
                    liabilitySection.classList.add("hidden");
                    liabilityInput.value = "";
                    liabilityHidden.value = "";
                } else if (this.value === "liability") {
                    liabilitySection.classList.remove("hidden");
                    assetSection.classList.add("hidden");
                    assetInput.value = "";
                    assetHidden.value = "";
                }
                clearBtn.classList.remove("hidden");
            });
        });

        assetInput.addEventListener("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');

            const filter = this.value.toLowerCase();
            let hasMatch = false;
            assetList.querySelectorAll("li").forEach(li => {
                if (li.textContent.toLowerCase().includes(filter)) {
                    li.style.display = "block";
                    hasMatch = true;
                } else {
                    li.style.display = "none";
                }
            });
            assetList.classList.toggle("hidden", !hasMatch || filter === "");

            if (filter === "") {
                assetList.classList.add("hidden");
                document.getElementById("openAssetModalBtn").classList.add("hidden");
            } else if (hasMatch) {
                assetList.classList.remove("hidden");
                document.getElementById("openAssetModalBtn").classList.add("hidden");
            } else {
                assetList.classList.add("hidden");
                document.getElementById("openAssetModalBtn").classList.remove("hidden");
            }
        });

        assetList.addEventListener("click", function(e) {
            if (e.target.tagName === "LI") {
                assetInput.value = e.target.textContent;
                assetHidden.value = e.target.dataset.id;
                assetList.classList.add("hidden");

                assetInput.readOnly = true;
            }
        });

        liabilityInput.addEventListener("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');

            const filter = this.value.toLowerCase();
            let hasMatch = false;
            liabilityList.querySelectorAll("li").forEach(li => {
                if (li.textContent.toLowerCase().includes(filter)) {
                    li.style.display = "block";
                    hasMatch = true;
                } else {
                    li.style.display = "none";
                }
            });
            liabilityList.classList.toggle("hidden", !hasMatch || filter === "");
            if (filter === "") {
                liabilityList.classList.add("hidden");
                document.getElementById("openLiabilityModalBtn").classList.add("hidden");
            } else if (hasMatch) {
                liabilityList.classList.remove("hidden");
                document.getElementById("openLiabilityModalBtn").classList.add("hidden");
            } else {
                liabilityList.classList.add("hidden");
                document.getElementById("openLiabilityModalBtn").classList.remove("hidden");
            }
        });

        liabilityList.addEventListener("click", function(e) {
            if (e.target.tagName === "LI") {
                liabilityInput.value = e.target.textContent;
                liabilityHidden.value = e.target.dataset.id;
                liabilityList.classList.add("hidden");


                liabilityInput.readOnly = true;
            }
        });
        clearBtn.addEventListener("click", function() {
            radios.forEach(radio => radio.checked = false);
            assetSection.classList.add("hidden");
            liabilitySection.classList.add("hidden");
            assetInput.value = "";
            liabilityInput.value = "";
            assetHidden.value = "";
            liabilityHidden.value = "";
            // clearBtn.classList.add("hidden");

            liabilityInput.readOnly = false;
            assetInput.readOnly = false;
            document.getElementById("openAssetModalBtn").classList.add("hidden");
            document.getElementById("openLiabilityModalBtn").classList.add("hidden");

            assetList.classList.add("hidden");
            liabilityList.classList.add("hidden");
        });
    });
    //end for assets and liabilities checkbox logic 

    // for vendor listing:
    document.addEventListener("DOMContentLoaded", function() {
        const radios = document.querySelectorAll(".payee-type-radio");
        const payeeWrapper = document.getElementById("payeeWrapper");
        const payeeInput = document.getElementById("payeeInput");
        const payeeList = document.getElementById("payeeList");
        const payeeHidden = document.getElementById("payeeHidden");
        const clearBtn = document.getElementById("clearPayeeSelection");
        const vendorAmountWrapper = document.getElementById("vendorAmountWrapper");


        let currentType = null;

        radios.forEach(radio => {
            radio.addEventListener("change", function() {
                currentType = this.value;
                payeeWrapper.classList.remove("hidden");
                payeeInput.value = "";
                payeeHidden.value = "";
                payeeList.classList.add("hidden");
                clearBtn.classList.remove("hidden");
                vendorAmountWrapper.classList.add("hidden");
                payeeInput.readOnly = false;
            });
        });

        payeeInput.addEventListener("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');

            const filter = this.value.toLowerCase();
            let hasMatch = false;
            payeeList.querySelectorAll("li").forEach(li => {
                if (li.dataset.type === currentType &&
                    li.textContent.toLowerCase().includes(filter)) {
                    li.style.display = "block";
                    hasMatch = true;
                } else {
                    li.style.display = "none";
                }
            });
            payeeList.classList.toggle("hidden", !hasMatch || filter === "");
        });

        payeeList.addEventListener("click", function(e) {

            if (e.target.tagName === "LI") {
                payeeInput.value = e.target.textContent;
                payeeHidden.value = e.target.dataset.id;
                payeeList.classList.add("hidden");
                payeeInput.readOnly = true;
            }

            if (e.target.dataset.type === "external") {
                vendorAmountWrapper.classList.remove("hidden");
            } else {
                vendorAmountWrapper.classList.add("hidden");
            }
        });

        clearBtn.addEventListener("click", function() {
            radios.forEach(r => r.checked = false);
            payeeWrapper.classList.add("hidden");
            payeeInput.value = "";
            payeeHidden.value = "";
            payeeList.classList.add("hidden");
            vendorAmountWrapper.classList.add("hidden");
            // clearBtn.classList.add("hidden");
            currentType = null;
            payeeInput.readOnly = false;
        });
    });
    // end for vendor listing:

    //start for vendor add logic

    $('#addVendorBtn').on('click', function() {
        let selectedType = $("input[name='payee_type']:checked").val();

        if (selectedType) {
            $("#vendor_type_new").val(selectedType);
        } else {
            $("#vendor_type_new").val("");
        }
        $('#vendorModal').removeClass('hidden');
    });
    $('#closeVendorModal').on('click', () => $('#vendorModal').addClass('hidden'));

    $('#saveVendor').on('click', function() {
        const vendorName = $('#vendor_name').val().trim();
        const errorEl = $('#error-vendor-name');

        errorEl.text('');

        if (!vendorName.match(/^[a-zA-Z\s]+$/)) {
            errorEl.text('Vendor name must contain only letters and spaces.');
            return;
        }

        let vendorData = {
            _token: "<?php echo e(csrf_token()); ?>",
            vendor_type: $('#vendor_type_new').val(),
            vendor_name: $('#vendor_name').val(),
            vendor_contact_person: $('#vendor_contact_person').val() ?? null,
            vendor_phone_number: $('#vendor_phone_number').val(),
            vendor_email: $('#vendor_email').val(),
            vendor_address: $('#vendor_address').val(),
            vendor_gst_number: $('#vendor_gst_number').val(),
            vendor_pan_number: $('#vendor_pan_number').val(),
            vendor_payment_terms: $('#vendor_payment_terms').val() ?? null,
            vendor_bank_account_number: $('#vendor_bank_account_number').val(),
            vendor_bank_ifsc: $('#vendor_bank_ifsc').val(),

        };

        $.ajax({
            url: "<?php echo e(route('vendor.store')); ?>",
            type: "POST",
            data: vendorData,
            success: function(res) {
                if (res.success) {
                    $('#vendorModal').addClass('hidden');
                    $('#vendorSuccessModal').removeClass('hidden');

                    $('#payeeVendorRadio').prop('checked', true).trigger('change');

                    $('#payeeInput').val(res.vendor.vendor_name);
                    $('#payeeHidden').val(res.vendor.vendor_id);

                    if (res.vendor.vendor_type === "external") {
                        $('#vendorAmountWrapper').removeClass('hidden');
                        $('#amountPaidWrapper').removeClass('hidden');
                    } else {
                        $('#vendorAmountWrapper').addClass('hidden');
                        $('#amountPaidWrapper').removeClass('hidden');
                    }

                } else {
                    $('#vendorErrorMessage').text(res.message || "Failed to save vendor.");
                    $('#vendorErrorModal').removeClass('hidden');
                }
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                $('#vendorErrorMessage').text("Error: Could not save vendor.");
                $('#vendorErrorModal').removeClass('hidden');
            }
        });
    });

    $('#vendorCloseSuccessModal').on('click', () => $('#vendorSuccessModal').addClass('hidden'));
    $('#vendorCloseErrorModal').on('click', () => $('#vendorErrorModal').addClass('hidden'));


    // end for vendor add logic 

    //for file upload logic and append names 
    document.getElementById('expense_files').addEventListener('change', function(e) {
        const fileList = document.getElementById('file-list');
        const errorDiv = document.getElementById('error-expense-files');
        fileList.innerHTML = "";
        errorDiv.textContent = "";

        const maxTotalSize = 3 * 1024 * 1024;
        let totalSize = 0;
        let hasInvalidType = false;

        for (let i = 0; i < this.files.length; i++) {
            const file = this.files[i];
            totalSize += file.size;

            if (!file.type.startsWith("image/") && file.type !== "application/pdf") {
                hasInvalidType = true;
            }
        }
        if (totalSize > maxTotalSize) {
            // alert("Total file size must not exceed 3 MB.\nYou selected " + (totalSize / (1024 * 1024)).toFixed(
            //     2) + " MB.");
            errorDiv.textContent = "Total file size must not exceed 3 MB.\nYou selected " + (totalSize / (1024 *
                1024)).toFixed(
                2) + " MB.";
            this.value = "";
            return;
        }
        if (hasInvalidType) {
            // alert("Invalid file type. Only images or PDFs allowed.");
            errorDiv.textContent = "Invalid file type. Only images or PDFs up to 3 MB are allowed.";
            this.value = "";
            return;
        }

        for (let i = 0; i < this.files.length; i++) {
            const li = document.createElement("li");
            li.textContent = this.files[i].name;
            fileList.appendChild(li);
        }
    });
    // end for file upload logic and append names 

    function cleanAmount(val) {
        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }
        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (val.startsWith("0.") || val === "0") {
            val = val.replace(/^0+/, "");
        }
        return val;
    }
    $("input[name='transaction_amount'], input[name='vendor_total_amount']").on("input", function() {
        this.value = cleanAmount(this.value);
    });


    // start: add expense heads logic.
    $("#addExpenseHeadBtn").on("click", function() {

        $("#expense_account_type_id").val($("#account_type_id").val());
        $("#expense_organisation_id_new").val($("#organisation_id").val());

        $("#expenseHeadModal").removeClass("hidden");
    });
    $("#closeExpenseHeadModal").on("click", function() {
        $("#expenseHeadModal").addClass("hidden");
    });
    $("#closeExpenseSuccessModal").on("click", function() {
        $("#expenseSuccessModal").addClass("hidden");
    });
    $("#closeExpenseErrorModal").on("click", function() {
        $("#expenseErrorModal").addClass("hidden");
    });
    $("#saveExpenseHeadBtn").on("click", function() {
        let payload = {
            _token: $("meta[name='csrf-token']").attr("content"),
            organisation_id: $('#expense_organisation_id_new').val().trim(),
            expense_head_name: $("#expense_head_name").val().trim(),
            account_type_id: $("#expense_account_type_id").val() || null,
            expense_head_group_id: $("#expense_head_group_id").val() || null,
            expense_head_group_opening_balance: $("#expense_head_group_opening_balance").val() || null
        };

        $.ajax({
            url: "<?php echo e(route('expensehead.store')); ?>",
            type: "POST",
            data: JSON.stringify(payload),
            contentType: "application/json",
            success: function(response) {
                if (response.success) {
                    $("#expenseHeadModal").addClass("hidden");
                    $("#expenseSuccessModal").removeClass("hidden");
                    let select = $("#expense_head_id");
                    let option = $("<option>")
                        .val(response.new_id)
                        .text(response.name)
                        .prop("selected", true);
                    select.append(option);
                    $("#expense_head_name").val("");
                    $("#expense_account_type_id").val("");
                    $("#expense_head_group_id").val("");
                    $("#expense_head_group_opening_balance").val("");
                }
            },
            error: function(xhr) {
                let res = xhr.responseJSON;
                if (res && res.errors) {
                    let messages = Object.values(res.errors).flat().join("<br>");
                    $("#expenseErrorMessage").html(messages);
                } else {
                    $("#expenseErrorMessage").text("Something went wrong.");
                }
                $("#expenseErrorModal").removeClass("hidden");
            }
        });
    });
    // end logic add expense heads:

    // start: Add Asset logic
    $("#openAssetModalBtn").on("click", function() {
        $("#organisation_id_new").val($("#organisation_id").val());
        $("#account_type_id_new2").val($("#account_type_id").val());

        if ($("#organisation_id_new").val() == 2) {
            $("#account_type_asset").hide();
        } else {
            $("#account_type_asset").show();
        }
        $("#assetModal").removeClass("hidden");
    });

    $("#closeAssetModal").on("click", function() {
        $("#assetModal").addClass("hidden");
    });

    $("#closeAssetSuccessModal").on("click", function() {
        $("#assetSuccessModal").addClass("hidden");
    });

    $("#closeAssetErrorModal").on("click", function() {
        $("#assetErrorModal").addClass("hidden");
    });

    $("#saveAssetBtn").on("click", function() {
        $(".error-message").text("");


        let payload = {
            _token: $("meta[name='csrf-token']").attr("content"),
            organisation_id: $("#organisation_id_new").val() || $("#organisation_id").val(),
            account_type_id: $("#account_type_id_new2").val() || $("#account_type_id").val(),
            asset_name: $("#asset_name").val().trim(),
            asset_type: $("#asset_type").val().trim(),
            depreciation: $("#depreciation").val(),
            asset_opening_balance: $("#asset_opening_balance").val(),
            asset_purchase_date: $("#asset_purchase_date").val(),
            financial_year_id: $("#financial_year_id").val(),
            asset_purchase_cost: $("#asset_purchase_cost").val(),
            asset_useful_life: $("#asset_useful_life").val(),
        };

        $.ajax({
            url: "<?php echo e(route('asset.store')); ?>",
            type: "POST",
            data: JSON.stringify(payload),
            contentType: "application/json",
            success: function(res) {
                if (res.success) {
                    $("#assetModal").addClass("hidden");
                    $("#assetSuccessModal").removeClass("hidden");


                    const li = $("<li>")
                        .attr("data-id", res.new_id)
                        .addClass("px-3 py-2 hover:bg-gray-100 cursor-pointer")
                        .text(res.asset_name || res.name);

                    $("#assetList").append(li).removeClass("hidden");
                    // $("#assetInput").val(res.asset_name || res.name).prop("readonly", true);
                    $("#assetHidden").val(res.new_id);
                    $("#assetSuccessModal").css("z-index", "9999");

                }
            },
            error: function(xhr) {
                let res = xhr.responseJSON;
                if (res && res.errors) {
                    Object.keys(res.errors).forEach(function(key) {
                        $("#error-" + key.replace(/_/g, "-")).text(res.errors[key][0]);
                    });
                } else {
                    $("#assetErrorMessage").text("Something went wrong.");
                    $("#assetErrorModal").removeClass("hidden");
                }
            },
        });
    });
    // end: Add Asset logic


    // start: Add Liability logic
    $("#openLiabilityModalBtn").on("click", function() {
        $("#liability_organisation_id").val($("#organisation_id").val());
        $("#liability_account_type_id").val($("#account_type_id").val());

        if ($("#liability_organisation_id").val() == 2) {
            $("#account_type_liability").hide();
        } else {
            $("#account_type_liability").show();
        }
        $("#liabilityModal").removeClass("hidden");
    });

    $("#closeLiabilityModal").on("click", function() {
        $("#liabilityModal").addClass("hidden");
    });

    $("#closeLiabilitySuccessModal").on("click", function() {
        $("#liabilitySuccessModal").addClass("hidden");
    });

    $("#closeLiabilityErrorModal").on("click", function() {
        $("#liabilityErrorModal").addClass("hidden");
    });

    $("#saveLiabilityBtn").on("click", function() {
        $(".error-message").text(""); // clear errors

        let payload = {
            _token: $("meta[name='csrf-token']").attr("content"),
            organisation_id: $("#liability_organisation_id").val() || $("#organisation_id").val(),
            account_type_id: $("#liability_account_type_id").val() || $("#account_type_id").val(),
            financial_year_id: $("#liability_financial_year_id").val(),
            liability_name: $("#liability_name").val().trim(),
            liability_type: $("#liability_type").val().trim(),
            liability_date: $("#liability_date").val(),
            liability_opening_balance: $("#liability_opening_balance").val(),
            liability_amount: $("#liability_amount").val() ?? 0,
            liability_due_date: $("#liability_due_date").val(),
            liability_status: $("#liability_status").val(),
        };

        $.ajax({
            url: "<?php echo e(route('liability.store')); ?>",
            type: "POST",
            data: JSON.stringify(payload),
            contentType: "application/json",
            success: function(res) {
                if (res.success) {
                    $("#liabilityModal").addClass("hidden");
                    $("#liabilitySuccessModal").removeClass("hidden");

                    const li = $("<li>")
                        .attr("data-id", res.new_id)
                        .addClass("px-3 py-2 hover:bg-gray-100 cursor-pointer")
                        .text(res.liability_name || res.name);

                    $("#liabilityList").append(li).removeClass("hidden");

                    // $("#liabilityInput").val(res.liability_name || res.name).prop("readonly", true);
                    $("#liabilityHidden").val(res.new_id);
                    $("#liabilitySuccessModal").css("z-index", "9999");
                }
            },
            error: function(xhr) {
                const res = xhr.responseJSON;

                // clear previous errors
                $(".error-message").text("");

                if (res && res.errors) {
                    Object.keys(res.errors).forEach(function(key) {
                        const errorDiv = $("#error-liability-" + key.replace(/_/g, "-"));
                        if (errorDiv.length) {
                            errorDiv.text(res.errors[key][0]);
                        }
                    });
                } else if (res && res.message) {
                    $("#liabilityErrorMessage").text(res.message);
                    $("#liabilityErrorModal").removeClass("hidden");
                } else {
                    $("#liabilityErrorMessage").text("Something went wrong.");
                    $("#liabilityErrorModal").removeClass("hidden");
                }
            },
        });
    });
    // end: Add Liability logic


    // validations : for asset and liability add form 
    const assetName = document.getElementById("asset_name");
    const assetType = document.getElementById("asset_type");
    const depreciation = document.getElementById("depreciation");

    assetName.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-asset-name").textContent =
                "Asset name must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-asset-name").textContent = "";
        }
    });

    assetType.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-asset-type").textContent =
                "Asset type must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-asset-type").textContent = "";
        }
    });

    depreciation.addEventListener("input", function() {
        let val = this.value.trim();

        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }

        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (!val.startsWith("0.") && val !== "0") {
            val = val.replace(/^0+/, "");
        }

        this.value = val;
        if (val !== "" && !/^\d+(\.\d+)?$/.test(val)) {
            document.getElementById("error-depreciation").textContent =
                "Depreciation must be a valid number (e.g., 3, 3.5, 45.6).";
        } else {
            document.getElementById("error-depreciation").textContent = "";
        }
    });

    const liabilityName = document.getElementById("liability_name");
    const liabilityType = document.getElementById("liability_type");
    const liabilityAmount = document.getElementById("liability_amount");

    liabilityName.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-liability-name").textContent =
                "Liability name must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-liability-name").textContent = "";
        }
    });

    liabilityType.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-liability-type").textContent =
                "Liability type must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-liability-type").textContent = "";
        }
    });


    const vendorName = document.getElementById("vendor_name");
    const vendorContact = document.getElementById("vendor_contact_person");
    const vendorPhone = document.getElementById("vendor_phone_number");
    const vendorPAN = document.getElementById("vendor_pan_number");
    const vendorIFSC = document.getElementById("vendor_bank_ifsc");

    // Vendor Name - only letters and spaces
    vendorName.addEventListener("input", function() {
        this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        document.getElementById("error-vendor-name").textContent =
            this.value === '' ? "Vendor name must contain only letters and spaces." : "";
    });

    // $("#vendor_name").on("input", function() {
    //     this.value = this.value.replace(/[^0-9]/g, '');
    // });

    // end for validation logic for asset and liabilities form.
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/auth/transactions/expense/create.blade.php ENDPATH**/ ?>