<?php $__env->startSection('content'); ?>
    <div class="intro-y col-span-12 lg:col-span-12">
        <form name="expense">
            <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
                <h2 class="text-xl font-bold mb-6">Add New Expense Head</h2>
                <?php
                    $orgId = \App\Models\Organisation::current()->organisation_id;
                ?>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="mt-3">
                            <label>Organisation <span style="color: red">*</span></label>
                            <select id="organisation_id" name="organisation_id" class="input w-full border mt-2" disabled>
                                <option value="">-- Select Organisation --</option>
                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($organisation->organisation_id); ?>"
                                        <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                        <?php echo e($organisation->organisation_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-organisation"></div>
                        </div>
                    </div>
                    <input type="hidden" value="<?php echo e($orgId); ?>" id="organisation_id" name="organisation_id">
                    <div>
                        <div class="mt-3" id="accountTypeWrapper">
                            <label>Division</label>
                            <select id="account_type_id" name="account_type_id" class="input w-full border mt-2">
                                <option value="">-- Select Account Type --</option>
                            </select>
                            <small id="accountTypeMsg" class="text-red-500" style="display:none;">
                                Please select organisation first
                            </small>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-account-type"></div>
                        </div>
                    </div>

                    <!-- Expense Head Group -->
                    <div>
                        <label class="block font-medium">Expense Head Group</label>
                        <select id="expense_head_group_id" name="expense_head_group_id"
                            class="w-full border p-2 rounded custm-drpdwn mt-2">
                            <option value="">-- Select Expense Head Group --</option>
                            <?php $__currentLoopData = $expenseHeadGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($group->expense_head_group_ID); ?>">
                                    <?php echo e($group->expense_head_group_Name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-expense-head-group"></div>
                    </div>
                    <div>
                        <label class="block font-medium">Expense Head Name <span class="text-red-500">*</span></label>
                        <input type="text" id="expense_head_name" name="expense_head_name" class="w-full border p-2 rounded mt-2">
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-expense-head-name"></div>
                    </div>


                    <!-- Expense Head Name -->

                </div>

                <div id="asset_type" class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                </div>

                <!-- Buttons -->
                <div class="sm:pl-5 mt-5">
                    <a href="<?php echo e(route('expensehead.index')); ?>"
                        class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                    <button type="button" id="saveExpenseHead" class="button w-24 bg-theme-1 text-white">Save</button>
                </div>
            </div>
        </form>
    </div>
<script src="<?php echo e(asset('js/skj-validations@v1.js')); ?>"></script>
    <script>
        //organisation and accountype checking start.
        let accountTypes = <?php echo json_encode($accountTypes, 15, 512) ?>;
        let orgSelect = document.getElementById('organisation_id');
        let accSelect = document.getElementById('account_type_id');
        let msg = document.getElementById('accountTypeMsg');


        let oldOrg = "<?php echo e(old('organisation_id', $orgId)); ?>";
        let oldAcc = "<?php echo e(old('account_type_id')); ?>";

        function populateAccountTypes(oldOrg) {
            accSelect.innerHTML = '<option value="">-- Select Account Type --</option>';

            if (oldOrg) {
                let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

                if (filtered.length > 0) {
                    document.getElementById("accountTypeWrapper").style.display = "block";
                    filtered.forEach(at => {
                        let option = document.createElement('option');
                        option.value = at.account_type_id;
                        option.textContent = at.account_type_Name;

                        if (oldAcc == at.account_type_id) {
                            option.selected = true;
                        }
                        accSelect.appendChild(option);
                    });

                    accSelect.disabled = false;
                    msg.style.display = "none";
                } else {
                    accSelect.disabled = true;
                    msg.textContent = "No account types found for this organisation.";
                    msg.style.display = "block";
                    document.getElementById("accountTypeWrapper").style.display = "none";
                }
            } else {
                accSelect.disabled = true;
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
            }
        }

        orgSelect.addEventListener('change', function() {
            populateAccountTypes(this.value);
        });

        accSelect.addEventListener('focus', function() {
            if (!orgSelect.value) {
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
                setTimeout(() => msg.style.display = "none", 2000);
            }
        });

        if (oldOrg) {
            populateAccountTypes(oldOrg);
        }
        //organisation and accountype checking end.




        document.addEventListener("DOMContentLoaded", function() {
            document.getElementById("saveExpenseHead").addEventListener("click", function() {
                // Clear previous errors
                document.querySelectorAll('.error-message').forEach(el => el.innerText = '');

                // Get the main values
                const organisation_id = document.getElementById("organisation_id").value;
                const account_type_id = document.getElementById("account_type_id").value;
                const expense_head_group_id = document.getElementById("expense_head_group_id").value;
                const expense_head_name = document.getElementById("expense_head_name").value;

                // Base form data
                let formData = {
                    organisation_id: organisation_id,
                    account_type_id: account_type_id,
                    expense_head_group_id: expense_head_group_id || null,
                    expense_head_name: expense_head_name,
                    _token: "<?php echo e(csrf_token()); ?>"
                };

                // ✅ Add additional fields if group_id == 3
                if (parseInt(expense_head_group_id) === 3) {
                    const $rateField = $("#depriciation_rate");

                    // Validate the rate field before submit
                    const isRateValid = validateDepreciation($rateField);
                    if (!isRateValid) {
                        return; // ❌ Stop submission if invalid
                    }

                    formData.head_type = $("#assetType").val() || null;
                    formData.depriciation = $rateField.val() || null;
                    formData.rateEXT = $('#rte_extention').val() || null;
                    formData.depriciation_rate = formData.rateEXT === 'amount'? formData.depriciation: (formData.depriciation || '') + (formData.rateEXT || '');
                    formData.depriciation_tenure = $("#depriciation_tenure").val() || 12;
                } else {
                    formData.head_type = $("#paymentType").val() || null;
                }

                // Send AJAX request
                fetch("<?php echo e(route('expensehead.store')); ?>", {
                    method: "POST",
                    headers: {
                        "Accept": "application/json",
                        "X-Requested-With": "XMLHttpRequest",
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                    },
                    body: JSON.stringify(formData)
                })
                .then(async response => {
                    let data = await response.json();

                    if (response.ok) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: data.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = "<?php echo e(route('expensehead.index')); ?>";
                        });
                    } else if (response.status === 422) {
                        // Validation errors
                        if (data.errors.expense_head_name) {
                            document.getElementById("error-expense-head-name").innerText = data.errors.expense_head_name[0];
                        }
                        if (data.errors.expense_head_group_id) {
                            document.getElementById("error-expense-head-group").innerText = data.errors.expense_head_group_id[0];
                        }
                        if (data.errors.account_type_id) {
                            document.getElementById("error-account-type").innerText = data.errors.account_type_id[0];
                        }
                        if (data.errors.organisation_id) {
                            document.getElementById("error-organisation").innerText = data.errors.organisation_id[0];
                        }
                        if (data.errors.asset_type) {
                            document.getElementById("error-asset-type").innerText = data.errors.asset_type[0];
                        }
                        if (data.errors.depriciation_rate) {
                            document.getElementById("error-depriciation-rate").innerText = data.errors.depriciation_rate[0];
                        }
                        if (data.errors.depriciation_tenure) {
                            document.getElementById("error-depriciation-tenure").innerText = data.errors.depriciation_tenure[0];
                        }
                    } else {
                        Swal.fire('Error', data.message || 'Something went wrong!', 'error');
                    }
                })
                .catch(error => {
                    console.error(error);
                    Swal.fire('Error', 'An error occurred!', 'error');
                });
            });
        });



        $("#expense_head_name").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z&\s]/g, '');
        });

        $(document).ready(function() {
            //  Correct: just assign the template string to the variable
            let asset_html = `
                <div>
                    <label class="block font-medium text-gray-700">Choose Asset Type</label>
                    <div class="flex space-x-6 mt-2">
                        <label class="flex items-center space-x-2">
                            <input type="radio" name="asset_type" value="fixed_asset" id="assetType" class="w-4 h-4">
                            <span>Fixed Assets</span>
                        </label>
                        <label class="flex items-center space-x-2">
                            <input type="radio" name="asset_type" value="current_asset" id="assetType" class="w-4 h-4">
                            <span>Current Assets</span>
                        </label>
                        <button type="button" id="clearSelection" class="ml-4 px-3 py-1 bg-gray-200 text-gray-700 rounded hover:bg-gray-300">
                            Clear
                        </button>
                    </div>
                </div>
                <div>
                    <label class="block font-medium">Depreciation Rate (% or Amount) <span class="text-red-500"></span></label>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <input type="text" id="depriciation_rate" name="depriciation_rate" class="w-full border p-2 rounded mt-2">
                        </div>
                        <div>
                            <select id="rte_extention" name="rte_extention" class="w-full border p-2 rounded custm-drpdwn mt-2">
                                <option value="">
                            --Select  --
                        </option>
                                <option value="amount">
                               Amount
                                </option>
                                <option value="%">
                                    Percentage(%)
                                </option>
                            </select>
                        </div>
                    </div>

                </div>
                <div>
                    <label class="block font-medium">Depreciation Tenure</label>
                    <select id="depriciation_tenure" name="depriciation_tenure" class="w-full border p-2 rounded custm-drpdwn mt-2">
                        <option value="">
                            --Select Tenior --
                        </option>
                        <option value="6">
                           6 Months
                        </option>
                        <option value="12">
                            Yearly
                        </option>
                    </select>
                    <div class="text-red-500 text-sm mt-1 error-message" id="error-expense-head-group"></div>
                </div>
            `;
            let payment_html = `<div class="flex space-x-6 mt-2">
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" name="payment_type" value="payment" id="paymentType" class="w-4 h-4"><label class="block font-medium text-gray-700">This expense mark as <b>Payment</b></label>
                        </label>
                    </div>`;

            $('#expense_head_group_id').on('change', function() {
                let expense_head_group = $(this).val();

                if (expense_head_group != '' && expense_head_group == 3) {
                    $('#asset_type').html(asset_html);

                } else {
                    // ❌ .html() with no arguments does nothing
                    // ✅ Use .empty() or .html('') to clear content
                    $('#asset_type').html(payment_html);
                }
            });

            // Handle the Clear button click dynamically (since button is added after change)
            $(document).on('click', '#clearSelection', function() {
                $('input[name="type"]').prop('checked', false);
            });


        });



    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/auth/expenseHead/create.blade.php ENDPATH**/ ?>