<?php $__env->startSection('content'); ?>
    <!-- Main Content -->
    <div class="col-span-12 xxl:col-span-9 grid grid-cols-12 gap-6 px-4 sm:px-6 lg:px-8">
        <!-- Welcome Section -->
        <div class="col-span-12 mt-8">
            <div
                class="bg-white shadow-lg rounded-2xl p-6 sm:p-8 border border-gray-100 transition-all duration-300 hover:shadow-xl">
                <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 flex items-center gap-2">
                    Welcome back, <span class="text-blue-600"><?php echo e(Auth::user()->name); ?></span>
                </h2>
                <div class="mt-6 grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6">
                    <div
                        class="bg-gradient-to-r from-indigo-50 to-indigo-100 border border-indigo-200 rounded-xl p-5 transition-transform duration-300 hover:scale-105">
                        <h4 class="text-xs sm:text-sm text-gray-500 uppercase tracking-wider font-medium">Current Year</h4>
                        <p class="text-lg sm:text-xl font-semibold text-gray-800 mt-2">
                            <?php echo e(\App\Models\AccountingYear::current()->accounting_year_financial ?? 'No Selected'); ?>

                        </p>
                    </div>
                    <div
                        class="bg-gradient-to-r from-green-50 to-green-100 border border-green-200 rounded-xl p-5 transition-transform duration-300 hover:scale-105">
                        <h4 class="text-xs sm:text-sm text-gray-500 uppercase tracking-wider font-medium">Current
                            Organisation</h4>
                        <p class="text-lg sm:text-xl font-semibold text-gray-800 mt-2">
                            <?php echo e(\App\Models\Organisation::current()->organisation_name ?? 'No Selected'); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cards Section -->
        
        <!-- End Cards Section -->
    </div>

    <!-- Sidebar Section -->
    <div class="col-span-12 xxl:col-span-3 xxl:border-l border-gray-200 -mb-10 pb-10">
        <div class="xxl:pl-6 grid grid-cols-12 gap-6" style="padding-top: 30px;">
            <!-- Cash in Hand Card -->
            <div class="col-span-12 sm:col-span-6 xxl:col-span-12">
                <div
                    class="bg-white shadow-lg rounded-2xl p-6 border border-gray-100 hover:shadow-xl transition-all duration-300">
                    <div class="flex items-center justify-between">
                        <div>
                            <h5 class="text-gray-500 text-sm font-medium uppercase tracking-wide">Cash in Hand</h5>
                            <h2 class="text-2xl font-bold text-gray-800 mt-2">
                                ₹ <?php echo e(number_format($totalCash ?? 0, 2)); ?>

                            </h2>
                        </div>
                        <div class="bg-green-100 p-3 rounded-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-green-600" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8V6m0 12v2m6-12a9 9 0 11-12 0 9 9 0 0112 0z" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cash at Bank Card -->
            <div class="col-span-12 sm:col-span-6 xxl:col-span-12">
                <div
                    class="bg-white shadow-lg rounded-2xl p-6 border border-gray-100 hover:shadow-xl transition-all duration-300">
                    <div class="flex items-center justify-between">
                        <div>
                            <h5 class="text-gray-500 text-sm font-medium uppercase tracking-wide">Cash at Bank</h5>
                            <h2 class="text-2xl font-bold text-gray-800 mt-2">
                                ₹ <?php echo e(number_format($totalBank ?? 0, 2)); ?>

                            </h2>
                        </div>
                        <div class="bg-blue-100 p-3 rounded-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-blue-600" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 10h18M9 21V9m6 12V9m-7-6h8a2 2 0 012 2v2H4V5a2 2 0 012-2z" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tailwind CSS Animation for Welcome Emoji -->
    <style>
        .animate-wave {
            display: inline-block;
            animation: wave 1.5s infinite;
        }

        @keyframes wave {

            0%,
            100% {
                transform: rotate(0deg);
            }

            25% {
                transform: rotate(-15deg);
            }

            75% {
                transform: rotate(15deg);
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/auth/dashboard.blade.php ENDPATH**/ ?>