<?php $__env->startSection('content'); ?>
<div class="intro-y col-span-12 lg:col-span-12">

    <div class="intro-y box mt-5" style=" padding: 20px 20px 30px 20px;">
        <!-- BEGIN: Horizontal Form -->
        <div class="intro-y mt-5">
            <?php
            $orgId = \App\Models\Organisation::current()->organisation_id;
            ?>
            <h2 class="text-xl font-bold mb-4">Add Members in Bulk </h2>

            <div class="mb-4">
                <a href="<?php echo e(route('donor.downloadSampleCSV')); ?>"
                    class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                    Download Sample CSV
                </a>
            </div>


            
            <?php if($errors->any()): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <ul class="list-disc pl-5">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>

            <!-- resources/views/donors/import.blade.php -->
            <form action="<?php echo e(route('donors.importCSV')); ?>" method="POST" enctype="multipart/form-data" id="bulk_cv_import">
                <?php echo csrf_field(); ?>
                <div class="preview">
                    <div class="intro-y col-span-12 lg:col-span-12">
                        <div class="intro-y">
                            <div class="p-5" id="input">
                                <div class="preview">
                                    <div class="w-full -ml-4 -mr-4 flex flex-wrap">
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Organisation <span style="color: red">*</span></label>
                                                <select id="organisation_id" name="organisation_id"
                                                    class="input w-full border mt-2 custm-drpdwn" required disabled>
                                                    <option value="">-- Select Organisation --</option>
                                                    <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($organisation->organisation_id); ?>"
                                                        <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                                        <?php echo e($organisation->organisation_name); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="text-red-500 text-sm mt-1 error-message"
                                                    id="error-organisation"></div>
                                            </div>
                                        </div>
                                        <input type="hidden" value="<?php echo e($orgId); ?>" id="organisation_id"
                                            name="organisation_id">

                                        <div class="w-6/12 px-4">
                                            <div class="mt-3" id="accountTypeWrapper">
                                                <label>Division</label>
                                                <select id="account_type_id" name="account_type_id"
                                                    class="input w-full border mt-2 custm-drpdwn" disabled>
                                                    <option value="">-- Select Division --</option>
                                                </select>
                                                <small id="accountTypeMsg" class="text-red-500" style="display:none;">
                                                    Please select organisation first
                                                </small>
                                                <div class="text-red-500 text-sm mt-1 error-message"
                                                    id="error-account-type"></div>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Select Member Type &nbsp; <span
                                                        style="color:red;">*</span></label>
                                                <select name="donor_type" class="w-full border mt-2 p-2 rounded"
                                                    required disabled>

                                                    <option value="members" selected>Members</option>
                                                    <option value="foreign_members">Family Members</option>
                                                    <option value="non_members">Non Members</option>
                                                </select>
                                                <div class="text-red-500 text-sm mt-1 error-message">
                                                    <?php $__errorArgs = ['donor_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <?php echo e($message); ?>

                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="w-6/12 px-4">
                                            <div class="mt-3">
                                                <label>Upload Csv File</label>
                                                <input type="file" class="w-full border mt-2 p-2 rounded"
                                                    name="csv_file" accept="" multiple required>
                                                <ul id="file-list" class="mt-2 text-sm text-gray-600 space-y-1">
                                                </ul>
                                                <div class="text-red-500 text-sm mt-1 error-message"
                                                    id="error-csv-file"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="sm:pl-5 mt-5">

                        <a href="<?php echo e(route('donor.index')); ?>"><span
                                class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                                ← Back
                            </span></a>
                        <button type="submit" id="import_csv_submit" class="button w-24 bg-theme-1 text-white">Save</button>
                    </div>
                </div>
            </form>
            </form>

        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>

     $("#bulk_cv_import").on("submit", function () {
        let $submitBtn = $("#import_csv_submit");

        $submitBtn.prop("disabled", true);  // disable button
        $submitBtn.text("Submitting..."); // update text
        submitBtn.classList.add('opacity-70', 'cursor-not-allowed');
        return true; // allow form to submit
    });
    //organisation and accountype checking start.
    let accountTypes = <?php echo json_encode($accountTypes, 15, 512) ?>;
    let orgSelect = document.getElementById('organisation_id');
    let accSelect = document.getElementById('account_type_id');
    let msg = document.getElementById('accountTypeMsg');


    let oldOrg = "<?php echo e(old('organisation_id', $orgId)); ?>";
    let oldAcc = "<?php echo e(old('account_type_id')); ?>";

    function populateAccountTypes(oldOrg) {
        accSelect.innerHTML = '<option value="">-- Select Division --</option>';

        if (oldOrg) {
            let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

            if (filtered.length > 0) {
                document.getElementById("accountTypeWrapper").style.display = "block";
                filtered.forEach(at => {
                    let option = document.createElement('option');
                    option.value = at.account_type_id;
                    option.textContent = at.account_type_Name;

                    if (oldAcc == at.account_type_id) {
                        option.selected = true;
                    }
                    accSelect.appendChild(option);
                });

                accSelect.disabled = false;
                msg.style.display = "none";
            } else {
                accSelect.disabled = true;
                msg.textContent = "No Division found for this organisation.";
                msg.style.display = "block";
                document.getElementById("accountTypeWrapper").style.display = "none";
            }
        } else {
            accSelect.disabled = true;
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
        }
    }

    orgSelect.addEventListener('change', function() {
        populateAccountTypes(this.value);
    });

    accSelect.addEventListener('focus', function() {
        if (!orgSelect.value) {
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
            setTimeout(() => msg.style.display = "none", 2000);
        }
    });

    if (oldOrg) {
        populateAccountTypes(oldOrg);
    }
    //organisation and accountype checking end.
</script>
<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success',
        text: "<?php echo e(session('success')); ?>",
        confirmButtonColor: '#3085d6',
        confirmButtonText: 'OK'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "<?php echo e(route('donor.index')); ?>";
        }
    });
</script>
<?php endif; ?>

<?php if(session('error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Error',
        text: "<?php echo e(session('error')); ?>",
        confirmButtonColor: '#d33',
        confirmButtonText: 'OK'
    });
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/auth/donor/bulkUploadForm.blade.php ENDPATH**/ ?>