<?php $__env->startSection('content'); ?>
<div class="col-span-12 lg:col-span-12">
    <div class="flex justify-between mt-5">
        <h2 class="text-lg font-medium mr-auto">
            Members
        </h2>

        <?php
        $menuId = \App\Models\Menu::where('route', 'donor.index')->value('id');
        $permissionService = app(\App\Services\PermissionService::class);
        $canWrite = $permissionService->hasPermission($menuId, 'x');
        ?>

        <?php if($permissionService->hasPermission($menuId, 'w')): ?>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="<?php echo e(route('donor.create')); ?>">
                <button class="button text-white bg-theme-1 shadow-md">
                    Add Member
                </button>
            </a>
        </div>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="<?php echo e(route('donor.importForm')); ?>">
                <button class="button text-white bg-theme-1 shadow-md">
                    Add Bulk Member
                </button>
            </a>
        </div>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="<?php echo e(route('donor.member.donation.list')); ?>">
                <button class="button text-white bg-theme-1 shadow-md">
                    Members Yearly Record
                </button>
            </a>
        </div>
        
    <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
        <a href="<?php echo e(route('donor.donation.create')); ?>">
            <button class="button text-white bg-theme-1 shadow-md">
                Add Donation
            </button>
        </a>
    </div>
    <?php endif; ?>
</div>
</div>
</div>
<!-- BEGIN: HTML Table Data -->
<div class="intro-y box p-5 mt-5">

    <?php if(session('success')): ?>
    <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-9 text-theme-9 dark:border-theme-9">
        <?php echo e(session('success')); ?>

    </div>
    <?php elseif(session('error')): ?>
    <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-6 text-theme-6 dark:border-theme-6">
        <?php echo e(session('error')); ?>

    </div>
    <?php endif; ?>

    <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
        <form class="xl:flex w-full" id="tabulator-html-filter-form">

            <div class="sm:flex items-center justify-between w-full">
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <label for="page-size" class="form-label mb-0">Data Per Page</label>
                        <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            
                            <option value="10">10</option>
                            <option value="30">30</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Members as per Organisation:</label>
                        <select id="org-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            <option value="">All Members</option>
                            <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($organisation->organisation_id); ?>">
                                <?php echo e($organisation->organisation_name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>
                </div>
                &nbsp; &nbsp; &nbsp;
                <div>
                    <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                        placeholder="Search...">
                </div>

            </div>

        </form>
    </div>
    <div class="overflow-x-auto scrollbar-hidden">
        <div class="mt-5 table-report table-report--tabulator" id="donor-table"></div>
    </div>
</div>
<!-- END: HTML Table Data -->

<link href="<?php echo e(asset('build/assets/css/tabulator.min.css')); ?>" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/tabulator/6.3.1/css/tabulator_materialize.min.css" rel="stylesheet">
<script type="text/javascript" src="https://unpkg.com/tabulator-tables@6.3.1/dist/js/tabulator.min.js"></script>


<script>
    var canWrite = <?php echo json_encode($canWrite, 15, 512) ?>; //execute
    var canRead = <?php echo json_encode($permissionService -> hasPermission($menuId, 'r'), 512) ?>; //read
    var canExecute = <?php echo json_encode($permissionService -> hasPermission($menuId, 'w'), 512) ?>; //write

    var currentYearRange =
        "<?php echo e(\Carbon\Carbon::createFromDate(date('Y'), 4, 1)->format('d-m-Y') . ' to ' . \Carbon\Carbon::createFromDate(date('Y') + 1, 3, 31)->format('d-m-Y')); ?>";
    var table = new Tabulator("#donor-table", {
        ajaxURL: "<?php echo e(route('donor.details')); ?>",
        ajaxParams: function() {
            return {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                search: document.querySelector("#search-string").value,
                organisation_id: document.querySelector("#org-size").value,

            };
        },
        ajaxConfig: "POST",
        layout: "fitColumns",
        theme: "bootstrap5",
        paginationMode: "remote",
        pagination: true,
        paginationSize: 10,
        paginationSizeSelector: false,
        layout: "fitColumns",
        search: true,
        movableRows: true,
        movableColumns: true,
        // 🔹 Custom loader spinner
        ajaxLoaderLoading: `
                   <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data</div>
                `,

        // placeholder: "<span style='color: red; font-size: 16px; font-weight: bold;'>No Data Available</span>",

        columnDefaults: {
            tooltip: true,
        },
        columns: [{
                title: "SL",
                hozAlign: "center",
                formatter: function(cell, formatterParams, onRendered) {
                    let row = cell.getRow();
                    let data = row.getData();
                    let page = table.getPage();
                    let perPage = table.getPageSize();

                    if (!page) page = 0;
                    if (!perPage) perPage = 10;

                    return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                },
                // maxWidth: 200
            },
            {
                title: "Donor Name",
                field: "donor_name",
                hozAlign: "center",
                headerSort: true,
                // maxWidth: 400
            },
            {
                title: "Donor Type",
                field: "donor_type",
                hozAlign: "center",
                headerSort: true,
                formatter: function(cell) {
                    let value = cell.getValue();
                    switch (value) {
                        case "members":
                            return "Member";
                        case "foreign_members":
                            return "Family Member";
                        case "non_members":
                            return "Non-Member";
                        default:
                            return value ?? "-";
                    }
                }
            }, {
                title: "Phone No.",
                field: "donor_phone_number",
                hozAlign: "center",
                headerSort: true,
                // maxWidth: 400
            },
            {
                title: "Address",
                field: "donor_address",
                hozAlign: "center",
                headerSort: true,
                // maxWidth: 400
            },
            {
                title: "Ledger Folio No.",
                field: "donor_folio_no",
                hozAlign: "center",
                headerSort: true,
                // maxWidth: 400
            },
            {
                title: "Add Donation",
                headerSort: false,
                maxWidth: 620,
                headerHozAlign: "center",
                formatter: function() {

                    let html = `
                            <div class="flex justify-center items-center">
                              `;

                    if (canExecute) {
                        html += `
                                <a href="javascript:void(0);" class="flex items-center mr-3" data-action="addDonation">
                                    <span data-toggle="tooltip" data-original-title="Add">
                                        <svg xmlns="http://www.w3.org/2000/svg" 
                                            width="24" height="24" 
                                            viewBox="0 0 24 24" 
                                            fill="none" 
                                            stroke="currentColor" 
                                            stroke-width="1.5" 
                                            stroke-linecap="round" 
                                            stroke-linejoin="round" 
                                             style="pointer-events:none"
                                            class="feather feather-plus-square w-4 h-4 mr-1">
                                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                                            <line x1="12" y1="8" x2="12" y2="16"></line>
                                            <line x1="8" y1="12" x2="16" y2="12"></line>
                                        </svg>
                                    </span>
                                </a>
                                </div>
                            `;

                    }

                    // if (canExecute) {
                    //     html += `

                    //         <a class="flex items-center text-theme-6" data-action="delete">    
                    //         <span class="action-link text-danger font-weight-bold text-xs"  data-toggle="tooltip" data-original-title="Delete user">
                    //                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 w-4 h-4 mr-1"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                    //             </span>
                    //               </a>
                    //                           `;
                    // }

                    return html;
                },
                cellClick: function(e, cell) {
                    const rowData = cell.getRow().getData();
                    const actionEl = e.target.closest('[data-action]') || $(e.target).parents('[data-action]')[0];
                    const action = actionEl ? actionEl.dataset.action : null;

                    if (action === "addDonation") {
                        console.log("Row Data:", rowData);
                        let encodedId = btoa(rowData.donor_id);
                        window.location.href = "/member/donation/create/" + encodedId;

                    }
                }
            }
        ],
        rowFormatter: function(row) {
            const data = row.getData();
            if (data.is_current === 1) {
                row.getElement().style.backgroundColor = "lightblue";
                row.getElement().style.color = "black";
            }
        },

        ajaxResponse: function(url, params, response) {
            return {
                data: response.data,
                last_page: response.last_page,
                current_page: response.current_page,
                total: response.total
            };
        }
    });
    document.getElementById("page-size").addEventListener("change", function() {
        table.setPageSize(Number(this.value));
    });
    document.getElementById("org-size").addEventListener("change", function() {
        table.setData();
    });
    document.getElementById("search-string").addEventListener("input", function() {
        table.setData();
    });
</script>
<style>
    #accounting-year-table {
        position: relative;
    }

    #accounting-year-table .tabulator-loader {
        position: absolute !important;
        inset: 0 !important;
        display: flex !important;
        align-items: center;
        justify-content: center;
        background: rgba(255, 255, 255, 0.7) !important;
        z-index: 9999 !important;
    }

    #accounting-year-table .tabulator-loader-msg {
        background: transparent !important;
        border: none !important;
        box-shadow: none !important;
        padding: 0 !important;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/auth/donor/index.blade.php ENDPATH**/ ?>