<?php $__env->startSection('content'); ?>
<div class="intro-y col-span-12 lg:col-span-12">
    <div class="intro-y box mt-5">
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Member Donation
                </h2>
            </div>

            <form id="donationForm" method="POST" enctype="multipart/form-data" class="pb-4">
                <?php echo csrf_field(); ?>
                <div class="member-add-boxarea p-5" id="dynamic-fields">
                    <div id="donation-rows" class="space-y-2 member-add-boxscroll">
                        <div class="donation-mamber-wraper">
                            <!-- Fixed Donor -->
                            <input type="hidden" name="members[]" value="<?php echo e($donor['donor_id']); ?>">
                            <input type="text" class="input border flex-1 bg-gray-100"
                                value="<?php echo e(ucwords(strtolower($donor['donor_name']))); ?>" disabled>

                            <!-- Income Head Dropdown -->
                            <select name="income_heads[]" class="input border flex-1" required>
                                <option value="">-- Select Income Head --</option>
                                <?php $__currentLoopData = $heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($head['id']); ?>">
                                    <?php echo e(ucwords(strtolower($head['name']))); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <!-- Amount -->
                            <input type="text" name="amounts[]" class="input border flex-1" placeholder="Amount" required>

                            <select id="payment_type_id" name="payment_type_id[]" class="input border flex-1" required>
                                <option value="">-- Select Payment Type --</option>

                                <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $children = $paymentTypes->where('parent_id', $parent->id);
                                ?>

                                <?php if($children->isEmpty()): ?>
                                <option value="<?php echo e($parent->id); ?>"
                                    <?php echo e(old('payment_type_id') == $parent->id ? 'selected' : ''); ?>>
                                    <?php echo e($parent->name); ?>

                                </option>
                                <?php else: ?>
                                <optgroup label="<?php echo e($parent->name); ?>">
                                    <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($child->id); ?>"
                                        <?php echo e(old('payment_type_id') == $child->id ? 'selected' : ''); ?>>
                                        <?php echo e($child->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </optgroup>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <div class="text-red-500 text-sm mt-1 error-message" id="error-payment-type"></div>

                            <!-- Action Buttons -->
                            <div class="button-box">
                                <button type="button" class="btn-add bg-green-500 text-white px-3 rounded">+</button>
                            </div>
                            <!-- <button type="button" class="btn-remove bg-red-500 text-white px-3 rounded">-</button> -->
                        </div>

                    </div>
                </div>

                <div class="sm:pl-5 mt-5">
                    <a href="<?php echo e(route('donor.index')); ?>">
                        <span class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                            ← Back
                        </span>
                    </a>
                    <button type="submit" id="submitDonation" class="button w-24 bg-theme-1 text-white">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- This is dynamic row that will be appended inside the form -->
<div  class="donation-mamber-wraper donation-row" style="visibility: hidden;">
    <input type="hidden" name="members[]" value="<?php echo e($donor['donor_id']); ?>">
    <input type="text" class="input border flex-1 bg-gray-100"
        value="<?php echo e(ucwords(strtolower($donor->donor_name))); ?>" disabled>

    <select name="income_heads[]" class="input border flex-1 income-head-select" required>
        <option value="">-- Select Income Head --</option>
        <?php $__currentLoopData = $heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($head['id']); ?>"><?php echo e($head['name']); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

    <input type="text" name="amounts[]" class="input border flex-1 _amount" placeholder="Amount" required>

    <select name="payment_type_id[]" class="input border flex-1" required>
        <option value="">-- Select Payment Type --</option>
        <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $children = $paymentTypes->where('parent_id', $parent->id); ?>
        <?php if($children->isEmpty()): ?>
        <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
        <?php else: ?>
        <optgroup label="<?php echo e($parent->name); ?>">
            <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </optgroup>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

    <div class="button-box">
        <button type="button" class="btn-add bg-green-500 text-white px-3 rounded">+</button>
        <button type="button" class="btn-remove bg-red-500 text-white px-3 rounded">-</button>
    </div>
</div>

<script>
    const storeTransactionRoute = "<?php echo e(route('donor.donation.store')); ?>";
</script>
<script src="<?php echo e(asset('js/members/addMemberDonation.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/donor/memberDonation.blade.php ENDPATH**/ ?>