<?php $__env->startSection('content'); ?>
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
        <h2 class="text-xl font-bold mb-6">Edit Head</h2>
    
        <form id="groupStoreForm" action="<?php echo e(route('heads.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>
            <input type="hidden" name="id" value="<?php echo e($head->id); ?>">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <div class="mt-3">
                        <input type="hidden" name="organisation_id" value="<?php echo e($orgId); ?>">
                        <label>Organisation <span style="color: red">*</span></label>
                        <select id="organisation_id" class="input w-full border mt-2" disabled>
                            <option value="">-- Select Organisation --</option>
                            <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($organisation->organisation_id); ?>"
                                <?php echo e(old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : ''); ?>>
                                <?php echo e($organisation->organisation_name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div>
                    <div class="mt-3">
                        <label>Head Name <span class="text-red-500">*</span></label>
                        <input type="text" id="name" name="name" class="w-full border p-2 rounded mt-2"
                            required value="<?php echo e(old('name', $head->name)); ?>">
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <div class="mt-3" id="accountTypeWrapper">
                        <label>Division </label>
                        <select id="account_type_id" name="account_type_id" class="input w-full border mt-2">
                            <option value="">-- Select Division --</option>
                            <?php $__currentLoopData = $divitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $div): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($div->account_type_id); ?>"
                                <?php echo e(old('account_type_id', $head->account_type_id) == $div->account_type_id ? 'selected' : ''); ?>>
                                <?php echo e($div->account_type_Name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-account-type"></div>
                    </div>
                </div>
                <div>
                    <div class="mt-3" id="headgroupId">
                        <label>Head Group </label>
                        <select id="head_group_id" name="head_group_id" class="input w-full border mt-2">
                            <option value="">-- Select Head Group --</option>
                            <?php $__currentLoopData = $headGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($group->id); ?>"
                                <?php echo e(old('head_group_id', $head->head_group_id) == $group->id ? 'selected' : ''); ?>>
                                <?php echo e($group->name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-income-head-group"></div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 " id="html_type"></div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 " id="html_type_libility"></div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 " id="html_type_receipt_payment"></div>

            <div class="mt-5">
                <a href="<?php echo e(route('heads.index')); ?>"
                    class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                <button type="button" id="save-btn" class="button w-24 bg-theme-1 text-white">Update</button>
            </div>
        </form>

    </div>
    <?php if(session('error')): ?>
    <div id="errorBox"
        style="
        background:#fdecea;
        border:1px solid #f5c2c7;
        color:#842029;
        padding:14px 18px;
        border-radius:8px;
        margin-top:16px;
        font-size:14px;
    ">
        <?php echo e(session('error')); ?>

    </div>

    <script>
        setTimeout(() => {
            document.getElementById('errorBox').style.display = 'none';
        }, 5000);
    </script>
    <?php endif; ?>

    <?php if($errors->any()): ?>
    <div
        style="background:#fdecea; border:1px solid #f5c2c7; color:#842029; padding:14px 18px; border-radius:8px; margin-bottom:16px; font-size:14px;">
        <ul style="margin:0; padding-left:18px;">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li style="line-height:1.6;">
                <?php echo e($error); ?>

            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>
</div>
<?php
// dd($head->toArray());

?>     
<script>
    $(document).ready(function() {
        var headGroupId = <?php echo json_encode($head ->head_group_id ?? null, 15, 512) ?>;
        if (headGroupId) {
            htmlChange($('#head_group_id'));
        }

        $('#save-btn').on('click', function(e) {
            // Check if form is valid before preventing submission
            let form = $('#groupStoreForm')[0];
            if (form.checkValidity()) {
                // disable the button to prevent multiple clicks
                $(this).prop('disabled', true).text('Updating...');
                form.submit(); // submit the form
            } else {
                // Let browser show validation messages
                form.reportValidity();
            }
        });

        $('#head_group_id').on('change', function(){
            htmlChange(this);
        });
        function htmlChange(jqObject) {
            var id = $(jqObject).val();
            var headData = <?php echo json_encode($head, 15, 512) ?>;

            // Reset all conditional sections
            $('#html_type').html('');
            $('#html_type_libility').html('');
            $('#html_type_receipt_payment').html('');

            if (id == 3) {
                var selectedAssetType = headData.asset_or_liability_type || 'current_asset';
                var selectedDepType = headData.depriciation_type || '';
                var rteExtention = selectedDepType === 'percentage' ? '%' : (selectedDepType ===
                    'flat' ? 'amount' : '');

                let asset_html = `
                        <div class="mt-3">
                            <label class="block font-medium text-gray-700">Choose Asset Type</label>
                            <div class="flex space-x-6 mt-2">
                                <label class="flex items-center space-x-2">
                                    <input type="radio" name="asset_type" value="fixed_asset" id="assetType_fixed" class="w-4 h-4" <?php echo e(($head->asset_or_liability_type != null && $head->asset_or_liability_type == 'assetType_fixed') ? 'checked ': ''); ?> >
                                    <span>Fixed Assets</span>
                                </label>
                                <label class="flex items-center space-x-2">
                                    <input type="radio" name="asset_type" value="current_asset" id="assetType_current" class="w-4 h-4" <?php echo e(($head->asset_or_liability_type != null && $head->asset_or_liability_type == 'current_asset') ? 'checked ': ''); ?> >
                                    <span>Current Assets</span>
                                </label>
                                <label class="flex items-center space-x-2">
                                    <input type="radio" name="asset_type" value="financial_assets" id="assetType_financial" class="w-4 h-4" <?php echo e(($head->asset_or_liability_type != null && $head->asset_or_liability_type == 'financial_assets') ? 'checked ': ''); ?> >
                                    <span>Financial Assets</span>
                                </label>
                            </div>
                        </div>

                        <div class="mt-3" >
                            <label class="block font-medium">Depreciation Rate (% or Amount) <span class="text-red-500"></span></label>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <input type="text" id="depriciation_rate" name="depriciation_rate" class="w-full border p-2 rounded mt-2" value="<?php echo e($head->depriciation_rate != null ? $head->depriciation_rate : ''); ?>" >
                                </div>
                                <div>
                                    <select id="rte_extention" name="rte_extention" class="w-full border p-2 rounded custm-drpdwn mt-2">
                                        <option value="">--Select--</option>
                                        <option value="amount" <?php echo e(($head->depriciation_type != null && $head->depriciation_type == 'flat') ? 'selected ': ''); ?>>Amount</option>
                                        <option value="%" <?php echo e(($head->depriciation_type != null && $head->depriciation_type == 'percentage') ? 'selected ': ''); ?>>Percentage(%)</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div>
                            <label class="block font-medium">Depreciation Tenure</label>
                            <select id="depriciation_tenure" name="depriciation_tenure" class="w-full border p-2 rounded custm-drpdwn mt-2">
                                <option value="">--Select Tenure--</option>
                                <option value="6" <?php echo e(($head->depriciation_tenure != null && $head->depriciation_tenure == 6) ? 'selected ': ''); ?> >6 Months</option>
                                <option value="12" <?php echo e(($head->depriciation_tenure != null && $head->depriciation_tenure == 12) ? 'selected ': ''); ?>>Yearly</option>
                            </select>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-expense-head-group"></div>
                        </div>
                    `;

                $('#html_type').html(asset_html);
            } else {
                $('#html_type').html('');
            }

            if (id == 8) {

                let libilities_html = `
                        <div class="mt-3">
                            <label>Choose Liabilities Type</label>
                            <div class="flex space-x-6 mt-2">
                                <label class="flex items-center space-x-2">
                                    <input type="radio" name="liability_type" value="fixed_libilities" id="liability_type_fixed" class="w-4 h-4"  <?php echo e(($head->asset_or_liability_type != null && $head->asset_or_liability_type == 'fixed_libilities') ? 'checked ': ''); ?> >
                                    <span>Fixed Liabilities (Non-current Liabilities)</span>
                                </label>
                                <label class="flex items-center space-x-2">
                                    <input type="radio" name="liability_type" value="current_libilities" id="liability_type_current" class="w-4 h-4" <?php echo e(($head->asset_or_liability_type != null && $head->asset_or_liability_type == 'current_libilities') ? 'checked ': ''); ?>>    
                                    <span>Current Liabilities</span>
                                </label>
                            </div>
                        </div>
                    `;

                $('#html_type_libility').html(libilities_html);
            } else {
                $('#html_type_libility').html('');
            }

            // Show receipt checkbox for group head id 9, 7, 5
            if (id == 9 || id == 7 || id == 5) {

                let receipt_html = `
                        <div class="mt-3">
                            <label class="flex items-center space-x-2">
                                <input type="radio" name="type" value="receipt" id="mark_as_receipt" class="w-4 h-4" 
                                <?php echo e(($head->type != null && $head->type == 'receipt') ? 'checked ': ''); ?> >
                                <span class="font-medium">Mark as a Receipt</span>
                            </label>
                        </div>
                    `;
                $('#html_type_receipt_payment').html(receipt_html);
            }

            // Show payment and expenditure checkboxes for group head id 6, 4, 2, 1
            if (id == 6 || id == 4 || id == 2 || id == 1) {

                let payment_expenditure_html = `
                        <div style="display: flex; align-items: center; gap: 20px; flex-wrap: wrap;">
                        <div class="mt-3">
                            <label class="flex items-center space-x-2">
                                <input type="radio" name="type" value="payment" id="mark_as_payment" class="w-4 h-4" 
                                <?php echo e(($head->type != null && $head->type == 'payment') ? 'checked ': ''); ?>>
                                <span class="font-medium">Mark as a Payment</span>
                            </label>
                        </div>
                        <div class="mt-3">
                            <label class="flex items-center space-x-2">
                                <input type="radio" name="type" value="expenditure" id="mark_as_expenditure" class="w-4 h-4" <?php echo e(($head->type != null && $head->type == 'expenditure') ? 'checked ': ''); ?> >
                                <span class="font-medium">Mark as an Expenditure</span>
                            </label>
                        </div>
                        </div>
                    `;
                $('#html_type_receipt_payment').html(payment_expenditure_html);
            }

            // Reset receipt/payment section if not matching any condition
            if (id != 9 && id != 7 && id != 5 && id != 6 && id != 4 && id != 2 && id != 1) {
                $('#html_type_receipt_payment').html('');
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/download/public_html/resources/views/head/edit.blade.php ENDPATH**/ ?>