@extends('master.authMaster')


@section('content')
    <div class="ledgers-page-sec col-span-12 lg:col-span-12">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <!-- Sidebar / Filter Box -->
            {{-- <div class="w-full bg-white border-r pb-3">
                <h2 class="text-lg font-semibold p-4 border-b">Donor Heads</h2>
                @if ($donorsWithRecords->isEmpty())
                    <p class="p-4 text-gray-500">No Donor data found for this financial year. Please<a
                            href="{{ route('income.create') }}" style="color: blue"> Add Data</a> from Income
                        Screen.</p>
                @else
                    @foreach ($donorsWithRecords as $donor)
                        @php
                            $donorSlug = \Illuminate\Support\Str::slug($donor->donor_name);
                        @endphp
                        <ul id="tabMenu" class="income-head">

                            <li data-tab="tab1">
                                <a href="{{ route('ledger.donor-details', ['donor' => $donorSlug, 'id' => base64_encode($donor->donor_id)]) }}">
                                    {{ ucfirst($donor->donor_name) }}
                                </a>
                            </li>
                            <li>
                                Total amount received from Donor - ₹ {{ $donor->transaction_amount }}
                                <span><a href="{{ route('ledger.donor-details', ['donor' => $donorSlug, 'id' => base64_encode($donor->donor_id)]) }}" class="edit-btn">
                                        View Details </a></span>
                            </li>

                        </ul>
                    @endforeach
                @endif
            </div> --}}

            <div class="w-full bg-white border-r pb-3">
    <h2 class="text-lg font-semibold p-4 border-b">Donor Heads</h2>

    @if ($donorsWithRecords->isEmpty())
        <p class="p-4 text-gray-500">
            No Donor data found for this financial year.
            Please <a href="{{ route('income.create') }}" style="color: blue">Add Data</a>
            from Income Screen.
        </p>
    @else
        <div style="padding: 0 1rem;" class="income-head">
            <table id="tabMenu" class="w-full" style="border-radius: 10px; overflow: hidden">
                <thead>
                    <tr style="background-color: #99a5b6;">
                        <th style="text-align: left; width: 65%" class="p-3">Donor's Name</th>
                        <th style="text-align: left" class="p-3">Amount Received</th>
                        <th style="text-align: center" class="p-3">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($donorsWithRecords as $donor)
                        @php
                            $donorSlug = \Illuminate\Support\Str::slug($donor->donor_name);
                        @endphp

                        <tr>
                            <td class="p-3">
                                <a href="{{ route('ledger.donor-details', [
                                    'donor' => $donorSlug,
                                    'id' => base64_encode($donor->donor_id)
                                ]) }}">
                                    {{ ucfirst($donor->donor_name) }}
                                </a>
                            </td>

                            <td class="p-3">
                                ₹ {{ $donor->transaction_amount }}
                            </td>

                            <td style="text-align: center;" class="p-3">
                                <a href="{{ route('ledger.donor-details', [
                                    'donor' => $donorSlug,
                                    'id' => base64_encode($donor->donor_id)
                                ]) }}" class="edit-btn">
                                    View Details
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>


        </div>
        <div class="mt-6">
            <button onclick="history.back()"
                class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                ← Back
            </button>
        </div>
    </div>
@endsection
