@extends('master.authMaster')
@section('content')
@php
    $url_segment = request()->segment(2);
@endphp
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12 ledgers-details-page-sec">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <div class="w-full p-4">
                <div class="content-box">

                    <!-- Date Filter -->
                    <div class="flex justify-between items-center mb-4">

                        <div>
                            <h3 class="text-base font-medium text-black">
                                @php
                                    $headName = 'N/A';
                                    if ($ledger_head_details instanceof \Illuminate\Support\Collection && $ledger_head_details->isNotEmpty()) {
                                        // Collection of head objects - get first head name
                                        $firstHead = $ledger_head_details->first();
                                        $headName = $firstHead->head_name ?? 'N/A';
                                    } elseif (is_object($ledger_head_details) && isset($ledger_head_details->income)) {
                                        // Object with income/expense properties
                                        $collection = $ledger_head_details->income->isNotEmpty() 
                                            ? $ledger_head_details->income 
                                            : ($ledger_head_details->expense->isNotEmpty() ? $ledger_head_details->expense : collect());
                                        if ($collection->isNotEmpty()) {
                                            $firstItem = $collection->first();
                                            $headName = $firstItem->head_name ?? 'N/A';
                                        }
                                    }
                                @endphp
                                {{ ucfirst($headName) }}
                            </h3>
                        </div>

                        <div class="flex gap-4 items-end">
                            <div>
                                <label for="from_date" class="text-sm">From Date</label>
                                <input type="date" id="from_date" class="border rounded p-2">
                            </div>
                            <div>
                                <label for="to_date" class="text-sm">To Date</label>
                                <input type="date" id="to_date" class="border rounded p-2">
                            </div>
                            <div class="flex items-end gap-2">
                                <button type="button" id="filterBtn"
                                    class="bg-blue-600 text-white px-4 py-2 rounded shadow">Filter</button>
                                <button type="button" id="clearBtn"
                                    class="bg-gray-500 text-white px-4 py-2 rounded shadow">Clear</button>
                            </div>
                        </div>

                    </div>

                    <div class="sngl-box">
                        <!-- Cash Payments -->
                        <div class="sngl-cart">

                            @if ($url_segment == 'expense')
                                <h4 class="text-base font-medium mb-2 text-blue mb-4">Cash Payments</h4>
                            @else
                                <h4 class="text-base font-medium mb-2 text-blue mb-4">Cash Receipts</h4>
                            @endif
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                                <thead>
                                    <tr class="bg-gray-100 text-gray-700">
                                        <th class="p-3">Date</th>
                                        <th class="p-3">Income Head Group Name</th>
                                        <th class="p-3">Narration</th>
                                        <th class="p-3 text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="cashTable" class="divide-y"></tbody>
                                <tfoot>
                                    <tr class="bg-gray-100 text-black">
                                        <td></td>
                                        <td></td>
                                        <td class="p-3 text-right font-semibold">Total</td>
                                        <td id="cashTotal" class="p-3 text-right font-bold">0.00</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- Bank Payments -->
                        <div class="sngl-cart">
                             @if ($url_segment == 'income')
                                <h4 class="text-base font-medium mb-2 text-blue mb-4">Bank Receipts </h4>
                            @else
                                 <h4 class="text-base font-medium mb-2 text-blue mb-4">Bank Payments </h4>
                            @endif

                            <table class="w-full text-left  shadow-sm rounded-lg overflow-hidden mb-3">
                                <thead>
                                    <tr class="bg-gray-100 text-gray-700">
                                        <th class="p-3">Date</th>
                                        <th class="p-3">Income Head Group Name</th>
                                        <th class="p-3">Narration</th>
                                        <th class="p-3 text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="bankTable" class="divide-y"></tbody>
                                <tfoot>
                                    <tr class="bg-gray-100 text-black">
                                        <td></td>
                                        <td></td>
                                        <td class="p-3 text-right font-semibold">Total</td>
                                        <td id="bankTotal" class="p-3 text-right font-bold">0.00</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- Grand Total -->
                        <div class="mt-4">
                            <table class="w-full text-left  shadow-sm rounded-lg overflow-hidden">
                                <tfoot>
                                    <tr class="bg-gray-200 text-black">
                                        <td class="p-3 text-right font-semibold">Grand Total</td>
                                        <td id="grandTotal" class="p-3 text-right font-bold">0.00</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                </div>
                <div class="mt-6">
                    <button onclick="history.back()"
                        class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                        ← Back
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
       $(document).ready(function () {
    const allIncomes = @json($ledger_head_details);

    function parseDateOnly(dateStr) {
        const parts = dateStr.split("-");
        return new Date(parts[0], parts[1] - 1, parts[2]);
    }

    function renderTables(fromDate = null, toDate = null) {
        const $cashBody = $("#cashTable");
        const $bankBody = $("#bankTable");
        const $cashTotalCell = $("#cashTotal");
        const $bankTotalCell = $("#bankTotal");
        const $grandTotalCell = $("#grandTotal");

        $cashBody.empty();
        $bankBody.empty();

        let totalCash = 0;
        let totalBank = 0;

        $.each(allIncomes, function (_, head) {
            const groupName = head.group_name ?? "-";
            const headName = head.head_name ?? "-";

            // 🟢 Loop through cash transactions
            $.each(head.cash_transactions, function (_, txn) {
                const date = parseDateOnly(txn.date);
                const from = fromDate ? parseDateOnly(fromDate) : null;
                const to = toDate ? parseDateOnly(toDate) : null;

                if (from && date < from) return true;
                if (to && date > to) return true;

                const row = `
                    <tr>
                        <td class="p-3">${date.toLocaleDateString("en-GB")}</td>
                        <td class="p-3">${groupName}</td>
                        <td class="p-3">${txn.narration ?? "-"}</td>
                        <td class="p-3 text-right">${txn.amount.toFixed(2)}</td>
                    </tr>
                `;
                $cashBody.append(row);
                totalCash += txn.amount;
            });

            // 🟣 Loop through bank transactions
            $.each(head.bank_transactions, function (_, txn) {
                const date = parseDateOnly(txn.date);
                const from = fromDate ? parseDateOnly(fromDate) : null;
                const to = toDate ? parseDateOnly(toDate) : null;

                if (from && date < from) return true;
                if (to && date > to) return true;

                const row = `
                    <tr>
                        <td class="p-3">${date.toLocaleDateString("en-GB")}</td>
                        <td class="p-3">${groupName}</td>
                        <td class="p-3">${txn.narration ?? "-"}</td>
                        <td class="p-3 text-right">${txn.amount.toFixed(2)}</td>
                    </tr>
                `;
                $bankBody.append(row);
                totalBank += txn.amount;
            });
        });

        // ✅ Totals
        $cashTotalCell.text(totalCash.toFixed(2));
        $bankTotalCell.text(totalBank.toFixed(2));
        if ($grandTotalCell.length) {
            $grandTotalCell.text((totalCash + totalBank).toFixed(2));
        }
    }

    // Initial render
    renderTables();

    // ✅ Filter button
    $("#filterBtn").on("click", function () {
        const fromDate = $("#from_date").val();
        const toDate = $("#to_date").val();

        if (fromDate && toDate && fromDate > toDate) {
            alert("From Date cannot be later than To Date");
            return;
        }

        renderTables(fromDate, toDate);
    });

    // ✅ Clear button
    $("#clearBtn").on("click", function () {
        $("#from_date").val("");
        $("#to_date").val("");
        renderTables();
    });
});


    </script>
@endsection
