@extends('master.authMaster')
@section('content')
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5 income-head-top-sec">
        <h2 class="text-lg font-medium mr-auto">Expenses </h2>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
            <a href="{{ route('transactions.create') }}">
                <button class="button text-white bg-theme-1 shadow-md">
                    Add Expense
                </button>
            </a>
        </div>
    </div>
</div>
</div>
<!-- BEGIN: HTML Table Data -->
<div class="intro-y box p-5 mt-5">
    <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
        <form class="xl:flex w-full" id="tabulator-html-filter-form">
            <div class="sm:flex items-center justify-between w-full">
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <label for="page-size" class="form-label mb-0">Data Per Page</label>
                        <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            {{-- <option value="5">5</option> --}}
                            <option value="10">10</option>
                            <option value="30">30</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>

                &nbsp; &nbsp; &nbsp;
                <div>
                    <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                        placeholder="Search...">
                </div>

            </div>
        </form>
    </div>
    <div class="overflow-x-auto scrollbar-hidden">
        <div class="mt-5 table-report table-report--tabulator" id="transcation_table"></div>
    </div>
</div>
<!-- END: HTML Table Data -->


<script src="{{ asset('js/tabulator.min.js') }}"></script>
<script>
    $(document).ready(function() {

        @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: @json(session('success')),
            timer: 2500,
            showConfirmButton: false
        });
        @endif

        @if(session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: @json(session('error')),
            timer: 2500,
            showConfirmButton: false
        });
        @endif

    });
</script>

@include('utils.alert')

<script>
    document.addEventListener("DOMContentLoaded", function() {
        // 🧭 Current financial year range
        var currentYearRange =
            "{{ \Carbon\Carbon::createFromDate(date('Y'), 4, 1)->format('d-m-Y') . ' to ' . \Carbon\Carbon::createFromDate(date('Y') + 1, 3, 31)->format('d-m-Y') }}";

        // 🧱 Initialize Tabulator table
        var table = new Tabulator("#transcation_table", {
            ajaxURL: "{{ route('transactions.list') }}",
            ajaxParams: function() {
                return {
                    _token: document.querySelector('meta[name="csrf-token"]').getAttribute(
                        "content"),
                    search: document.querySelector("#search-string").value,
                    "type": "expense"
                    // organisation_id: document.querySelector("#org-size").value,
                };
            },
            ajaxConfig: "POST",
            layout: "fitColumns",
            theme: "bootstrap5",
            paginationMode: "remote",
            pagination: true,
            paginationSize: 10,
            paginationSizeSelector: false,
            movableRows: true,
            movableColumns: true,
            ajaxLoaderLoading: `
                <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>
                    Loading Data
                </div>
            `,
            columnDefaults: {
                headerHozAlign: "left",
                tooltip: true,
            },
            columns: [{
                    title: "SL",
                    formatter: function(cell, formatterParams, onRendered) {
                        let row = cell.getRow();
                        let data = row.getData();
                        let page = table.getPage();
                        let perPage = table.getPageSize();

                        if (!page) page = 0;
                        if (!perPage) perPage = 10;

                        return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                    },
                    maxWidth: 100,
                    headerSort: false,
                    hozAlign: "center"
                },
                {
                    title: "Transaction Date",
                    field: "transaction_date",
                    headerSort: true,
                    minWidth: 180,
                },
                {
                    title: "Transaction Amount",
                    field: "transaction_amount",
                    headerSort: true,
                    minWidth: 180,
                },

                {
                    title: "Head Name",
                    field: "head_name",
                    headerSort: true,
                    minWidth: 180,
                },
                {
                    title: "Payment Type",
                    field: "payment_type_name",
                    headerSort: true,
                    minWidth: 100,
                },
                {
                    title: "Action",
                    headerHozAlign: "center",
                    headerSort: false,
                    hozAlign: "center",
                    width: 100,
                    formatter: function(cell) {
                        let data = cell.getRow().getData();
                        let html = `
                            <div class="flex justify-center items-center">
                              `;
                        html += `
                        <span data-action="view" data-toggle="tooltip" data-original-title="View Details">
                                             <a class="flex items-center mr-3"> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"  viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"
                                         class="feather feather-eye w-4 h-4 mr-1"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                            <circle cx="12" cy="12" r="3"></circle>
                                        </svg></a>
                                </span>`;
                        html += `
                            <a class="flex items-center text-theme-6" data-action="delete">
                            <span class="action-link text-danger font-weight-bold text-xs"  data-toggle="tooltip" data-original-title="Delete user">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 w-4 h-4 mr-1"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                                </span>
                                  </a> `;
                        return html;
                    },
                    cellClick: function(e, cell) {
                        const rowData = cell.getRow().getData();
                        const actionEl = e.target.closest('[data-action]');
                        const action = actionEl ? actionEl.dataset.action : null;

                        if (action === "view") {
                            let encodedId = btoa(rowData.id);
                            window.location.href = "/transactions/detail/" + encodedId;
                        } else if (action === "delete") {
                            const swalWithBootstrapButtons = Swal.mixin({
                                customClass: {
                                    confirmButton: "btn btn-success",
                                    cancelButton: "btn btn-danger"
                                },
                                buttonsStyling: true
                            });
                            swalWithBootstrapButtons.fire({
                                title: "Are you sure?",
                                text: `You want to delete the transaction with amount : ₹` + rowData.transaction_amount,
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonText: "Yes",
                                cancelButtonText: "No",
                                reverseButtons: true
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    $.ajax({
                                        type: "POST",
                                        url: "{{route('transactions.expense.delete')}}",
                                        dataType: 'json',
                                        data: {
                                            id: rowData.id,
                                            _token: '{{ csrf_token() }}'
                                        },
                                        success: function(response) {
                                            if (response.status == true) {
                                                toastr.success("Deleted Successfully",
                                                    "Success", toastrProperties);
                                                table.setData();
                                            } else {
                                                toastr.error("Failed to delete.", "Error", toastrProperties);
                                            }
                                        },
                                        error: function(error) {
                                            console.log(error);
                                        }
                                    });

                                }
                            });
                        }
                    }
                }
            ],
            rowFormatter: function(row) {
                const data = row.getData();
                if (data.is_current === 1) {
                    row.getElement().style.backgroundColor = "lightblue";
                    row.getElement().style.color = "black";
                }
            },
            ajaxResponse: function(url, params, response) {
                return {
                    data: response.data,
                    last_page: response.last_page,
                    current_page: response.current_page,
                    total: response.total,
                };
            }
        });



        // 📄 Page size change
        document.getElementById("page-size")?.addEventListener("change", function() {
            table.setPageSize(Number(this.value));
        });

        // 🔍 Live search
        document.getElementById("search-string")?.addEventListener("input", function() {
            table.setData();
        });
    });
</script>
@endsection