@extends('master.authMaster')

@section('content')
    @php
        $contraTypeLabels = [
            'cash_deposite' => 'Cash Deposit',
            'cash_withdraw' => 'Cash Withdrawal',
            'bank_transfer' => 'Bank Transfer'
        ];
        $contraTypeBadges = [
            'cash_deposite' => 'bg-green-100 text-green-800',
            'cash_withdraw' => 'bg-orange-100 text-orange-800',
            'bank_transfer' => 'bg-blue-100 text-blue-800'
        ];
        $contraType = $contraJournal->contra_reference_type ?? '';
    @endphp

    <div class="col-span-12 lg:col-span-12">
        <div class="flex justify-between mt-5">
            <h2 class="text-lg font-medium mr-auto">
                Contra Entry Details
            </h2>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0 gap-2">
                <a href="{{ route('transactions.contra.index') }}">
                    <button class="button text-white bg-gray-600 hover:bg-gray-700 shadow-md">
                        ← Back to List
                    </button>
                </a>
                <a href="{{ route('transactions.contra.create') }}">
                    <button class="button text-white bg-theme-1 shadow-md">
                        <i data-feather="plus" class="w-4 h-4 mr-2"></i> Add New Entry
                    </button>
                </a>
            </div>
        </div>
    </div>

    <!-- Cash & Bank Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mt-5">
        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Opening Cash</div>
                    <div class="text-2xl font-bold text-gray-800 mt-1">
                        ₹{{ number_format($cashBankData['account_bf_cash_in_hand_opening'] ?? 0, 2) }}
                    </div>
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                    <i data-feather="dollar-sign" class="w-6 h-6 text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Opening Bank</div>
                    <div class="text-2xl font-bold text-gray-800 mt-1">
                        ₹{{ number_format($cashBankData['account_bf_cash_at_bank_opening'] ?? 0, 2) }}
                    </div>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                    <i data-feather="credit-card" class="w-6 h-6 text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Total Cash</div>
                    <div class="text-2xl font-bold text-green-600 mt-1">
                        ₹{{ number_format($cashBankData['total_cash_in_hand'] ?? 0, 2) }}
                    </div>
                    @if(isset($cashBankData['contra_cash_adjustment']) && $cashBankData['contra_cash_adjustment'] != 0)
                        <div class="text-xs text-gray-500 mt-1">
                            Contra: {{ $cashBankData['contra_cash_adjustment'] > 0 ? '+' : '' }}₹{{ number_format($cashBankData['contra_cash_adjustment'], 2) }}
                        </div>
                    @endif
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                    <i data-feather="trending-up" class="w-6 h-6 text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="intro-y box p-5">
            <div class="flex items-center">
                <div class="flex-1">
                    <div class="text-gray-600 text-xs uppercase font-semibold">Total Bank</div>
                    <div class="text-2xl font-bold text-blue-600 mt-1">
                        ₹{{ number_format($cashBankData['total_cash_at_bank'] ?? 0, 2) }}
                    </div>
                    @if(isset($cashBankData['contra_bank_adjustment']) && $cashBankData['contra_bank_adjustment'] != 0)
                        <div class="text-xs text-gray-500 mt-1">
                            Contra: {{ $cashBankData['contra_bank_adjustment'] > 0 ? '+' : '' }}₹{{ number_format($cashBankData['contra_bank_adjustment'], 2) }}
                        </div>
                    @endif
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                    <i data-feather="trending-up" class="w-6 h-6 text-blue-600"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Details Card -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">
                Contra Entry Information
            </h2>
            <span class="px-3 py-1 rounded text-sm font-semibold {{ $contraTypeBadges[$contraType] ?? 'bg-gray-100 text-gray-800' }}">
                {{ $contraTypeLabels[$contraType] ?? ucfirst(str_replace('_', ' ', $contraType)) }}
            </span>
        </div>

        <div class="p-5">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Left Column -->
                <div class="space-y-4">
                    <div>
                        <label class="form-label font-semibold text-gray-700">Transaction Reference</label>
                        <div class="mt-2 text-gray-900">
                            {{ $contraJournal->transaction_reference ?? 'N/A' }}
                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Organisation</label>
                        <div class="mt-2 text-gray-900">
                            {{ $organisation->organisation_name ?? 'N/A' }}
                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Contra Type</label>
                        <div class="mt-2">
                            <span class="px-3 py-1 rounded text-sm font-semibold {{ $contraTypeBadges[$contraType] ?? 'bg-gray-100 text-gray-800' }}">
                                {{ $contraTypeLabels[$contraType] ?? ucfirst(str_replace('_', ' ', $contraType)) }}
                            </span>
                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Total Transaction Amount</label>
                        <div class="mt-2 text-2xl font-bold text-green-600">
                            ₹{{ number_format($contraJournal->transaction_amount ?? 0, 2) }}
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="space-y-4">
                    <div>
                        <label class="form-label font-semibold text-gray-700">Entry Date</label>
                        <div class="mt-2 text-gray-900">
                            {{ \Carbon\Carbon::parse($contraJournal->created_at)->format('d M Y, h:i A') }}
                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Cash Deposit Allocated Amount</label>
                        <div class="mt-2 text-gray-900">
                            @if($contraJournal->contra_cash_depo_allocated_amount)
                                ₹{{ number_format($contraJournal->contra_cash_depo_allocated_amount, 2) }}
                            @else
                                N/A
                            @endif
                        </div>
                    </div>

                    <div>
                        <label class="form-label font-semibold text-gray-700">Transaction Narration</label>
                        <div class="mt-2 text-gray-900">
                            {{ $contraJournal->transaction_narration ?? 'N/A' }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Contra Mapping Details -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">
                Transaction Details
            </h2>
            <span class="text-gray-600 text-sm">
                {{ $contraMappings->count() }} {{ $contraMappings->count() == 1 ? 'Entry' : 'Entries' }}
            </span>
        </div>

        <div class="p-5">
            <div class="overflow-x-auto">
                <table class="table table-report">
                    <thead>
                        <tr>
                            <th class="whitespace-nowrap">#</th>
                            @if($contraType == 'bank_transfer')
                                <th class="whitespace-nowrap">From Bank</th>
                            @endif
                            <th class="whitespace-nowrap">{{ $contraType == 'bank_transfer' ? 'To Bank' : 'Bank' }}</th>
                            <th class="whitespace-nowrap">Bank Amount (₹)</th>
                            @if($contraType == 'cash_deposite' || $contraType == 'cash_withdraw')
                                <th class="whitespace-nowrap">Cash Amount (₹)</th>
                            @endif
                            <th class="whitespace-nowrap">Transaction Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($contraMappings as $index => $mapping)
                            @php
                                $bank = $banks->get($mapping->bank_id);
                                $fromBank = $mapping->from_bank_id ? $banks->get($mapping->from_bank_id) : null;
                            @endphp
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                @if($contraType == 'bank_transfer')
                                    <td>
                                        @if($fromBank)
                                            <div class="font-semibold">{{ $fromBank->name }}</div>
                                            @if($fromBank->account_number)
                                                <div class="text-xs text-gray-500">A/C: {{ $fromBank->account_number }}</div>
                                            @endif
                                        @else
                                            <span class="text-gray-400">N/A</span>
                                        @endif
                                    </td>
                                @endif
                                <td>
                                    @if($bank)
                                        <div class="font-semibold">{{ $bank->name }}</div>
                                        @if($bank->account_number)
                                            <div class="text-xs text-gray-500">A/C: {{ $bank->account_number }}</div>
                                        @endif
                                        @if($bank->branch)
                                            <div class="text-xs text-gray-500">{{ $bank->branch }}</div>
                                        @endif
                                    @else
                                        <span class="text-gray-400">N/A</span>
                                    @endif
                                </td>
                                <td class="text-right font-semibold text-green-600">
                                    ₹{{ number_format($mapping->bank_amount ?? 0, 2) }}
                                </td>
                                @if($contraType == 'cash_deposite' || $contraType == 'cash_withdraw')
                                    <td class="text-right font-semibold text-orange-600">
                                        ₹{{ number_format($mapping->cash_amount ?? 0, 2) }}
                                    </td>
                                @endif
                                <td>
                                    @if($mapping->bank_transaction_date)
                                        {{ \Carbon\Carbon::parse($mapping->bank_transaction_date)->format('d M Y') }}
                                    @else
                                        <span class="text-gray-400">N/A</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ $contraType == 'bank_transfer' ? 5 : ($contraType == 'cash_deposite' || $contraType == 'cash_withdraw' ? 5 : 4) }}" class="text-center text-gray-500 py-8">
                                    No transaction details found.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr class="font-bold bg-gray-50">
                            <td colspan="{{ $contraType == 'bank_transfer' ? 2 : 1 }}" class="text-right">
                                Total:
                            </td>
                            @if($contraType == 'bank_transfer')
                                <td></td>
                            @endif
                            <td class="text-right text-green-600">
                                ₹{{ number_format($contraMappings->sum('bank_amount'), 2) }}
                            </td>
                            @if($contraType == 'cash_deposite' || $contraType == 'cash_withdraw')
                                <td class="text-right text-orange-600">
                                    ₹{{ number_format($contraMappings->sum('cash_amount'), 2) }}
                                </td>
                            @endif
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <!-- Impact Summary -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">
                Impact Summary
            </h2>
        </div>

        <div class="p-5">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                @if($contraType == 'cash_deposite')
                    <div class="bg-green-50 p-4 rounded-lg border border-green-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-down" class="w-8 h-8 text-green-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Cash Decreased</div>
                                <div class="text-xl font-bold text-green-600">
                                    ₹{{ number_format($contraMappings->sum('cash_amount'), 2) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-up" class="w-8 h-8 text-blue-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Bank Increased</div>
                                <div class="text-xl font-bold text-blue-600">
                                    ₹{{ number_format($contraMappings->sum('bank_amount'), 2) }}
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($contraType == 'cash_withdraw')
                    <div class="bg-green-50 p-4 rounded-lg border border-green-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-up" class="w-8 h-8 text-green-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Cash Increased</div>
                                <div class="text-xl font-bold text-green-600">
                                    ₹{{ number_format($contraMappings->sum('cash_amount'), 2) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-down" class="w-8 h-8 text-blue-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Bank Decreased</div>
                                <div class="text-xl font-bold text-blue-600">
                                    ₹{{ number_format($contraMappings->sum('bank_amount'), 2) }}
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($contraType == 'bank_transfer')
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-down" class="w-8 h-8 text-red-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Source Bank Decreased</div>
                                <div class="text-xl font-bold text-red-600">
                                    ₹{{ number_format($contraMappings->sum('bank_amount'), 2) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-center">
                            <i data-feather="arrow-up" class="w-8 h-8 text-blue-600 mr-3"></i>
                            <div>
                                <div class="text-sm text-gray-600">Destination Bank Increased</div>
                                <div class="text-xl font-bold text-blue-600">
                                    ₹{{ number_format($contraMappings->sum('bank_amount'), 2) }}
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

