@extends('master.authMaster')

@section('content')
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
        <h2 class="text-xl font-bold mb-6">Add New Head Group</h2>
        @php
        $orgId = \App\Models\Organisation::current()->organisation_id;
        @endphp

        <form id="groupStoreForm" action="{{ route('head-groups.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <div class="mt-3">
                        <input type="hidden" name="organisation_id" value="{{ $orgId }}">
                        <label>Organisation <span style="color: red">*</span></label>
                        <select id="organisation_id" class="input w-full border mt-2" disabled>
                            <option value="">-- Select Organisation --</option>
                            @foreach ($organisations as $organisation)
                            <option value="{{ $organisation->organisation_id }}"
                                {{ old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : '' }}>
                                {{ $organisation->organisation_name }}
                            </option>
                            @endforeach
                        </select>
                    </div>


                </div>

                <div>
                    <div class="mt-3">
                        <label>Head Group Name <span class="text-red-500">*</span></label>
                        <input type="text" id="name" name="name" class="w-full border p-2 rounded mt-2"
                            required>
                    </div>


                </div>
            </div>

            <div class="sm:pl-5 mt-5">
                <a href="{{ route('head-groups.index') }}"
                    class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                <button type="button" id="save-btn" class="button w-24 bg-theme-1 text-white">Save</button>
            </div>
        </form>
        
    </div>
</div>

<script>
    $(document).ready(function() {
        $('#save-btn').on('click', function(e) {
            // Check if form is valid before preventing submission
            let form = $('#groupStoreForm')[0];

            if (form.checkValidity()) {
                // disable the button to prevent multiple clicks
                $(this).prop('disabled', true).text('Submitting...');
                form.submit(); // submit the form
            } else {
                // Let browser show validation messages
                form.reportValidity();
            }
        });
    });
</script>
@endsection