@extends('master.authMaster')


@section('content')
{{-- Form --}}
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5">
        <!-- BEGIN: Horizontal Form -->
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Edit Expense Transaction
                </h2>

            </div>
            <div class="p-5" id="horizontal-form">

                <form id="expenseForm" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="preview">
                        {{-- <div class="grid grid-cols-12 gap-6 mt-5"> --}}
                        <div class="intro-y col-span-12 lg:col-span-12">
                            <!-- BEGIN: Input -->
                            <div class="intro-y box">

                                <div class="p-5" id="input">
                                    <div class="preview">
                                        @php
                                        use Carbon\Carbon;

                                        $financialYear = \App\Models\AccountingYear::current();

                                        [$startDate, $endDate] = explode(
                                        ' to ',
                                        $financialYear->accounting_year_financial,
                                        );

                                        $startDate = Carbon::createFromFormat('d-m-Y', trim($startDate));
                                        $endDate = Carbon::createFromFormat('d-m-Y', trim($endDate));

                                        $today = Carbon::today();

                                        if ($today->between($startDate, $endDate)) {
                                        $maxDate = $today->toDateString();
                                        } else {
                                        $maxDate = $endDate->toDateString();
                                        }

                                        $minDate = $startDate->toDateString();
                                        $transactionDate = old(
                                        'transaction_date',
                                        optional(Carbon::parse($expense->transaction_date))->toDateString(),
                                        );
                                        @endphp
                                        <div class="w-full -ml-4 -mr-4 flex flex-wrap">
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Organisation <span style="color: red">*</span></label>
                                                    <select id="organisation_id" name="organisation_id"
                                                        class="input w-full border mt-2 custm-drpdwn" disabled>
                                                        <option value="">-- Select Organisation --</option>
                                                        @foreach ($organisations as $organisation)
                                                        <option value="{{ $organisation->organisation_id }}"
                                                            {{ old('organisation_id', $expense->organisation_id ?? '') == $organisation->organisation_id ? 'selected' : '' }}>
                                                            {{ $organisation->organisation_name }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-organisation"></div>
                                                </div>
                                            </div>
                                            <input type="hidden" name="organisation_id"
                                                value="{{ old('organisation_id', $expense->organisation_id ?? '') }}">
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3" id="accountTypeWrapper">
                                                    <label>Division<span style="color: red">*</span></label>
                                                    <select id="account_type_id" name="account_type_id"
                                                        class="input w-full border mt-2 custm-drpdwn" disabled>
                                                        <option value="">-- Select Account Type --</option>
                                                    </select>
                                                    <small id="accountTypeMsg" class="text-red-500"
                                                        style="display:none;">
                                                        Please select organisation first
                                                    </small>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-account-type"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label class="items-center justify-between"> Expense Head<span
                                                            style="color: red">*</span>
                                                        <button type="button" id="addExpenseHeadBtn"
                                                            class="ml-2 bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600"
                                                            style="float: right;">+</button>
                                                    </label>
                                                    <select id="expense_head_id" name="expense_head_id"
                                                        class="input w-full border mt-2 custm-drpdwn">
                                                        <option value="">-- Select Expense Head --</option>
                                                        @foreach ($expenseHeads as $expenseHead)
                                                        <option value="{{ $expenseHead->expense_head_id }}"
                                                            {{ old('expense_head_id', $expense->expense_head) == $expenseHead->expense_head_id ? 'selected' : '' }}>
                                                            {{ $expenseHead->expense_head_name }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-expense-head"></div>
                                                </div>
                                            </div>

                                            <!-- Add Expense Head Modal -->
                                            <div id="expenseHeadModal"
                                                class="hidden fixed inset-0 bg-gray-800 bg-opacity-50 flex items-center justify-center z-50">
                                                <div class="bg-white p-6 rounded-2xl w-96 shadow-lg">
                                                    <h2 class="text-lg font-semibold mb-4">Add Expense Head</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Organisation <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="expense_organisation_id_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select Organisation --
                                                                </option>
                                                                @foreach ($organisations as $org)
                                                                <option value="{{ $org->organisation_id }}">
                                                                    {{ $org->organisation_name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-organisation-id"></div>
                                                        </div>
                                                        <div>
                                                            <label class="block">Division <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="expense_account_type_id"
                                                                class="w-full border rounded px-3 py-2 custm-drpdwn"
                                                                disabled>
                                                                <option value="">-- Select --</option>
                                                                @foreach ($accountTypes as $type)
                                                                <option value="{{ $type->account_type_id }}">
                                                                    {{ $type->account_type_Name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div>
                                                            <label class="block">Expense Head Group </label>
                                                            <select id="expense_head_group_id"
                                                                class="w-full border rounded px-3 py-2 custm-drpdwn">
                                                                <option value="">-- Select --</option>
                                                                @foreach ($expenseGroups as $group)
                                                                <option
                                                                    value="{{ $group->expense_head_group_ID }}">
                                                                    {{ $group->expense_head_group_Name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div>
                                                            <label class="block">Expense Head Name <span
                                                                    class="text-red-500">*</span></label>
                                                            <input type="text" id="expense_head_name"
                                                                class="w-full border rounded px-3 py-2">
                                                        </div>
                                                        <div class="flex justify-end space-x-3">
                                                            <button type="button" id="closeExpenseHeadModal"
                                                                class="px-4 py-2 bg-gray-500 text-white rounded">Cancel</button>
                                                            <button type="button" id="saveExpenseHeadBtn"
                                                                class="px-4 py-2 bg-blue-600 text-white rounded">Save</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Success Modal -->
                                            <div id="expenseSuccessModal"
                                                class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Expense Head added successfully.</p>
                                                    <button type="button" id="closeExpenseSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                        Close
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="expenseErrorModal"
                                                class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
                                                <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                    <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                    <p id="expenseErrorMessage" class="text-gray-700"></p>
                                                    <div class="flex justify-end mt-4">
                                                        <button type="button" id="closeExpenseErrorModal"
                                                            class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Voucher / Receipt No. </label>
                                                    <input type="text" class="input w-full border mt-2"
                                                        name="receipt_no"
                                                        value="{{ old('receipt_no', $expense->receipt_no) }}"
                                                        placeholder="Enter Voucher / Receipt Number">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-receipt-number"></div>
                                                </div>
                                            </div>

                                            {{-- ASSET AND LIABILITY RADIO SECTION --}}
                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label class="block font-medium text-gray-700">Expense Type

                                                    </label>
                                                    <div class="flex items-center space-x-6 mt-2">
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="type" value="asset"
                                                                class="type-radio w-4 h-4">
                                                            <span>Assets</span>
                                                        </label>
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="type" value="liability"
                                                                class="type-radio w-4 h-4">
                                                            <span>Liabilities</span>
                                                        </label>

                                                        <button type="button" id="clearTypeSelection"
                                                            class="ml-4 px-3 py-1 bg-gray-200 text-gray-700 rounded hover:bg-gray-300">
                                                            Clear
                                                        </button>
                                                    </div>

                                                </div>
                                            </div>

                                            <!-- Add Asset Modal -->
                                            <div id="assetModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                    <h2 class="text-lg font-bold mb-4">Add New Asset</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Organisation <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="organisation_id_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select Organisation --
                                                                </option>
                                                                @foreach ($organisations as $org)
                                                                <option value="{{ $org->organisation_id }}">
                                                                    {{ $org->organisation_name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-organisation-id"></div>
                                                        </div>

                                                        <div id="account_type_asset">
                                                            <label>Division </label>
                                                            <select id="account_type_id_new2"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select Division --
                                                                </option>
                                                                @foreach ($accountTypes as $acc)
                                                                <option value="{{ $acc->account_type_id }}">
                                                                    {{ $acc->account_type_Name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-account-type-id"></div>
                                                        </div>

                                                        <div>
                                                            <label>Asset Name <span
                                                                    class="text-red-500">*</span></label>
                                                            <input type="text" id="asset_name"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-asset-name"></div>
                                                        </div>

                                                        <div>
                                                            <label>Asset Type </label>
                                                            <input type="text" id="asset_type"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-asset-type"></div>
                                                        </div>

                                                        <div>
                                                            <label>Depreciation (%)</label>
                                                            <input type="text" id="depreciation"
                                                                class="w-full border p-2 rounded">
                                                        </div>

                                                        {{-- <div>
                                                                <label>Useful Life (Years)</label>
                                                                <input type="number" id="asset_useful_life"
                                                                    class="w-full border p-2 rounded">
                                                            </div> --}}
                                                    </div>

                                                    <div class="flex justify-end space-x-2 mt-6">
                                                        <button type="button" id="closeAssetModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="saveAssetBtn"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Success Modal -->
                                            <div id="assetSuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Asset added successfully.</p>
                                                    <button type="button" id="closeAssetSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Close</button>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="assetErrorModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4 text-red-600">Error!</h2>
                                                    <p id="assetErrorMessage"></p>
                                                    <button type="button" id="closeAssetErrorModal"
                                                        class="mt-4 px-4 py-2 bg-red-500 text-white rounded hover:bg-red-600">Close</button>
                                                </div>
                                            </div>

                                            {{-- liabilit add modal --}}
                                            <div id="liabilityModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                    <h2 class="text-lg font-bold mb-4">Add New Liability</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Organisation <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="liability_organisation_id"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select --</option>
                                                                @foreach ($organisations as $org)
                                                                <option value="{{ $org->organisation_id }}">
                                                                    {{ $org->organisation_name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-organisation-id"></div>
                                                        </div>

                                                        <div id="account_type_liability">
                                                            <label>Division </label>
                                                            <select id="liability_account_type_id"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select --</option>
                                                                @foreach ($accountTypes as $acc)
                                                                <option value="{{ $acc->account_type_id }}">
                                                                    {{ $acc->account_type_Name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-account-type-id"></div>
                                                        </div>
                                                        <div>
                                                            <label>Liability Name <span
                                                                    class="text-red-500">*</span></label>
                                                            <input type="text" id="liability_name"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-name"></div>
                                                        </div>

                                                        <div>
                                                            <label>Liability Type </label>
                                                            <input type="text" id="liability_type"
                                                                class="w-full border p-2 rounded">
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-liability-type"></div>
                                                        </div>



                                                    </div>

                                                    <div class="flex justify-end space-x-2 mt-6">
                                                        <button type="button" id="closeLiabilityModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="saveLiabilityBtn"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>

                                            {{-- liab success modal --}}
                                            <div id="liabilitySuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Liability added successfully.</p>
                                                    <button type="button" id="closeLiabilitySuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Close</button>
                                                </div>
                                            </div>

                                            {{-- liab error modal --}}
                                            <div id="liabilityErrorModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4 text-red-600">Error!</h2>
                                                    <p id="liabilityErrorMessage"></p>
                                                    <button type="button" id="closeLiabilityErrorModal"
                                                        class="mt-4 px-4 py-2 bg-red-500 text-white rounded hover:bg-red-600">Close</button>
                                                </div>
                                            </div>

                                            <div class="w-full px-4">
                                                <div id="assetSection" class="mt-3 hidden relative">
                                                    <label>
                                                        <span class="text-gray-700">Select Asset
                                                            <button type="button" id="openAssetModalBtn"
                                                                class="px-2 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 hidden">
                                                                +
                                                            </button>

                                                        </span>
                                                        <input type="text" id="assetInput"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Type to search asset...">
                                                    </label>
                                                    <ul id="assetList"
                                                        class="absolute w-full bg-white border rounded mt-1 max-h-40 overflow-y-auto hidden z-10 custm-drpdwn">
                                                        @foreach ($assets as $asset)
                                                        <li data-id="{{ $asset->asset_id }}"
                                                            class="px-3 py-2 hover:bg-gray-100 cursor-pointer">
                                                            {{ $asset->asset_name }}
                                                        </li>
                                                        @endforeach
                                                    </ul>
                                                    <input type="hidden" name="asset_id" id="assetHidden">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-type-asset"></div>
                                                </div>
                                            </div>

                                            <div class="w-full px-4">
                                                <div id="liabilitySection" class="mt-3 hidden relative">
                                                    <label>
                                                        <span class="text-gray-700">Select Liability
                                                            <button type="button" id="openLiabilityModalBtn"
                                                                class="px-2 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 hidden">
                                                                +
                                                            </button>
                                                        </span>
                                                        <input type="text" id="liabilityInput"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Type to search liability...">
                                                    </label>
                                                    <ul id="liabilityList"
                                                        class="absolute w-full bg-white border rounded mt-1 max-h-40 overflow-y-auto hidden z-10 custm-drpdwn">
                                                        @foreach ($liabilities as $liability)
                                                        <li data-id="{{ $liability->liability_id }}"
                                                            class="px-3 py-2 hover:bg-gray-100 cursor-pointer">
                                                            {{ $liability->liability_name }}
                                                        </li>
                                                        @endforeach
                                                    </ul>
                                                    <input type="hidden" name="liability_id" id="liabilityHidden">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-type-liability"></div>
                                                </div>
                                            </div>
                                            {{-- END ASSET AND LIABILITY RADIO SECTION --}}

                                            {{-- START vendor/staff --}}
                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label class="block font-medium text-gray-700">Pay To</label>
                                                    <div class="flex items-center space-x-6 mt-2">
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="payee_type" value="internal"
                                                                class="payee-type-radio w-4 h-4">
                                                            <span>Staff</span>
                                                        </label>
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="payee_type" value="external"
                                                                class="payee-type-radio w-4 h-4">
                                                            <span>Vendor</span>
                                                        </label>
                                                        <button type="button" id="clearPayeeSelection"
                                                            class="ml-4 px-3 py-1 bg-gray-200 text-gray-700 rounded hover:bg-gray-300 ">
                                                            Clear
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="mt-3 hidden relative" id="payeeWrapper">
                                                    <label class="flex items-center justify-between">
                                                        <span class="text-gray-700">Select Payee</span>
                                                        <input type="text" id="payeeInput"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Type to search payee...">
                                                        <button type="button" id="addVendorBtn"
                                                            class="ml-2 bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">+</button>
                                                    </label>
                                                    <ul id="payeeList"
                                                        class="absolute w-full bg-white border rounded mt-1 max-h-40 overflow-y-auto hidden z-10 custm-drpdwn">
                                                        @foreach ($vendors as $vendor)
                                                        <li data-id="{{ $vendor->vendor_id }}"
                                                            data-type="internal" class="px-3 py-2">
                                                            {{ $vendor->vendor_name }}
                                                        </li>
                                                        @endforeach

                                                        @foreach ($vendors as $vendor)
                                                        <li data-id="{{ $vendor->vendor_id }}"
                                                            data-type="external" class="px-3 py-2 ">
                                                            {{ $vendor->vendor_name }}
                                                        </li>
                                                        @endforeach
                                                    </ul>
                                                    <input type="hidden" name="payee_id" id="payeeHidden">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-asset-payee"></div>
                                                </div>
                                                <div class="mt-3 hidden" id="vendorAmountWrapper">
                                                    <label>
                                                        <span class="text-gray-700" style="color: blue;">Total Bill
                                                            Amount
                                                            (₹) </span>

                                                        <input type="text" name="vendor_total_amount"
                                                            id="vendorTotalAmount"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Enter total amount"
                                                            value="{{ old('vendor_total_amount', $vendorRecord->total_amount ?? '') }}">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-asset-payee-amount">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <!-- Vendor Modal -->
                                            <div id="vendorModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                    <h2 class="text-lg font-bold mb-4">Add New Vendor</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Vendor Type <span style="color:red">*</span></label>
                                                            <select id="vendor_type_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select --</option>
                                                                <option value="internal">Staff</option>
                                                                <option value="external">Vendor</option>
                                                            </select>
                                                        </div>
                                                        <div>
                                                            <label>Vendor Name <span style="color:red">*</span></label>
                                                            <input type="text" id="vendor_name"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        {{-- <div>
                                                                <label>Contact Person</label>
                                                                <input type="text" id="vendor_contact_person"
                                                                    class="w-full border p-2 rounded">
                                                            </div> --}}
                                                        <div>
                                                            <label>Phone</label>
                                                            <input type="text" id="vendor_phone_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        {{-- <div>
                                                                <label>Email</label>
                                                                <input type="email" id="vendor_email"
                                                                    class="w-full border p-2 rounded">
                                                            </div> --}}
                                                        <div>
                                                            <label>GST Number</label>
                                                            <input type="text" id="vendor_gst_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        <div>
                                                            <label>PAN Number</label>
                                                            <input type="text" id="vendor_pan_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        {{-- <div>
                                                                <label>Payment Terms</label>
                                                                <input type="text" id="vendor_payment_terms"
                                                                    class="w-full border p-2 rounded">
                                                            </div> --}}
                                                        <div>
                                                            <label>Bank Account No</label>
                                                            <input type="text" id="vendor_bank_account_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        <div>
                                                            <label>Bank IFSC</label>
                                                            <input type="text" id="vendor_bank_ifsc"
                                                                class="w-full border p-2 rounded">
                                                        </div>

                                                    </div>

                                                    <div class="mt-4">
                                                        <label>Address</label>
                                                        <textarea id="vendor_address" class="w-full border p-2 rounded"></textarea>
                                                    </div>

                                                    <div class="flex justify-end space-x-2 mt-6">
                                                        <button type="button" id="closeVendorModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="saveVendor"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Success Modal -->
                                            <div id="vendorSuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Vendor added successfully.</p>
                                                    <button type="button" id="vendorCloseSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                        Close
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="vendorErrorModal"
                                                class="hidden fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50">
                                                <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                    <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                    <p id="vendorErrorMessage" class="text-gray-700"></p>
                                                    <div class="flex justify-end mt-4">
                                                        <button type="button" id="vendorCloseErrorModal"
                                                            class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- END vendor/staff --}}

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Transaction Amount (₹) <span
                                                            style="color: red">*</span></label>
                                                    <input type="text" class="input w-full border mt-2"
                                                        name="transaction_amount"
                                                        value="{{ old('transaction_amount', $expense->transaction_amount) }}"
                                                        placeholder="Enter Transaction Amount">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-amount"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Payment Type <span style="color: red">*</span> </label>
                                                    <select id="payment_type_id" name="payment_type_id"
                                                        class="input w-full border mt-2 custm-drpdwn">
                                                        <option value="">-- Select Payment Type --</option>

                                                        @foreach ($paymentTypes->where('parent_id', null) as $parent)
                                                        @php
                                                        $children = $paymentTypes->where(
                                                        'parent_id',
                                                        $parent->id,
                                                        );
                                                        @endphp

                                                        @if ($children->isEmpty())
                                                        <option value="{{ $parent->id }}"
                                                            {{ old('payment_type_id', $expense->payment_type_id) == $parent->id ? 'selected' : '' }}>
                                                            {{ $parent->name }}
                                                        </option>
                                                        @else
                                                        <optgroup label="{{ $parent->name }}">
                                                            @foreach ($children as $child)
                                                            <option value="{{ $child->id }}"
                                                                {{ old('payment_type_id', $expense->payment_type_id) == $child->id ? 'selected' : '' }}>
                                                                {{ $child->name }}
                                                            </option>
                                                            @endforeach
                                                        </optgroup>
                                                        @endif
                                                        @endforeach
                                                    </select>

                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-payment-type"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Date of Transaction <span
                                                            style="color: red">*</span></label>
                                                    <input type="date" class="input w-full border mt-2"
                                                        name="transaction_date" min="{{ $minDate }}"
                                                        max="{{ $maxDate }}" value="{{ $transactionDate }}"
                                                        onfocus="this.showPicker()" />
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-date">
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="w-6/12 px-4">

                                                <div class="mt-3">
                                                    <label>Transaction Reference No.</label>
                                                    <input id="transaction_reference" type="text"
                                                        class="input w-full border mt-2" name="transaction_reference"
                                                        value="{{ old('transaction_reference', $expense->transaction_reference) }}"
                                                        placeholder="Enter Transaction Reference">
                                                    <div class="text-gray-500 text-xs mt-1">
                                                        Only letters and numbers allowed, 5–20 characters.
                                                    </div>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-reference"></div>
                                                </div>
                                            </div>

                                            <div class="w-6/12 hidden px-4">
                                                <div class="mt-3 relative">
                                                    <label class="flex items-center justify-between">
                                                        <span>Transaction Purpose <span
                                                                style="color: red">*</span></span>
                                                        <button type="button" id="addPurposeBtn"
                                                            class="ml-2 bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">+</button></label>
                                                    {{-- <input id="transaction_purpose" type="text"
                                                            class="input w-full border mt-2" name="transaction_purpose"
                                                            placeholder="Search Purpose..."
                                                            value="{{ old('transaction_purpose', $expense->purpose->name ?? '') }}"> --}}


                                                    {{-- <input type="hidden" id="transaction_purpose_id"
                                                            name="transaction_purpose_id"
                                                            value="{{ old('transaction_purpose_id', $expense->purpose_id ?? '') }}"> --}}
                                                    <ul id="purpose-suggestions"
                                                        class="absolute bg-white border rounded-md shadow-md mt-1 w-full z-10 hidden max-h-40 overflow-y-auto custm-drpdwn">
                                                    </ul>

                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-purpose"></div>
                                                </div>
                                            </div>

                                            <!-- Modal -->
                                            <div id="purposeModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96">
                                                    <h2 class="text-lg font-bold mb-4">Add New Purpose</h2>
                                                    <input type="text" id="newPurpose"
                                                        class="input w-full border p-2 mb-4"
                                                        placeholder="Enter new purpose">

                                                    <div class="flex justify-end space-x-2">
                                                        <button type="button" id="closeModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="savePurpose"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Success Modal -->
                                            <div id="purposeSuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Purpose added successfully.</p>
                                                    <button type="button" id="closeSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                        Close
                                                    </button>
                                                </div>
                                            </div>
                                            <!-- Error Modal -->
                                            <div id="purposeErrorModal"
                                                class="hidden fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50">
                                                <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                    <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                    <p id="purposeErrorMessage" class="text-gray-700"></p>
                                                    <div class="flex justify-end mt-4">
                                                        <button type="button" id="closeErrorModal"
                                                            class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Transaction Narration </label>
                                                    <textarea class="input w-full border mt-2" name="transaction_narration" placeholder="Enter Transaction Narration">{{ old('transaction_narration', $expense->transaction_narration) }}</textarea>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-narration"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Upload Images / PDFs</label>
                                                    <input type="file" class="w-full border mt-2 p-2 rounded"
                                                        name="expense_files[]" id="expense_files"
                                                        accept="image/*,application/pdf" multiple>
                                                    <ul id="file-list" class="mt-2 text-sm text-gray-600 space-y-1">
                                                    </ul>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-expense-files"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- </div> --}}

                        </div>
                        <div class="sm:pl-5 mt-5">

                            <a href="{{ route('expense.index') }}"><span
                                    class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                                    ← Back
                                </span></a>
                            <button type="submit" class="button w-24 bg-theme-1 text-white">Save</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
        <!-- END: Horizontal Form -->
    </div>
    <!-- END: Select Options -->
</div>
{{-- <div class="intro-y col-span-12 lg:col-span-6">
    </div> --}}

<script>
    // organisation and account type checking start
    let accountTypes = @json($accountTypes);
    let purposes = @json($purposes);
    let expense = @json($expense);
    const existingFiles = @json($existingFiles ?? []);

    window.existingExpense = {
        type: "{{ $expense->expense_type ?? '' }}",
        asset_id: "{{ $expense->asset_id ?? '' }}",
        liability_id: "{{ $expense->liability_id ?? '' }}",
        payee_type: "{{ $expense->pay_to ?? '' }}",
        payee_id: "{{ $expense->pay_to == 'internal' ? $expense->staff_id : $expense->vendor_id ?? '' }}",
        vendor_amount: "{{ $vendorRecord->total_amount ?? '' }}"
    };

    let orgSelect = document.getElementById('organisation_id');
    let accSelect = document.getElementById('account_type_id');
    let msg = document.getElementById('accountTypeMsg');


    let oldOrg = "{{ old('organisation_id', $expense->organisation_id ?? '') }}";
    let oldAcc = "{{ old('account_type_id', $expense->account_type_id ?? '') }}";

    function populateAccountTypes(orgId) {
        accSelect.innerHTML = '<option value="">-- Select Account Type --</option>';

        if (orgId) {
            let filtered = accountTypes.filter(at => at.organisation_id == orgId);

            if (filtered.length > 0) {
                document.getElementById("accountTypeWrapper").style.display = "block";
                filtered.forEach(at => {
                    let option = document.createElement('option');
                    option.value = at.account_type_id;
                    option.textContent = at.account_type_Name;

                    if (String(oldAcc) === String(at.account_type_id)) {
                        option.selected = true;
                    }
                    accSelect.appendChild(option);
                });

                accSelect.disabled = false;
                msg.style.display = "none";
            } else {
                accSelect.disabled = true;
                msg.textContent = "No account types found for this organisation.";
                msg.style.display = "block";
                document.getElementById("accountTypeWrapper").style.display = "none";
            }
        } else {
            accSelect.disabled = true;
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
            document.getElementById("accountTypeWrapper").style.display = "none";
        }
    }

    orgSelect.addEventListener('change', function() {
        oldAcc = "";
        populateAccountTypes(this.value);
    });

    accSelect.addEventListener('focus', function() {
        if (!orgSelect.value) {
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
            setTimeout(() => msg.style.display = "none", 2000);
        }
    });

    if (oldOrg) {
        orgSelect.value = oldOrg;
        populateAccountTypes(oldOrg);
    }
    // organisation and account type checking end

    $(document).ready(function() {

        console.log(window.existingExpense);

        $("input[name='type']").on("click", function(e) {
            const orgId = $("#organisation_id").val();
            const accountTypeId = $("#account_type_id").val();
            const $errorDiv = $("#error-organisation");
            const $errorDiv2 = $("#error-account-type");

            $errorDiv.text("");

            if (!orgId) {
                e.preventDefault();
                $errorDiv.text("Please select Organisation first.");
                return;
            }

            if (orgId != 2 && !accountTypeId) {
                e.preventDefault();
                $errorDiv2.text("Please select Division first.");
                return;
            }
        });

        function toggleExpenseHeadBtn() {
            const orgId = $("#organisation_id").val();
            const accountTypeId = $("#account_type_id").val();

            if (!orgId) {
                $("#addExpenseHeadBtn").addClass("hidden");
                // $("#addVendorBtn").addClass("hidden");
                return;
            }

            if (orgId == 2) {
                $("#addExpenseHeadBtn").removeClass("hidden");
                $("#addVendorBtn").removeClass("hidden");
            } else {
                if (accountTypeId) {
                    $("#addExpenseHeadBtn").removeClass("hidden");
                    $("#addVendorBtn").removeClass("hidden");
                } else {
                    $("#addExpenseHeadBtn").addClass("hidden");
                    $("#addVendorBtn").addClass("hidden");
                }
            }
        }
        $("#organisation_id, #account_type_id").on("change", toggleExpenseHeadBtn);
        toggleExpenseHeadBtn();

        $("#organisation_id").on("change", function() {
            $("#error-organisation").text("");
        });
        $("#account_type_id").on("change", function() {
            $("#error-account-type").text("");
        });


        $("#expenseForm").on("submit", function(e) {
            e.preventDefault();
            // console.log(expense);
            const formData = new FormData(this);

            $(".error-message").text("");
            $("input, select, textarea").removeClass("border-red-500");

            let isValid = true;

            if ($("#organisation_id").val().trim() === "") {
                $("#error-organisation").text("Organisation is required");
                $("#organisation_id").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#organisation_id");

                isValid = false;
            }

            let orgId = $("#organisation_id").val();
            let filtered = accountTypes.filter(at => at.organisation_id == orgId);

            if (filtered.length > 0) {
                if ($.trim($("#account_type_id").val()) === "") {
                    $("#error-account-type").text("Account Type is required");
                    $("#account_type_id").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#account_type_id");

                    isValid = false;
                }
            }


            if ($.trim($("#payment_type_id").val()) === "") {
                $("#error-payment-type").text("Payment Type is required");
                $("#payment_type_id").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#payment_type_id");

                isValid = false;
            } else {
                $("#error-payment-type").text("");
                $("#payment_type_id").removeClass("border-red-500");
            }

            // if (!$hiddenId.val()) {
            //     e.preventDefault();
            //     $("#error-transaction-purpose").text("Purpose not in list . Please add the purpose. ");
            //     $input.addClass("border-red-500");
            // }
            // if (!$.trim($("#transaction_purpose_id").val())) {
            //     $("#error-transaction-purpose").text("Purpose not in list . Please add the purpose. ");
            //     $("#transaction_purpose").addClass("border-red-500");
            //     if (!firstInvalidField) firstInvalidField = $("#transaction_purpose_id");

            //     isValid = false;
            // }
            // if ($.trim($("#transaction_purpose").val()) === "") {
            //     $("#error-transaction-purpose").text("Transaction Purpose is required");
            //     $("#transaction_purpose").addClass("border-red-500");
            //     if (!firstInvalidField) firstInvalidField = $("#transaction_purpose");

            //     isValid = false;
            // }
            if ($.trim($("#expense_head_id").val()) === "") {
                $("#error-expense-head").text("Expense Head is required");
                $("#expense_head_id").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#expense_head_id");

                isValid = false;
            }
            if ($("input[name='transaction_amount']").val().trim() === "") {
                $("#error-transaction-amount").text("Transaction Amount is required");
                $("input[name='transaction_amount']").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#transaction_amount");

                isValid = false;
            }
            if ($("input[name='transaction_date']").val().trim() === "") {
                $("#error-date").text("Transaction Date is required");
                $("input[name='transaction_date']").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#transaction_date");

                isValid = false;
            }
            if (!isValid) {
                if (firstInvalidField) {
                    $('html, body').animate({
                        scrollTop: firstInvalidField.offset().top - 100
                    }, 500);
                    // firstInvalidField.focus();
                }
                return;
            }

            $.ajax({
                url: "{{ route('expense.update', ['id' => $expense->expense_id]) }}",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        window.location.href = "{{ route('expense.index') }}";
                    } else {
                        alert("Something went wrong. Please try again.");
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        let messages = [];
                        for (let key in errors) {
                            messages.push(errors[key][0]);
                        }
                        alert(messages.join("\n"));
                    } else {
                        alert("Something went wrong. Please try again.");
                    }
                }
            });
        });

        $("#organisation").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-organisation").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#expense_head_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-expense-head").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#account_type_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-account-type").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("input[name='transaction_amount']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-amount").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("input[name='transaction_reference']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-reference").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("input[name='transaction_date']").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-date").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#transaction_purpose").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-purpose").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#payment_type_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-payment-type").text("");
                $(this).removeClass("border-red-500");
            }
        });
        // purpose start :

        let $input = $("#transaction_purpose");
        let $hiddenId = $("#transaction_purpose_id");
        let $suggestionBox = $("#purpose-suggestions");

        $input.on("input", function() {
            let query = $(this).val().toLowerCase();
            $suggestionBox.empty().addClass("hidden");
            $hiddenId.val("");

            if (query.length > 0) {
                let matches = purposes
                    .map(p => {
                        let name = p.name.toLowerCase();
                        let score = 0;
                        query.split(" ").forEach(qw => {
                            if (name.includes(qw)) score++;
                        });
                        return {
                            ...p,
                            score
                        };
                    })
                    .filter(p => p.score > 0)
                    .sort((a, b) => b.score - a.score);

                if (matches.length > 0) {
                    $suggestionBox.removeClass("hidden");
                    $.each(matches, function(_, match) {
                        $("<li>")
                            .text(match.name)
                            .attr("data-id", match.id)
                            .addClass("px-3 py-2 hover:bg-gray-200 cursor-pointer")
                            .on("click", function() {
                                $input.val(match.name);
                                $hiddenId.val(match.id);
                                $suggestionBox.addClass("hidden");
                                $("#error-transaction-purpose").text("");
                            })
                            .appendTo($suggestionBox);
                    });
                }
            }
        });
        $(document).on("click", function(e) {
            if (!$(e.target).closest("#transaction_purpose, #purpose-suggestions").length) {
                $suggestionBox.addClass("hidden");
            }
        });

        // purpose ends:

    });

    $("#transaction_reference").on("input", function() {
        let value = $(this).val();
        value = value.replace(/[^A-Za-z0-9]/g, "");
        if (value.length > 20) {
            value = value.substring(0, 20);
        }
        $(this).val(value);
        let errorDiv = $("#error-transaction-reference");
        if (value.length < 5) {
            errorDiv.text("Transaction reference must be at least 5 characters.");
        } else {
            errorDiv.text("");
        }
    });


    //puRpose add logic::

    document.getElementById('addPurposeBtn').addEventListener('click', function() {
        document.getElementById('purposeModal').classList.remove('hidden');
    });

    document.getElementById('closeModal').addEventListener('click', function() {
        document.getElementById('purposeModal').classList.add('hidden');
    });

    document.getElementById('savePurpose').addEventListener('click', function(e) {
        e.preventDefault();
        let newPurpose = document.getElementById('newPurpose').value.trim();
        let purpose_for = "expense";
        if (newPurpose === "") return;

        fetch("{{ route('purpose.store') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                },
                body: JSON.stringify({
                    purpose: newPurpose,
                    purpose_for: purpose_for
                })
            })
            .then(async res => {
                let data = await res.json();

                if (!res.ok) {
                    showErrorModal(data.message || "Something went wrong while saving the purpose.");
                    return;
                }
                if (data.success) {
                    document.getElementById("transaction_purpose").value = data.purpose.name;
                    document.getElementById("transaction_purpose_id").value = data.purpose.id;

                    purposes.push({
                        id: data.purpose.id,
                        name: data.purpose.name
                    });

                    let ul = document.getElementById('purpose-suggestions');
                    let li = document.createElement('li');
                    li.textContent = data.purpose.name;
                    li.setAttribute("data-id", data.purpose.id);
                    li.classList.add("px-3", "py-2", "cursor-pointer", "hover:bg-gray-100");

                    li.addEventListener("click", function() {
                        document.getElementById("transaction_purpose").value = this.textContent;
                        document.getElementById("transaction_purpose_id").value = this
                            .getAttribute(
                                "data-id");
                        ul.classList.add("hidden");
                    });

                    ul.appendChild(li);
                    ul.classList.remove("hidden");
                    document.getElementById("transaction_purpose").value = data.purpose.name;
                    document.getElementById("transaction_purpose_id").value = data.purpose.id;
                    document.getElementById("error-transaction-purpose").textContent = "";

                    document.getElementById('newPurpose').value = "";
                    document.getElementById('purposeModal').classList.add('hidden');
                    showSuccessModal();
                }
            })

            .catch(err => {
                console.error(err);
                showErrorModal("Network error. Please try again.");
            });
    });

    function showSuccessModal() {
        const modal = document.getElementById('purposeSuccessModal');
        modal.classList.remove('hidden');

        document.getElementById('closeSuccessModal').addEventListener('click', function() {
            modal.classList.add('hidden');
        });

        setTimeout(() => {
            modal.classList.add('hidden');
        }, 3000);
    }

    function showErrorModal(message) {
        const modal = document.getElementById('purposeErrorModal');
        const msgBox = document.getElementById('purposeErrorMessage');

        msgBox.textContent = message;
        modal.classList.remove('hidden');

        document.getElementById('closeErrorModal').addEventListener('click', function() {
            modal.classList.add('hidden');
        });

    }
    document.getElementById("closeModal").addEventListener("click", function(e) {
        e.preventDefault();
        document.getElementById("purposeModal").classList.add("hidden");
    });

    document.getElementById("closeSuccessModal").addEventListener("click", function(e) {
        e.preventDefault();
        document.getElementById("purposeSuccessModal").classList.add("hidden");
    });

    // purpose add logic ends::

    //for assets and liabilities checkbox logic:
    document.addEventListener("DOMContentLoaded", function() {
        const radios = document.querySelectorAll(".type-radio");
        const assetSection = document.getElementById("assetSection");
        const liabilitySection = document.getElementById("liabilitySection");
        const clearBtn = document.getElementById("clearTypeSelection");

        const assetInput = document.getElementById("assetInput");
        const assetList = document.getElementById("assetList");
        const assetHidden = document.getElementById("assetHidden");

        const liabilityInput = document.getElementById("liabilityInput");
        const liabilityList = document.getElementById("liabilityList");
        const liabilityHidden = document.getElementById("liabilityHidden");

        radios.forEach(radio => {
            radio.addEventListener("change", function() {
                if (this.value === "asset") {
                    assetSection.classList.remove("hidden");
                    liabilitySection.classList.add("hidden");
                    liabilityInput.value = "";
                    liabilityHidden.value = "";
                } else if (this.value === "liability") {
                    liabilitySection.classList.remove("hidden");
                    assetSection.classList.add("hidden");
                    assetInput.value = "";
                    assetHidden.value = "";
                }
                clearBtn.classList.remove("hidden");
            });
        });

        assetInput.addEventListener("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
            const filter = this.value.toLowerCase();
            let hasMatch = false;
            assetList.querySelectorAll("li").forEach(li => {
                if (li.textContent.toLowerCase().includes(filter)) {
                    li.style.display = "block";
                    hasMatch = true;
                } else {
                    li.style.display = "none";
                }
            });
            assetList.classList.toggle("hidden", !hasMatch || filter === "");

            if (filter === "") {
                assetList.classList.add("hidden");
                document.getElementById("openAssetModalBtn").classList.add("hidden");
            } else if (hasMatch) {
                assetList.classList.remove("hidden");
                document.getElementById("openAssetModalBtn").classList.add("hidden");
            } else {
                assetList.classList.add("hidden");
                document.getElementById("openAssetModalBtn").classList.remove("hidden");
            }
        });

        assetList.addEventListener("click", function(e) {
            if (e.target.tagName === "LI") {
                assetInput.value = e.target.textContent;
                assetHidden.value = e.target.dataset.id;
                assetList.classList.add("hidden");

                assetInput.readOnly = true;
            }
        });

        liabilityInput.addEventListener("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
            const filter = this.value.toLowerCase();
            let hasMatch = false;
            liabilityList.querySelectorAll("li").forEach(li => {
                if (li.textContent.toLowerCase().includes(filter)) {
                    li.style.display = "block";
                    hasMatch = true;
                } else {
                    li.style.display = "none";
                }
            });
            liabilityList.classList.toggle("hidden", !hasMatch || filter === "");
            if (filter === "") {
                liabilityList.classList.add("hidden");
                document.getElementById("openLiabilityModalBtn").classList.add("hidden");
            } else if (hasMatch) {
                liabilityList.classList.remove("hidden");
                document.getElementById("openLiabilityModalBtn").classList.add("hidden");
            } else {
                liabilityList.classList.add("hidden");
                document.getElementById("openLiabilityModalBtn").classList.remove("hidden");
            }
        });

        liabilityList.addEventListener("click", function(e) {
            if (e.target.tagName === "LI") {
                liabilityInput.value = e.target.textContent;
                liabilityHidden.value = e.target.dataset.id;
                liabilityList.classList.add("hidden");


                liabilityInput.readOnly = true;
            }
        });
        clearBtn.addEventListener("click", function() {
            radios.forEach(radio => radio.checked = false);
            assetSection.classList.add("hidden");
            liabilitySection.classList.add("hidden");
            assetInput.value = "";
            liabilityInput.value = "";
            assetHidden.value = "";
            liabilityHidden.value = "";
            // clearBtn.classList.add("hidden");

            liabilityInput.readOnly = false;
            assetInput.readOnly = false;
            document.getElementById("openAssetModalBtn").classList.add("hidden");
            document.getElementById("openLiabilityModalBtn").classList.add("hidden");

            assetList.classList.add("hidden");
            liabilityList.classList.add("hidden");
        });
    });
    //end for assets and liabilities checkbox logic 

    // for vendor listing:
    document.addEventListener("DOMContentLoaded", function() {
        const radios = document.querySelectorAll(".payee-type-radio");
        const payeeWrapper = document.getElementById("payeeWrapper");
        const payeeInput = document.getElementById("payeeInput");
        const payeeList = document.getElementById("payeeList");
        const payeeHidden = document.getElementById("payeeHidden");
        const clearBtn = document.getElementById("clearPayeeSelection");
        const vendorAmountWrapper = document.getElementById("vendorAmountWrapper");


        let currentType = null;

        radios.forEach(radio => {
            radio.addEventListener("change", function() {
                currentType = this.value;
                payeeWrapper.classList.remove("hidden");
                payeeInput.value = "";
                payeeHidden.value = "";
                payeeList.classList.add("hidden");
                clearBtn.classList.remove("hidden");
                vendorAmountWrapper.classList.add("hidden");
            });
        });

        payeeInput.addEventListener("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
            const filter = this.value.toLowerCase();
            let hasMatch = false;
            payeeList.querySelectorAll("li").forEach(li => {
                if (li.dataset.type === currentType &&
                    li.textContent.toLowerCase().includes(filter)) {
                    // li.style.display = "block";
                    hasMatch = true;
                } else {
                    li.style.display = "none";
                }
            });
            payeeList.classList.toggle("hidden", !hasMatch || filter === "");
        });

        payeeList.addEventListener("click", function(e) {
            if (e.target.tagName === "LI") {
                payeeInput.value = e.target.textContent;
                payeeHidden.value = e.target.dataset.id;
                payeeList.classList.add("hidden");
                payeeInput.readOnly = true;
            }

            if (e.target.dataset.type === "external") {
                vendorAmountWrapper.classList.remove("hidden");
            } else {
                vendorAmountWrapper.classList.add("hidden");
            }
        });

        clearBtn.addEventListener("click", function() {
            radios.forEach(r => r.checked = false);
            payeeWrapper.classList.add("hidden");
            payeeInput.value = "";
            payeeHidden.value = "";
            payeeList.classList.add("hidden");
            vendorAmountWrapper.classList.add("hidden");
            // clearBtn.classList.add("hidden");
            currentType = null;
            payeeInput.readOnly = false;
        });
    });
    // end for vendor listing:

    //start for vendor add logic

    $('#addVendorBtn').on('click', function() {
        let selectedType = $("input[name='payee_type']:checked").val();

        if (selectedType) {
            $("#vendor_type_new").val(selectedType);
        } else {
            $("#vendor_type_new").val("");
        }
        $('#vendorModal').removeClass('hidden');
    });
    $('#closeVendorModal').on('click', () => $('#vendorModal').addClass('hidden'));

    $('#saveVendor').on('click', function() {
        let vendorData = {
            _token: "{{ csrf_token() }}",
            vendor_type: $('#vendor_type_new').val(),
            vendor_name: $('#vendor_name').val(),
            vendor_contact_person: $('#vendor_contact_person').val() ?? null,
            vendor_phone_number: $('#vendor_phone_number').val(),
            vendor_email: $('#vendor_email').val(),
            vendor_address: $('#vendor_address').val(),
            vendor_gst_number: $('#vendor_gst_number').val(),
            vendor_pan_number: $('#vendor_pan_number').val(),
            vendor_payment_terms: $('#vendor_payment_terms').val() ?? null,
            vendor_bank_account_number: $('#vendor_bank_account_number').val(),
            vendor_bank_ifsc: $('#vendor_bank_ifsc').val(),

        };

        $.ajax({
            url: "{{ route('vendor.store') }}",
            type: "POST",
            data: vendorData,
            success: function(res) {
                if (res.success) {
                    $('#vendorModal').addClass('hidden');
                    $('#vendorSuccessModal').removeClass('hidden');

                    $('#payeeVendorRadio').prop('checked', true).trigger('change');

                    $('#payeeInput').val(res.vendor.vendor_name);
                    $('#payeeHidden').val(res.vendor.vendor_id);

                    if (res.vendor.vendor_type === "external") {
                        $('#vendorAmountWrapper').removeClass('hidden');
                        $('#amountPaidWrapper').removeClass('hidden');
                    } else {
                        $('#vendorAmountWrapper').addClass('hidden');
                        $('#amountPaidWrapper').removeClass('hidden');
                    }

                } else {
                    $('#vendorErrorMessage').text(res.message || "Failed to save vendor.");
                    $('#vendorErrorModal').removeClass('hidden');
                }
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                $('#vendorErrorMessage').text("Error: Could not save vendor.");
                $('#vendorErrorModal').removeClass('hidden');
            }
        });
    });

    $('#vendorCloseSuccessModal').on('click', () => $('#vendorSuccessModal').addClass('hidden'));
    $('#vendorCloseErrorModal').on('click', () => $('#vendorErrorModal').addClass('hidden'));


    // end for vendor add logic 

    document.addEventListener("DOMContentLoaded", function() {
        const exp = window.existingExpense;
        if (!exp) return;
        if (exp.type === "asset" && exp.asset_id) {
            const assetRadio = document.querySelector(`input[type="radio"].type-radio[value="asset"]`);
            assetRadio.checked = true;
            document.getElementById("assetSection").classList.remove("hidden");

            const assetLi = document.querySelector(`#assetList li[data-id="${exp.asset_id}"]`);
            if (assetLi) {
                const assetInput = document.getElementById("assetInput");
                assetInput.value = assetLi.textContent;
                document.getElementById("assetHidden").value = exp.asset_id;
                assetInput.readOnly = true;
            }

            document.getElementById("clearTypeSelection").classList.remove("hidden");
        }

        if (exp.type === "liability" && exp.liability_id) {
            const liabilityRadio = document.querySelector(`input[type="radio"].type-radio[value="liability"]`);
            liabilityRadio.checked = true;
            document.getElementById("liabilitySection").classList.remove("hidden");

            const liabilityLi = document.querySelector(`#liabilityList li[data-id="${exp.liability_id}"]`);
            if (liabilityLi) {
                const liabilityInput = document.getElementById("liabilityInput");
                liabilityInput.value = liabilityLi.textContent;
                document.getElementById("liabilityHidden").value = exp.liability_id;
                liabilityInput.readOnly = true;
            }

            document.getElementById("clearTypeSelection").classList.remove("hidden");
        }
        if (exp.payee_type && exp.payee_id) {
            const payeeRadio = document.querySelector(
                `input[type="radio"].payee-type-radio[value="${exp.payee_type}"]`);
            if (payeeRadio) payeeRadio.checked = true;

            const payeeWrapper = document.getElementById("payeeWrapper");
            payeeWrapper.classList.remove("hidden");

            const payeeInput = document.getElementById("payeeInput");
            const payeeHidden = document.getElementById("payeeHidden");
            const vendorAmountWrapper = document.getElementById("vendorAmountWrapper");
            const payeeLi = Array.from(document.querySelectorAll("#payeeList li")).find(li =>
                li.dataset.id == exp.payee_id && li.dataset.type == exp.payee_type
            );

            if (payeeLi) {
                payeeInput.value = payeeLi.textContent;
                payeeHidden.value = exp.payee_id;
                payeeInput.readOnly = true;

                if (exp.payee_type === "external") {
                    vendorAmountWrapper.classList.remove("hidden");
                    document.getElementById("vendorTotalAmount").value = exp.vendor_amount || 0;
                }
            }

            document.getElementById("clearPayeeSelection").classList.remove("hidden");
        }


    });

    //for file upload logic and append names 
    document.addEventListener("DOMContentLoaded", function() {
        const fileInput = document.getElementById('expense_files');
        const fileList = document.getElementById('file-list');
        const errorDiv = document.getElementById('error-expense-files');

        if (existingFiles.length > 0) {
            fileList.innerHTML = "";
            existingFiles.forEach(file => {
                const li = document.createElement("li");
                li.textContent = file.split("/").pop();
                fileList.appendChild(li);
            });
        }

        fileInput.addEventListener('change', function() {
            fileList.innerHTML = "";
            errorDiv.textContent = "";

            const maxTotalSize = 3 * 1024 * 1024;
            let totalSize = 0;
            let hasInvalidType = false;

            for (let i = 0; i < this.files.length; i++) {
                const file = this.files[i];
                totalSize += file.size;

                if (!file.type.startsWith("image/") && file.type !== "application/pdf") {
                    hasInvalidType = true;
                }
            }

            if (totalSize > maxTotalSize) {
                errorDiv.textContent = "Total file size must not exceed 3 MB.";
                this.value = "";
                return;
            }
            if (hasInvalidType) {
                errorDiv.textContent = "Only images and PDFs are allowed.";
                this.value = "";
                return;
            }
            for (let i = 0; i < this.files.length; i++) {
                const li = document.createElement("li");
                li.textContent = this.files[i].name;
                fileList.appendChild(li);
            }
        });
    });
    // end for file upload logic and append names 

    function cleanAmount(val) {
        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }
        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (val.startsWith("0.") || val === "0") {
            val = val.replace(/^0+/, "");
        }
        return val;
    }
    $("input[name='transaction_amount'], input[name='vendor_total_amount']").on("input", function() {
        this.value = cleanAmount(this.value);
    });

    // start: add expense heads logic.
    $("#addExpenseHeadBtn").on("click", function() {
        $("#expense_account_type_id").val($("#account_type_id").val());
        $("#expense_organisation_id_new").val($("#organisation_id").val());
        $("#expenseHeadModal").removeClass("hidden");
    });
    $("#closeExpenseHeadModal").on("click", function() {
        $("#expenseHeadModal").addClass("hidden");
    });
    $("#closeExpenseSuccessModal").on("click", function() {
        $("#expenseSuccessModal").addClass("hidden");
    });
    $("#closeExpenseErrorModal").on("click", function() {
        $("#expenseErrorModal").addClass("hidden");
    });
    $("#saveExpenseHeadBtn").on("click", function() {
        let payload = {
            _token: $("meta[name='csrf-token']").attr("content"),
            organisation_id: $('#expense_organisation_id_new').val().trim(),
            expense_head_name: $("#expense_head_name").val().trim(),
            account_type_id: $("#expense_account_type_id").val() || null,
            expense_head_group_id: $("#expense_head_group_id").val() || null,
            expense_head_group_opening_balance: $("#expense_head_group_opening_balance").val() || null
        };

        $.ajax({
            url: "{{ route('expensehead.store') }}",
            type: "POST",
            data: JSON.stringify(payload),
            contentType: "application/json",
            success: function(response) {
                if (response.success) {
                    $("#expenseHeadModal").addClass("hidden");
                    $("#expenseSuccessModal").removeClass("hidden");
                    let select = $("#expense_head_id");
                    let option = $("<option>")
                        .val(response.new_id)
                        .text(response.name)
                        .prop("selected", true);
                    select.append(option);
                    $("#expense_head_name").val("");
                    $("#expense_account_type_id").val("");
                    $("#expense_head_group_id").val("");
                    $("#expense_head_group_opening_balance").val("");
                }
            },
            error: function(xhr) {
                let res = xhr.responseJSON;
                if (res && res.errors) {
                    let messages = Object.values(res.errors).flat().join("<br>");
                    $("#expenseErrorMessage").html(messages);
                } else {
                    $("#expenseErrorMessage").text("Something went wrong.");
                }
                $("#expenseErrorModal").removeClass("hidden");
            }
        });
    });
    // end logic add expense heads:

    // start: Add Asset logic
    $("#openAssetModalBtn").on("click", function() {
        $("#organisation_id_new").val($("#organisation_id").val());
        $("#account_type_id_new2").val($("#account_type_id").val());

        if ($("#organisation_id_new").val() == 2) {
            $("#account_type_asset").hide();
        } else {
            $("#account_type_asset").show();
        }

        $("#assetModal").removeClass("hidden");
    });

    $("#closeAssetModal").on("click", function() {
        $("#assetModal").addClass("hidden");
    });

    $("#closeAssetSuccessModal").on("click", function() {
        $("#assetSuccessModal").addClass("hidden");
    });

    $("#closeAssetErrorModal").on("click", function() {
        $("#assetErrorModal").addClass("hidden");
    });

    $("#saveAssetBtn").on("click", function() {
        $(".error-message").text(""); // clear errors

        let payload = {
            _token: $("meta[name='csrf-token']").attr("content"),
            organisation_id: $("#organisation_id_new").val(),
            account_type_id: $("#account_type_id_new2").val(),
            asset_name: $("#asset_name").val().trim(),
            asset_type: $("#asset_type").val().trim(),
            depreciation: $("#depreciation").val(),
            asset_opening_balance: $("#asset_opening_balance").val(),
            asset_purchase_date: $("#asset_purchase_date").val(),
            financial_year_id: $("#financial_year_id").val(),
            asset_purchase_cost: $("#asset_purchase_cost").val(),
            asset_useful_life: $("#asset_useful_life").val(),
        };

        $.ajax({
            url: "{{ route('asset.store') }}",
            type: "POST",
            data: JSON.stringify(payload),
            contentType: "application/json",
            success: function(res) {
                if (res.success) {
                    $("#assetModal").addClass("hidden");
                    $("#assetSuccessModal").removeClass("hidden");

                    const li = $("<li>")
                        .attr("data-id", res.new_id)
                        .text(res.asset_name || res.name);

                    $("#assetList").append(li).removeClass("hidden");
                    $("#assetHidden").val(res.new_id);

                    $("#assetSuccessModal").css("z-index", "9999");
                }
            },
            error: function(xhr) {
                let res = xhr.responseJSON;
                if (res && res.errors) {
                    Object.keys(res.errors).forEach(function(key) {
                        $("#error-" + key.replace(/_/g, "-")).text(res.errors[key][0]);
                    });
                } else {
                    $("#assetErrorMessage").text("Something went wrong.");
                    $("#assetErrorModal").removeClass("hidden");
                }
            },
        });
    });
    // end: Add Asset logic


    // start: Add Liability logic
    $("#openLiabilityModalBtn").on("click", function() {
        $("#liability_organisation_id").val($("#organisation_id").val());
        $("#liability_account_type_id").val($("#account_type_id").val());

        if ($("#liability_organisation_id").val() == 2) {
            $("#account_type_liability").hide();
        } else {
            $("#account_type_liability").show();
        }

        $("#liabilityModal").removeClass("hidden");
    });

    $("#closeLiabilityModal").on("click", function() {
        $("#liabilityModal").addClass("hidden");
    });

    $("#closeLiabilitySuccessModal").on("click", function() {
        $("#liabilitySuccessModal").addClass("hidden");
    });

    $("#closeLiabilityErrorModal").on("click", function() {
        $("#liabilityErrorModal").addClass("hidden");
    });

    $("#saveLiabilityBtn").on("click", function() {
        $(".error-message").text(""); // clear errors

        let payload = {
            _token: $("meta[name='csrf-token']").attr("content"),
            organisation_id: $("#liability_organisation_id").val(),
            account_type_id: $("#liability_account_type_id").val(),
            financial_year_id: $("#liability_financial_year_id").val(),
            liability_name: $("#liability_name").val().trim(),
            liability_type: $("#liability_type").val().trim(),
            liability_date: $("#liability_date").val(),
            liability_opening_balance: $("#liability_opening_balance").val(),
            liability_amount: $("#liability_amount").val(),
            liability_due_date: $("#liability_due_date").val(),
            liability_status: $("#liability_status").val(),
        };

        $.ajax({
            url: "{{ route('liability.store') }}",
            type: "POST",
            data: JSON.stringify(payload),
            contentType: "application/json",
            success: function(res) {
                if (res.success) {
                    $("#liabilityModal").addClass("hidden");
                    $("#liabilitySuccessModal").removeClass("hidden");

                    const li = $("<li>")
                        .attr("data-id", res.new_id)
                        .text(res.liability_name || res.name);

                    $("#liabilityList").append(li).removeClass("hidden");
                    $("#liabilityHidden").val(res.new_id);

                    $("#liabilitySuccessModal").css("z-index", "9999");
                }
            },
            error: function(xhr) {
                const res = xhr.responseJSON;

                // clear previous errors
                $(".error-message").text("");

                if (res && res.errors) {
                    Object.keys(res.errors).forEach(function(key) {
                        const errorDiv = $("#error-liability-" + key.replace(/_/g, "-"));
                        if (errorDiv.length) {
                            errorDiv.text(res.errors[key][0]);
                        }
                    });
                } else if (res && res.message) {
                    $("#liabilityErrorMessage").text(res.message);
                    $("#liabilityErrorModal").removeClass("hidden");
                } else {
                    $("#liabilityErrorMessage").text("Something went wrong.");
                    $("#liabilityErrorModal").removeClass("hidden");
                }
            },
        });
    });
    // end: Add Liability logic


    // validations : for asset and liability add form 
    const assetName = document.getElementById("asset_name");
    const assetType = document.getElementById("asset_type");
    const depreciation = document.getElementById("depreciation");

    assetName.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-asset-name").textContent =
                "Asset name must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-asset-name").textContent = "";
        }
    });

    assetType.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-asset-type").textContent =
                "Asset type must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-asset-type").textContent = "";
        }
    });

    depreciation.addEventListener("input", function() {
        let val = this.value.trim();

        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }

        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (!val.startsWith("0.") && val !== "0") {
            val = val.replace(/^0+/, "");
        }

        this.value = val;
        if (val !== "" && !/^\d+(\.\d+)?$/.test(val)) {
            document.getElementById("error-depreciation").textContent =
                "Depreciation must be a valid number (e.g., 3, 3.5, 45.6).";
        } else {
            document.getElementById("error-depreciation").textContent = "";
        }
    });
    const liabilityName = document.getElementById("liability_name");
    const liabilityType = document.getElementById("liability_type");
    // const liabilityAmount = document.getElementById("liability_amount");

    liabilityName.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-liability-name").textContent =
                "Liability name must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-liability-name").textContent = "";
        }
    });

    liabilityType.addEventListener("input", function() {
        let val = this.value.trim();
        if (!/^[a-zA-Z\s]+$/.test(val)) {
            document.getElementById("error-liability-type").textContent =
                "Liability type must contain only letters and spaces.";
            this.value = "";
        } else {
            document.getElementById("error-liability-type").textContent = "";
        }
    });

    // liabilityAmount.addEventListener("input", function() {
    //     let val = this.value.trim();
    //     if (!/^\d+(\.\d+)?$/.test(val)) {
    //         document.getElementById("error-liability-amount").textContent =
    //             "Liability amount must be a valid number.";
    //         this.value = "";
    //     } else {
    //         this.value = parseFloat(val).toFixed(2);
    //         document.getElementById("error-liability-amount").textContent = "";
    //     }
    // });
    const vendorName = document.getElementById("vendor_name");
    const vendorContact = document.getElementById("vendor_contact_person");
    const vendorPhone = document.getElementById("vendor_phone_number");
    const vendorPAN = document.getElementById("vendor_pan_number");
    const vendorIFSC = document.getElementById("vendor_bank_ifsc");

    // Vendor Name - only letters and spaces
    vendorName.addEventListener("input", function() {
        this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        document.getElementById("error-vendor-name").textContent =
            this.value === '' ? "Vendor name must contain only letters and spaces." : "";
    });


    // end for validation logic for asset and liabilities form.
</script>
@endsection