@extends('master.authMaster')


@section('content')
    <div class="ledgers-page-sec col-span-12 lg:col-span-12">



        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">

            <!-- Sidebar / Filter Box -->
            <div class="w-full bg-white border-r">
                <div class="incm-ledg-sngl-box">
                {{-- <h2 class="text-lg font-semibold p-4 border-b">Expense Heads</h2> --}}
                {{-- @foreach ($expenseHeads as $expenseHead)
                    @foreach ($ledgerExpenseHeads as $ledgerExpenseHead)
                        @if ($expenseHead->expense_head_id == $ledgerExpenseHead->expense_head)
                            <ul id="tabMenu" class="income-head">


                                <li data-tab="tab1" class="p-4 cursor-pointer hover:bg-blue-50 border-l-4 border-transparent">
                                    <a href="{{ route('ledger.expense.head.details', $ledgerExpenseHead->expense_head) }}">
                                        {{ ucfirst($expenseHead->expense_head_name) }}
                                    </a>
                                </li>

                                <li>
                                    ₹ {{ $ledgerExpenseHead->total_amount }}
                                    <span><a href="{{ route('ledger.expense.head.details', $ledgerExpenseHead->expense_head) }}"
                                            class="edit-btn"> View Details </a></span>
                                </li>
                            </ul>
                        @endif
                    @endforeach
                @endforeach --}}
            </div>
            <div class="incm-ledg-sngl-box">
                <h2 class="text-lg font-semibold p-4 border-b">Expense Ledger</h2>

                @if ($expenseHeadsByGroup->isEmpty() && $expenseHeadsWithoutGroup->isEmpty())
                    <p class="p-4 text-gray-500">No Expense heads data found for this financial year.Please<a
                            href="{{ route('expense.create') }}" style="color: blue"> Add Data</a> from Expense
                        Screen.</p>
                @else
                    @foreach ($expenseHeadGroups as $group)
                        @if (isset($expenseHeadsByGroup[$group->expense_head_group_ID]))
                            <h3 class="font-bold mt-4">{{ $group->expense_head_group_Name }}</h3>
                            <ul class="list-disc pl-6 income-head">
                                @foreach ($expenseHeadsByGroup[$group->expense_head_group_ID] as $head)
                                    <li>
                                        {{ $head->expense_head_name }} -
                                        ₹ {{ $ledgerExpenseHeads[$head->expense_head_id]->total_amount ?? 0 }}
                                        <span>
                                            <a href="{{ route('ledger.expense.head.details', $head->expense_head_id) }}"
                                                class="text-blue-600 underline">View Details</a>
                                        </span>
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    @endforeach
                </div>
                <div class="incm-ledg-sngl-box">

                    @if ($expenseHeadsWithoutGroup->isNotEmpty())
                        <h3 class="font-bold mt-6">Ungrouped Expense Heads</h3>
                        <ul class="list-disc pl-6 income-head">
                            @foreach ($expenseHeadsWithoutGroup as $head)
                                <li>
                                    {{ $head->expense_head_name }} -
                                    ₹ {{ $ledgerExpenseHeads[$head->expense_head_id]->total_amount ?? 0 }}
                                    <span>
                                        <a href="{{ route('ledger.expense.head.details', $head->expense_head_id) }}"
                                            class="text-blue-600 underline">View Details</a>
                                    </span>
                                </li>
                            @endforeach
                        </ul>
                    @endif

                @endif
            </div>
            </div>

        </div>
        <div class="mt-6">
            <button onclick="history.back()"
                class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                ← Back
            </button>
        </div>

        <script>
            const tabs = document.querySelectorAll("#tabMenu li");
            const contents = document.querySelectorAll(".tab-content");

            function activateTab(tab) {
                // reset all
                tabs.forEach(el => el.classList.remove("border-blue-600", "bg-blue-50"));
                contents.forEach(c => c.classList.remove("active"));

                // activate clicked tab
                tab.classList.add("border-blue-600", "bg-blue-50");
                document.getElementById(tab.dataset.tab).classList.add("active");
            }

            // --- don't auto-open any tab on load ---
            // if (tabs.length > 0) {
            //   activateTab(tabs[0]);
            // }

            // click handling
            tabs.forEach(tab => {
                tab.addEventListener("click", () => activateTab(tab));
            });
        </script>



    </div>
@endsection
