<?php

namespace Database\Seeders;

use App\Models\IncomeHeadGroup;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class IncomeHeadGroupSeeder extends Seeder
{
    public function run(): void
    {
        $groups = [
            'YEARLY SUBSCRIPTION',
            'YEARLY ANUSTHAN',
            'PRANAMI',
            'MISC.',
            'INTEREST EARNED',
            'SEVA AND RELIEF WORK',
            'CAMP AND KARMASHALA',
            'DIKSHA MISSION',
            'LOAN AND ADVANCE',
            'FUND COLLECTION',
            'BHANDARA ANUSTHAN',
            'BANK DEPOSIT AND WITHDRAWN',
            'HEALTH CLINIC AND SECTION',
            'FURNITURE AND MIXTURE',
            'MANAGEMENT EXP.',
            'ELECTRICAL EQUIPMENT',
            'BANK FIXED DEPOSIT',
        ];

        foreach ($groups as $group) {
            IncomeHeadGroup::create([
                'income_head_group_Name' => $group,
                'status' => 'active',
            ]);
        }
    }
}
