<?php

namespace Database\Seeders;

use App\Models\AccountType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AccountTypeSeeder extends Seeder
{
    public function run(): void
    {
        $types = [
            'Sarada Samaty',
            'Library Section',
            'Health Clinic Section',
            'Blood Donation Camp',
            'New & Old Cloth Distribution',
            'Eye Camp',
            'Relief for natural calamity',
            'Education help for poor students',
        ];

        foreach ($types as $type) {
            AccountType::create([
                'organisation_ID' => 1,
                'account_type_Name' => $type,
            ]);
        }
    }
}
