<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('donors', function (Blueprint $table) {
            $table->increments('donor_id');

            $table->integer('organisation_id');
            $table->integer('account_type_id');

            $table->string('donor_name');
            $table->string('donor_contact_person')->nullable();
            $table->string('donor_phone_number', 20)->nullable();
            $table->string('donor_email')->nullable();
            $table->text('donor_address')->nullable();

            $table->string('donor_pan_number', 20)->nullable();
            $table->string('donor_aadhar_number', 20)->nullable();
            $table->enum('donor_status', ['active', 'inactive'])->default('active');

            $table->decimal('donor_opening_balance', 15, 2)->default(0.00);
            $table->decimal('donor_current_balance', 15, 2)->default(0.00);

            $table->timestamps();
            $table->softDeletes();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('donors');
    }
};
