<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('assets', function (Blueprint $table) {
            $table->increments('asset_id');
            $table->integer('organisation_id');
            $table->integer('account_type_id')->nullable();
            $table->string('asset_name');
            $table->decimal('asset_opening_balance', 15, 2)->default(0);
            $table->date('asset_purchase_date')->nullable();
            $table->integer('financial_year_id')->nullable();
            $table->decimal('asset_purchase_cost', 15, 2)->default(0);
            $table->integer('asset_useful_life')->nullable();
            $table->softDeletes();
            $table->timestamps();

          
        });
    }


    public function down(): void
    {
        //
    }
};
