<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('incomes', function (Blueprint $table) {
            $table->integer('purpose_id')->nullable()->after('income_id');
            $table->integer('payment_type_id')->nullable()->after('purpose_id');
        });

        Schema::table('expenses', function (Blueprint $table) {
            $table->integer('purpose_id')->nullable()->after('expense_id');
            $table->integer('payment_type_id')->nullable()->after('purpose_id');
        });
    }

    public function down(): void
    {
        Schema::table('incomes', function (Blueprint $table) {
            $table->dropColumn(['purpose_id', 'payment_type_id']);
        });

        Schema::table('expenses', function (Blueprint $table) {
            $table->dropColumn(['purpose_id', 'payment_type_id']);
        });
    }
};
