<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('accounting_years', function (Blueprint $table) {
            $table->boolean('is_current')->default(false)->after('accounting_year_financial');
            $table->string('status')->default('active')->after('is_current');
        });
    }


    public function down(): void
    {
        Schema::table('accounting_years', function (Blueprint $table) {
            $table->dropColumn(['is_current', 'status']);
        });
    }
};
