<?php

namespace App\Providers;

use App\Models\Menu;
use App\Models\UserMenuPermission;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AppServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        Gate::before(function ($user, $ability) {
            if ($user->id == 1) {
                return true; // ✅ full access for user 1
            }
        });

        // Define gate for view permission
        Gate::define('view-menu', function ($user, $menuId) {
            $permission = UserMenuPermission::where('user_id', $user->id)
                ->where('menu_id', $menuId)
                ->value('permissions');
            return in_array($permission, [1, 2]);
        });

        // Define gate for modify permission
        Gate::define('modify-menu', function ($user, $menuId) {
            $permission = UserMenuPermission::where('user_id', $user->id)
                ->where('menu_id', $menuId)
                ->value('permissions');
            return $permission == 2;
        });

        if (Schema::hasTable('menus')) {
            $menus = Menu::where('status', 'active')
                ->where('parent_id', 0)
                ->with(['children' => function ($q) {
                    $q->where('status', 'active');
                }])
                ->get();

            View::share('menus', $menus);
        }
        if (Schema::hasTable('user_menu_permissions')) {
            View::share('menuPermissions', UserMenuPermission::get());
        }
    }
}
