<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncomeHead extends Model
{
    use HasFactory;

    protected $table = 'heads';
    protected $primaryKey = 'id';

    protected $fillable = [
        'account_type_id',
        'head_group_id',
        'name',
        'status',
        'organisation_id'
    ];

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_ID', 'account_type_ID');
    }

    public function incomeHeadGroup()
    {
        return $this->belongsTo(IncomeHeadGroup::class, 'head_group_id', 'id');
    }
    public function incomes()
    {
        return $this->hasMany(Income::class, 'head_id', 'id');
    }
}
