<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AccountingYear extends Model
{
    protected $table = 'accounting_years';
    protected $primaryKey = 'accounting_year_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'accounting_year_financial',
        'is_current',
        'status'
    ];

    public static function current()
    {
        return static::where('is_current', 1)->first();
    }
}
