<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccountType extends Model
{
    use HasFactory;

    protected $table = 'account_types';
    protected $primaryKey = 'account_type_ID';

    protected $fillable = [
        'organisation_id',
        'account_type_Name',
        'account_type_Description',
        'status',
    ];

    public function organisation()
    {
        return $this->belongsTo(Organisation::class, 'organisation_id', 'organisation_id');
    }
    public function incomes()
    {
        return $this->hasMany(Income::class, 'account_type_id', 'account_type_id');
    }
   
}
