<?php

namespace App\Http\Controllers;

use App\Traits\CommonTrait;
use Illuminate\Http\Request;
use App\Models\AccountingYear;
use Illuminate\Support\Facades\DB;
use App\Models\AccountBroughtForward;

class DashboardController extends Controller
{

    protected $currentYear;
    protected $tables; // 👈 Declare it as a class property
    protected $journal_transcation_tbl;
    use  CommonTrait;

    public function __construct()
    {

        $this->currentYear = AccountingYear::current();
        $this->tables = $this->getYearPrefixedTables();
    }

    public function index()
    {
        $getTotal_Cash_Bank = $this->cashAndBankSumation();
        $getNetAssets = $this->calculateAssetBroughtForward();
        return view('dashboard', [
            'yearWise_totalBanance' => $getTotal_Cash_Bank,
            'netAssets' => $getNetAssets
        ]);
    }
}
