<?php

namespace App\Http\Controllers;

use App\Models\AccountType;
use Illuminate\Http\Request;

class AccountTypeController extends Controller
{
    public function getByOrg(Request $request)
    {
        try {
            $organisationId = $request->input('organisation_id');

            if (!$organisationId) {
                return response()->json([
                    'success' => false,
                    'message' => 'Organisation ID is required',
                    'data' => []
                ], 400);
            }

            $accountTypes = AccountType::where('status', 'active')
                ->where('organisation_id', $organisationId)
                ->orderBy('account_type_Name', 'asc')
                ->get()
                ->map(function ($type) {
                    return [
                        'account_type_id' => $type->account_type_id,
                        'account_type_Name' => $type->account_type_Name,
                        'organisation_id' => $type->organisation_id
                    ];
                });

            return response()->json([
                'success' => true,
                'data' => $accountTypes
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
                'data' => []
            ], 500);
        }
    }
}
