<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Add New Expense Head</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="{{ route('transaction_config.storeExpenseHead') }}">
            @csrf
            <div class="row">
                <div class="col-md-5">
                    <input type="text" name="name" class="form-control" placeholder="Head Name" required>
                </div>
                <div class="col-md-5">
                    <input type="text" name="description" class="form-control" placeholder="Description" required>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary w-100">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Expense Heads List</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>Head Name</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($expenseHeads as $fee)
                    <tr>
                        <td>{{ $fee->name }}</td>
                        <td>{{ $fee->description }}</td>
                        <!-- <td>₹{{ number_format($fee->amount, 2) }}</td> -->
                        <td>
                            <div class="form-check form-switch">
                                <input
                                    class="form-check-input expense-status"
                                    type="checkbox"
                                    id="status_{{ $fee->id }}"
                                    data-id="{{ $fee->id }}"
                                    data-url="{{ route('transaction_config.updateExpenseHead', $fee->id) }}"
                                    {{ $fee->status ? 'checked' : '' }} {{$fee->id == 1 ? 'disabled' : ''}}
                                >
                            </div>
                        </td>
                        <td>
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-primary edit-expense-head"
                                data-id="{{ $fee->id }}"
                                data-name="{{ $fee->name }}"
                                data-description="{{ $fee->description }}"
                            >
                                Edit
                            </button>
                            @if($fee->id != 1)
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-danger deleteExpenseHeadBtn"
                                data-url="{{ route('transaction_config.deleteExpenseHead', $fee->id) }}"
                            >
                                Delete
                            </button>
                            @endif

                        </td>
                    </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No head found!
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-end mt-3">
            {{ $expenseHeads->appends(['tab' => $tab])->links() }}
        </div>
    </div>
</div>

