@extends('layouts.app')

@section('title', 'Staff')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('staff.index') }}">Staff</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Edit Staff Member</h5>
    </div>

    <div class="card-body">

        {{-- GLOBAL ERRORS --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST"
              action="{{ route('staff.update', $staff->id) }}"
              enctype="multipart/form-data">
            @csrf
            @method('PUT')

            {{-- ================= PERSONAL INFO ================= --}}
            <h6 class="mb-3 text-muted">Personal Information</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Full Name *</label>
                    <input type="text" name="name"
                        class="form-control @error('name') is-invalid @enderror"
                        value="{{ old('name', $staff->name) }}" required>
                    @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Email *</label>
                    <input type="email" name="email"
                        class="form-control @error('email') is-invalid @enderror"
                        value="{{ old('email', $staff->email) }}" required>
                    @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Photo</label>
                    <input type="file" name="photo" id="profile_image"
                        class="form-control @error('photo') is-invalid @enderror"
                        accept="image/*" >
                    <small class="text-muted">Leave blank to keep existing photo</small>
                    @error('photo')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6">
                    <label>Phone *</label>
                    <input type="tel" name="phone" maxlength="10"
                        class="form-control @error('phone') is-invalid @enderror"
                        value="{{ old('phone', $staff->phone) }}" required>
                    @error('phone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6">
                    <div class="mb-2" id="profilePreview">
                        @if($staff->photo)
                            <img
                                src="{{ asset('storage/'.$staff->photo) }}"
                                alt="Profile Photo"
                                class="img-thumbnail"
                                style="max-height:150px;">
                        @endif
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-12">
                    <label>Address *</label>
                    <textarea name="address"
                        class="form-control @error('address') is-invalid @enderror"
                        required>{{ old('address', $staff->address) }}</textarea>
                    @error('address')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <hr>

            {{-- ================= EMPLOYMENT ================= --}}
            <h6 class="mb-3 text-muted">Employment Details</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Category *</label>
                    <select name="category"
                        class="form-select @error('category') is-invalid @enderror" required>
                        <option value="">Select</option>
                        <option value="Teacher" {{ old('category',$staff->category)=='Teacher'?'selected':'' }}>Teacher</option>
                        <option value="Non-Teacher" {{ old('category',$staff->category)=='Non-Teacher'?'selected':'' }}>Non-Teacher</option>
                    </select>
                    @error('category')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Designation *</label>
                    <input type="text" name="designation"
                        class="form-control @error('designation') is-invalid @enderror"
                        value="{{ old('designation', $staff->designation) }}" required>
                    @error('designation')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Qualification *</label>
                    <input type="text" name="qualification"
                        class="form-control @error('qualification') is-invalid @enderror"
                        value="{{ old('qualification', $staff->qualification) }}" required>
                    @error('qualification')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Joining Date *</label>
                    <input type="date" name="join_date" id="join_date"
                        class="form-control @error('join_date') is-invalid @enderror"
                        value="{{ old('join_date', $staff->join_date) }}" required>
                    @error('join_date')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <hr>

            {{-- ================= SALARY ================= --}}
            @php $salary = $staff->salary; @endphp

            <h6 class="mb-3 text-muted">Salary – Earnings</h6>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Basic *</label>
                    <input type="text" name="basic" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('basic') is-invalid @enderror"
                        value="{{ old('basic', $salary->basic ?? 0) }}" required>
                    @error('basic')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>DA</label>
                    <input type="text" name="da" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('da') is-invalid @enderror"
                        value="{{ old('da', $salary->da ?? 0) }}">
                    @error('da')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>TA</label>
                    <input type="text" name="ta" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('ta') is-invalid @enderror"
                        value="{{ old('ta', $salary->ta ?? 0) }}">
                    @error('ta')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>HRA</label>
                    <input type="text" name="hra" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('hra') is-invalid @enderror"
                        value="{{ old('hra', $salary->hra ?? 0) }}">
                    @error('hra')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Medical Allowance</label>
                    <input type="text" name="medical_allowance" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('medical_allowance') is-invalid @enderror"
                        value="{{ old('medical_allowance', $salary->medical_allowance ?? 0) }}">
                    @error('medical_allowance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Washing Allowance</label>
                    <input type="text" name="washing_allowance" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('washing_allowance') is-invalid @enderror"
                        value="{{ old('washing_allowance', $salary->washing_allowance ?? 0) }}">
                    @error('washing_allowance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Conveyance</label>
                    <input type="text" name="conveyance" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('conveyance') is-invalid @enderror"
                        value="{{ old('conveyance', $salary->conveyance ?? 0) }}">
                    @error('conveyance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Special Allowance</label>
                    <input type="text" name="special_allowance" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('special_allowance') is-invalid @enderror"
                        value="{{ old('special_allowance', $salary->special_allowance ?? 0) }}">
                    @error('special_allowance')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <h6 class="mb-3 text-muted mt-4">Salary – Deductions</h6>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>PF</label>
                    <input type="text" name="pf" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('pf') is-invalid @enderror"
                        value="{{ old('pf', $salary->pf ?? 0) }}">
                    @error('pf')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>ESI</label>
                    <input type="text" name="esi" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('esi') is-invalid @enderror"
                        value="{{ old('esi', $salary->esi ?? 0) }}">
                    @error('esi')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Professional Tax</label>
                    <input type="text" name="p_tax" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('p_tax') is-invalid @enderror"
                        value="{{ old('p_tax', $salary->p_tax ?? 0) }}">
                    @error('p_tax')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>TDS</label>
                    <input type="text" name="tds" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('tds') is-invalid @enderror"
                        value="{{ old('tds', $salary->tds ?? 0) }}">
                    @error('tds')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Other Deduction</label>
                    <input type="text" name="others_deduction" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('others_deduction') is-invalid @enderror"
                        value="{{ old('others_deduction', $salary->others_deduction ?? 0) }}">
                    @error('others_deduction')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <h6 class="mb-3 text-muted mt-4">Employer Contribution</h6>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Employer PF</label>
                    <input type="text" name="employer_pf" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('employer_pf') is-invalid @enderror"
                        value="{{ old('employer_pf', $salary->employer_pf ?? 0) }}">
                    @error('employer_pf')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Employer ESI</label>
                    <input type="text" name="employer_esi" inputmode="decimal"
                        placeholder="0.00"
                        step="0.01"
                        oninput="formatCurrency(this)"
                        onpaste="return preventInvalidPaste(event, this)"
                        class="money form-control @error('employer_esi') is-invalid @enderror"
                        value="{{ old('employer_esi', $salary->employer_esi ?? 0) }}">
                    @error('employer_esi')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-4">
                    <label>Financial Year *</label>
                    <select name="financial_year_id"
                        class="form-select @error('financial_year_id') is-invalid @enderror" required>
                        <option value="">Select</option>
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}"
                                {{ old('financial_year_id', $salary->financial_year_id ?? '') == $year->id ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                    @error('financial_year_id')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <hr>

            {{-- ================= BANK ================= --}}
            @php $bank = $staff->bankDetails; @endphp

            <h6 class="mb-3 text-muted">Bank Details</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Bank Name</label>
                    <input type="text" name="bank_name"
                        class="form-control @error('bank_name') is-invalid @enderror"
                        value="{{ old('bank_name', $bank->bank_name ?? '') }}">
                    @error('bank_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Branch Name</label>
                    <input type="text" name="branch_name"
                        class="form-control @error('branch_name') is-invalid @enderror"
                        value="{{ old('branch_name', $bank->branch_name ?? '') }}">
                    @error('branch_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Account Number</label>
                    <input type="text" name="account_no"
                        class="form-control @error('account_no') is-invalid @enderror"
                        value="{{ old('account_no', $bank->acc_no ?? '') }}">
                    @error('account_no')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>

                <div class="col-md-6">
                    <label>Account Holder</label>
                    <input type="text" name="account_holder"
                        class="form-control @error('account_holder') is-invalid @enderror"
                        value="{{ old('account_holder', $bank->acc_holder_name ?? '') }}">
                    @error('account_holder')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>IFSC Code</label>
                    <input type="text" name="ifsc"
                        class="form-control @error('ifsc') is-invalid @enderror"
                        value="{{ old('ifsc', $bank->ifsc_code ?? '') }}">
                    @error('ifsc')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <button class="btn btn-primary btn-sm">Update Staff</button>
                <a href="{{ route('staff.index') }}" class="btn btn-secondary btn-sm">Cancel</a>
            </div>

        </form>
    </div>
</div>

@endsection




@section('script')

<script>
    function formatCurrency(el) {
        let value = el.value;

        // Remove invalid characters
        value = value.replace(/[^0-9.]/g, '');

        // Prevent multiple dots
        const parts = value.split('.');
        if (parts.length > 2) {
            value = parts[0] + '.' + parts[1];
        }

        let [intPart, decPart] = value.split('.');

        // Limit integer part to 8 digits (DECIMAL 10,2)
        if (intPart.length > 8) {
            intPart = intPart.slice(0, 8);
        }

        // Limit decimal to 2 digits
        if (decPart !== undefined) {
            decPart = decPart.slice(0, 2);
        }

        // Add thousand separators
        intPart = intPart.replace(/\B(?=(\d{3})+(?!\d))/g, ',');

        el.value = decPart !== undefined
            ? `${intPart}.${decPart}`
            : intPart;
    }

    function preventInvalidPaste(e, el) {
        e.preventDefault();

        let paste = (e.clipboardData || window.clipboardData).getData('text');
        paste = paste.replace(/[^0-9.]/g, '');

        if (!paste) return false;

        el.value = paste;
        formatCurrency(el);
        return false;
    }
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.money').forEach(el => {
            if (el.value) {
                formatCurrency(el);
            }
        });
    });
</script>

<script>
    $(document).ready(function () {

        let today = new Date();

        // Max = today (disable future)
        let maxDate = today.toISOString().split('T')[0];


        $('#join_date').attr({
            max: maxDate
        });



        document.getElementById('profile_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('profilePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && file.type.startsWith('image/')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = "";
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });

        

    });
</script>
@endsection