<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Proposal PDF</title>
    <style>
        @page {
            size: A4;
            margin: 2cm 1.5cm;

            @top-left {
                content: element(header);
            }

            @bottom-left {
                content: element(footer);
            }
        }

        @page :first {
            margin: 0;
            background: url('{{ public_path('images/my-logo-bg.jpg') }}') no-repeat center center;
            background-size: cover;
        }

        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
        }

        header {
            position: running(header);
            text-align: right;
            font-size: 12px;
            color: #aaa;
        }

        footer {
            position: running(footer);
            font-size: 10px;
            text-align: center;
            color: #999;
            border-top: 1px solid #ddd;
            padding-top: 5px;
        }

        .coverPage {
            height: 27cm;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            text-align: center;
            position: relative;
            page-break-after: always;
        }

        .coverPage:last-of-type {
            page-break-after: avoid;
        }

        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 400px;
            opacity: 0.08;
        }

        .bottom-logo-address {
            position: absolute;
            bottom: 30px;
            left: 30px;
            display: flex;
            align-items: center;
        }

        .bottom-logo-address img {
            height: 80px;
            width: auto;
            margin-right: 15px;
        }

        .address-text {
            font-size: 12px;
            line-height: 1.5;
            margin-left: 18px;
        }

        .coverPage {
            height: 27.9cm;
            width: 21cm;
            position: relative;
            page-break-after: always;
        }

        .coverPage h1 {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 28px;
            color: #030303;
            text-align: center;
            margin: 0;
            padding: 0;
        }

        .chapter {
            page-break-before: always;
            padding: 20px;
        }

        .chapter h1 {
            border-bottom: 2px solid #007BFF;
            padding-bottom: 10px;
            color: #007BFF;
        }

        .content {
            font-size: 14px;
            line-height: 1.6;
        }
    </style>
</head>

<body>

    <?php
    function getImgUri($imagePath)
    {
        $mimeType = mime_content_type($imagePath);
        $base64 = base64_encode(file_get_contents($imagePath));
        return "data:$mimeType;base64,$base64";
    }
    ?>

    <!-- COVER PAGE -->
    <div class="coverPage">
        <h1>{{ $project->project_name }}</h1>
        <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" class="watermark" alt="Watermark">
        <div class="bottom-logo-address">
            <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" alt="Logo">
            <div class="address-text">
                MAX Solutions Pvt. Ltd.<br>
                #123, Business Road,<br>
                Bengaluru, India – 560001
            </div>
        </div>
    </div>

    <!-- CHAPTER 1 -->
    <div class="chapter">
        <h1>Why Maxbridge Solutions ?</h1>
        <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" class="watermark" alt="Watermark">
        <div class="content">
            <div>
                We specialize in Software development, E-commerce applications, Web Designing, Web Development Mobile
                Apps Development, Domain Registrations, Search Engine Optimization, Cyber Security, IoT, AWS, and Social
                Media Marketing.

                We are a growing IT firm based in India, eastern part, with more than 12 years of experience serving our
                clients from different areas of business, and from across the globe.

                We are a team of highly motivated designers and developers, dedicated to providing the best services to
                our customers. Our goal is "Delivering Par Excellence”. By conceptualizing Innovative Strategy", this is
                the backbone of our business, and we strive to deliver these standards to all of our valued customers.

                Our strength is generated from our commitment of delivering consistent standards to our clients and also
                providing Delivery on Time and Cost Efficiency to our customers.

                Hope with our well-versed industry knowledge in this field we can serve you at the extreme level and
                will be able to make your product top-level.
            </div>
            <div class="bottom-logo-address">
                <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" alt="Logo">
                <div class="address-text">
                    MAX Solutions Pvt. Ltd.<br>
                    #123, Business Road,<br>
                    Bengaluru, India – 560001
                </div>
            </div>
        </div>

    </div>

    <!-- CHAPTER 2 -->
    <div class="chapter">
        <h1>Project Description in Brief:</h1>
        <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" class="watermark" alt="Watermark">
        <div class="content">
            @php echo $project->description; @endphp
            <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" class="watermark" alt="Watermark">
        </div>
        <div class="bottom-logo-address">
            <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" alt="Logo">
            <div class="address-text">
                MAX Solutions Pvt. Ltd.<br>
                #123, Business Road,<br>
                Bengaluru, India – 560001
            </div>
        </div>
    </div>

    <!-- CHAPTER 3 -->
    <div class="chapter">
        <h1>Technology Used</h1>
        <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" class="watermark" alt="Watermark">
        <div class="content">
            <?php $technology = json_decode($project->technology); ?>
            <ul>
                @foreach ($technology as $tech)
                    <li>{{ $tech }}</li>
                @endforeach
            </ul>
        </div>
        <div class="content">
            <h1>Timeline</h1>
            <ul>
                <strong><label>Start Date</label></strong>
                <li>{{ $project->start_date }}</li>
            </ul>
            <ul>
                <strong><label>End Date</label></strong>
                <li>{{ $project->end_date }}</li>
            </ul>

        </div>
        <div class="bottom-logo-address">
            <img src="<?php echo getImgUri('./assets/img/max/max-logo.jpg'); ?>" alt="Logo">
            <div class="address-text">
                MAX Solutions Pvt. Ltd.<br>
                #123, Business Road,<br>
                Bengaluru, India – 560001
            </div>
        </div>

    </div>

</body>

</html>
