@extends('master.authMaster')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row mb-6 gy-6">
                <div class="col-xxl">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">Project Billing</h5>
                            <small class="text-body-secondary float-end">Project Billing</small>
                        </div>

                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        <div class="card-body">
                            <form method="POST" action="{{ route('project.submit') }}">
                                @csrf
                                <div class="firstPage">
                                    {{-- Project Name --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Name <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <select name="project_type" id="project_type" class="form-select">
                                                <option value="">-- Select Type --</option>
                                                @foreach ($projects as $project)
                                                    <option value="{{ $project->project_id }}">
                                                        {{ $project->project_name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('project_type')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div id="billingModulesContainer"></div>
                                </div>

                                {{-- Submit Button --}}
                                {{-- <div class="row justify-content-between mt-4">
                                    <div class="col-sm-6 text-end">
                                        <button id="submitButton" type="submit" class="btn btn-primary">Add
                                            Project</button>
                                    </div>
                                </div> --}}
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- / Content -->
    @endsection
    @section('scripts')
        <script>
            $(document).ready(function() {
                $("#project_type").on('change', function(e) {
                    const projectId = $(this).val();
                    if (projectId) {
                        $.ajax({
                            url: `/project/${projectId}/billing-modules`,
                            method: 'GET',
                            success: function(response) {
                                console.log(response);

                                const project = response.project;
                                const modules = response.billingModules;

                                let html = '';

                                // --- Project Info ---
                                html += `
                                    <div class="card border shadow-sm mb-4">
                                        <div class="card-header bg-info text-white">
                                            Project Information
                                            
                                        </div>
                                        <div class="card-body">
                                            <br>
                                            <div class="row mb-2">
                                                <label class="col-sm-3 fw-bold">Project Name:</label>
                                                <div class="col-sm-9">${project.project_name}</div>
                                            </div>
                                            <div class="row mb-2">
                                                <label class="col-sm-3 fw-bold">Client Name:</label>
                                                <div class="col-sm-9">${project.client_name ?? '—'}</div>
                                            </div>
                                            <div class="row mb-2">
                                                <label class="col-sm-3 fw-bold">Start Date:</label>
                                                <div class="col-sm-3">${project.start_date}</div>
                                                <label class="col-sm-3 fw-bold">End Date:</label>
                                                <div class="col-sm-3">${project.end_date}</div>
                                            </div>
                                            <div class="row mb-2">
                                                <label class="col-sm-3 fw-bold">Total Cost:</label>
                                                <div class="col-sm-9">₹${project.total_project_cost}</div>
                                            </div>
                                        </div>
                                    </div>
                                `;

                                // --- Billing Table ---
                                html += `
                                    <div class="card border shadow-sm mb-4">
                                        <div class="card-header bg-primary text-white">
                                            Billing Module Details
                                        </div>
                                        <div class="card-body">
                                            <table class="table table-bordered">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>Module Title</th>
                                                        <th>Status</th>
                                                        <th>Amount (INR)</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                `;

                                modules.forEach(function(res, index) {
                                    let isPending = res.status?.toLowerCase() ===
                                        'pending'; // check for undefined safety
                                    html += `
                                        <tr>
                                        
                                            <td>${res.title}</td>
                                            <td>
                                                <span class="badge ${isPending ? 'bg-warning text-dark' : 'bg-success'}">
                                                    ${res.status}
                                                </span>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control text-end" name="infra_cost[]" value="${res.amount}" ${isPending ? 'disabled' : 'readonly'}>
                                            </td>
                                            <td>
                                ${isPending ? `
                                                            <button 
                                                                type="button" 
                                                                class="btn btn-primary receive-btn" 
                                                                data-module-id="${res.id}" 
                                                                data-project-id="${project.project_id}">
                                                                Receive
                                                            </button>
                                                        ` : '-'}
                            </td>
                                        </tr>
                                    `;
                                });

                                html += `
                                                </tbody>
                                            </table>
                                            <p class="text-muted">✔ Check the pending modules to bill them now.</p>
                                        </div>
                                    </div>
                                `;

                                $('#billingModulesContainer').html(html);

                                // Enable/disable amount input based on checkbox
                                $('.module-checkbox').on('change', function() {
                                    let rowIndex = $(this).data('index');
                                    const inputField = $('input[name="infra_cost[]"]').eq(
                                        rowIndex);
                                    inputField.prop('disabled', !$(this).is(':checked'));
                                });
                            },
                            error: function() {
                                alert('Failed to load billing modules. Please try again.');
                            }
                        });
                    } else {
                        $('#billingModulesContainer').empty();
                    }
                });
                $(document).on('click', '.receive-btn', function() {
                    const moduleId = $(this).data('module-id');
                    const projectId = $(this).data('project-id');
                    const button = $(this);

                    $.ajax({
                        url: `/statuschange/${projectId}/${moduleId}`,
                        method: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            button.replaceWith('<span class="badge bg-success">Received</span>');
                        },
                        error: function() {
                            alert('Failed to update module status.');
                        }
                    });
                });

            });
        </script>
    @endsection
