<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('project_resource_mappings', function (Blueprint $table) {
            // float(total, places)
            $table->float('cost_per_hour', 15, 2)->change();
            $table->float('duration', 15, 2)->change();
            $table->float('total_cost', 15, 2)->change();
        });
    }

    public function down(): void
    {
        Schema::table('project_resource_mappings', function (Blueprint $table) {
            $table->integer('cost_per_hour')->change();
            $table->integer('duration')->change();
            $table->integer('total_cost')->change();
        });
    }
};
