<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->float('operational_cost');
            $table->dropColumn(['travel_cost', 'comission', 'accomodation_cost', 'infra_cost','billing_type']);
            $table->json('other_costs')->nullable()->after('operational_cost');
        });
    }

    public function down()
    {
        Schema::table('projects', function (Blueprint $table) {
            // $table->renameColumn('operational_cost', 'infra_cost');
            $table->double('infra_cost', 8, 2)->nullable();
            $table->double('travel_cost', 8, 2)->nullable();
            $table->double('comission', 8, 2)->nullable();
            $table->double('accomodation_cost', 8, 2)->nullable();
            $table->dropColumn('other_costs');
        });
    }
};
