/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function(Drupal){'use strict';Drupal.behaviors.custom_barrio_subtheme={attach:function(context,settings){}};})(Drupal);;
Drupal.debounce=function(func,wait,immediate){let timeout;let result;return function(...args){const context=this;const later=function(){timeout=null;if(!immediate)result=func.apply(context,args);};const callNow=immediate&&!timeout;clearTimeout(timeout);timeout=setTimeout(later,wait);if(callNow)result=func.apply(context,args);return result;};};;
(function(Drupal,debounce){let liveElement;const announcements=[];Drupal.behaviors.drupalAnnounce={attach(context){if(!liveElement){liveElement=document.createElement('div');liveElement.id='drupal-live-announce';liveElement.className='visually-hidden';liveElement.setAttribute('aria-live','polite');liveElement.setAttribute('aria-busy','false');document.body.appendChild(liveElement);}}};function announce(){const text=[];let priority='polite';let announcement;const il=announcements.length;for(let i=0;i<il;i++){announcement=announcements.pop();text.unshift(announcement.text);if(announcement.priority==='assertive')priority='assertive';}if(text.length){liveElement.innerHTML='';liveElement.setAttribute('aria-busy','true');liveElement.setAttribute('aria-live',priority);liveElement.innerHTML=text.join('\n');liveElement.setAttribute('aria-busy','false');}}Drupal.announce=function(text,priority){announcements.push({text,priority});return debounce(announce,200)();};})(Drupal,Drupal.debounce);;
((Drupal)=>{Drupal.Message=class{constructor(messageWrapper=null){if(!messageWrapper)this.messageWrapper=Drupal.Message.defaultWrapper();else this.messageWrapper=messageWrapper;}static defaultWrapper(){let wrapper=document.querySelector('[data-drupal-messages]')||document.querySelector('[data-drupal-messages-fallback]');if(!wrapper){wrapper=document.createElement('div');document.body.appendChild(wrapper);}if(wrapper.hasAttribute('data-drupal-messages-fallback')){wrapper.removeAttribute('data-drupal-messages-fallback');wrapper.classList.remove('hidden');}wrapper.setAttribute('data-drupal-messages','');return wrapper.innerHTML===''?Drupal.Message.messageInternalWrapper(wrapper):wrapper.firstElementChild;}static getMessageTypeLabels(){return {status:Drupal.t('Status message'),error:Drupal.t('Error message'),warning:Drupal.t('Warning message')};}add(message,options={}){if(!options.hasOwnProperty('type'))options.type='status';if(typeof message!=='string')throw new Error('Message must be a string.');Drupal.Message.announce(message,options);options.id=options.id?String(options.id):`${options.type}-${Math.random().toFixed(15).replace('0.','')}`;if(!Drupal.Message.getMessageTypeLabels().hasOwnProperty(options.type)){const {type}=options;throw new Error(`The message type, ${type}, is not present in Drupal.Message.getMessageTypeLabels().`);}this.messageWrapper.appendChild(Drupal.theme('message',{text:message},options));return options.id;}select(id){return this.messageWrapper.querySelector(`[data-drupal-message-id^="${id}"]`);}remove(id){return this.messageWrapper.removeChild(this.select(id));}clear(){Array.prototype.forEach.call(this.messageWrapper.querySelectorAll('[data-drupal-message-id]'),(message)=>{this.messageWrapper.removeChild(message);});}static announce(message,options){if(!options.priority&&(options.type==='warning'||options.type==='error'))options.priority='assertive';if(options.announce!=='')Drupal.announce(options.announce||message,options.priority);}static messageInternalWrapper(messageWrapper){const innerWrapper=document.createElement('div');innerWrapper.setAttribute('class','messages__wrapper');messageWrapper.insertAdjacentElement('afterbegin',innerWrapper);return innerWrapper;}};Drupal.theme.message=({text},{type,id})=>{const messagesTypes=Drupal.Message.getMessageTypeLabels();const messageWrapper=document.createElement('div');messageWrapper.setAttribute('class',`messages messages--${type}`);messageWrapper.setAttribute('role',type==='error'||type==='warning'?'alert':'status');messageWrapper.setAttribute('data-drupal-message-id',id);messageWrapper.setAttribute('data-drupal-message-type',type);messageWrapper.setAttribute('aria-label',messagesTypes[type]);messageWrapper.innerHTML=`${text}`;return messageWrapper;};})(Drupal);;
((Drupal)=>{Drupal.theme.message=({text},{type,id})=>{const messagesTypes=Drupal.Message.getMessageTypeLabels();const messagesBootstrapTypes={status:'success',warning:'warning',error:'danger',info:'info'};const messageWrapper=document.createElement('div');messageWrapper.setAttribute('class',`messages messages--${type}`);messageWrapper.setAttribute('role',type==='error'||type==='warning'?'alert':'status');messageWrapper.setAttribute('data-drupal-message-id',id);messageWrapper.setAttribute('data-drupal-message-type',type);messageWrapper.innerHTML=`
    <div class="messages__content container alert alert-${messagesBootstrapTypes[type]} alert-dismissible fade show" role="alert">
      <h2 class="visually-hidden">
        ${messagesTypes[type]}
      </h2>
      <span class="messages__item">
        ${text}
      </span>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </div>
  `;return messageWrapper;};})(Drupal);;
(function($,Drupal,drupalSettings,once){Drupal.behaviors.customKBAValidation={attach:function(context,settings){$(once('custom-kba-validation','.custom-kba-validation',context)).on('input blur',function(){var param=$(this).attr('id');validateInput.call(this,param);});}};Drupal.behaviors.customKBAUniqueAnswer={attach:function(context,settings){$(once('custom-kba-unique-answer','.custom-kba-validation',context)).on('blur',function(){var textfield1=$('#kba-answer-1').val();var textfield2=$('#kba-answer-2').val();var textfield3=$('#kba-answer-3').val();var kba_answer_length=drupalSettings.miniorange_2fa.kba_answer_length;var inputValue=$(this).val().trim();var pattern=/^[\w\s]+$/;var isValid=pattern.test(inputValue);var message='Answers must be unique.';if(isValid&&inputValue.length>=kba_answer_length)if(textfield1===textfield2&&textfield1===textfield3&&textfield2===textfield3)$('#kba-answer-2')[0].setCustomValidity(Drupal.t(message));else if(textfield1===textfield2)$('#kba-answer-2')[0].setCustomValidity(Drupal.t(message));else if(textfield2===textfield3)$('#kba-answer-3')[0].setCustomValidity(Drupal.t(message));else if(textfield1===textfield3)$('#kba-answer-3')[0].setCustomValidity(Drupal.t(message));else{$('#kba-answer-1')[0].setCustomValidity('');$('#kba-answer-2')[0].setCustomValidity('');$('#kba-answer-3')[0].setCustomValidity('');}});}};function validateInput(textfield){var kba_answer_length=drupalSettings.miniorange_2fa.kba_answer_length;var answer_textfield=$('#'+textfield)[0];var inputValue=$('#'+textfield).val().trim();var pattern=/^[\w\s]+$/;if(inputValue.length>=1)if(inputValue.length<kba_answer_length)if(!pattern.test(inputValue))answer_textfield.setCustomValidity(Drupal.t('Only alphanumeric characters are allowed.'));else answer_textfield.setCustomValidity(Drupal.t('Answers must contain at least @length characters.',{'@length':kba_answer_length}));else if(!pattern.test(inputValue))answer_textfield.setCustomValidity(Drupal.t('Only alphanumeric characters are allowed.'));else answer_textfield.setCustomValidity('');}})(jQuery,Drupal,drupalSettings,once);;
