<?php

namespace Drupal\outlook_mail;

use Drupal\Core\Mail\MailManagerInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class OutlookMailService {

  protected $mailManager;
  protected $languageManager;

  public function __construct(MailManagerInterface $mail_manager, LanguageManagerInterface $language_manager) {
    $this->mailManager = $mail_manager;
    $this->languageManager = $language_manager;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('plugin.manager.mail'),
      $container->get('language_manager')
    );
  }

public function sendOutlookEmail($to, $subject, $body) {
  $from = 'noreply-xceed@drreddys.com';

  $params['subject'] = $subject;
  $params['body'] = \Drupal\Core\Render\Markup::create($body);
  $params['headers'] = [
    'Content-Type' => 'text/html; charset=UTF-8',
    'MIME-Version' => '1.0',
    'From' => $from,
  ];

  $langcode = $this->languageManager->getDefaultLanguage()->getId();
  $send = TRUE;

  $result = $this->mailManager->mail(
    'outlook_mail',  // must match your module name
    'default',       // must match hook_mail key
    $to,
    $langcode,
    $params,
    $from,
    $send
  );

  return !empty($result['result']);
}

}
