<?php

namespace Drupal\outlook_mail\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class mailController extends ControllerBase
{

  /**
   * Send test email using Outlook SMTP.
   */



  public function productSendMail(Request $request)
  {
    $data = json_decode($request->getContent(), true);

    // Extract values with defaults
    $recipient   = $data['recipient'] ?? '';
    $subject     = $data['subject'] ?? '';
    $username    = $data['username'] ?? 'Guest';
    $source_page = $data['source_page'] ?? 'other';
    $source_topic_name = $data['source_topic_name'] ?? 'other';
    $source_link = $data['source_link'] ?? 'other';
    $MobilePhone = $data['MobilePhone'] ?? '';
    $company_name = $data['company_name'] ?? '';
    $product_name = $data['product_name'] ?? '';
    $country_name = $data['country_name'] ?? '';
    $message     = $data['message'] ?? '';
    // $job_title   = $data['job_title'] ?? '';


    $pcp_grade  = $data['pcp_grade'] ?? '';
    $dosage_form = $data['dosage_form'] ?? '';
    $target_market = $data['target_market'] ?? '';
    $reg_requirements = $data['reg_requirements'] ?? '';
    $purpose = $data['purpose'] ?? '';
    $end_cust_info = $data['end_cust_info'] ?? '';
    $dev_quantity = $data['dev_quantity'] ?? '';
    $annual_commercial_demand = $data['annual_commercial_demand'] ?? '';

    // Helper: load template + replace placeholders
    $renderTemplate = function (string $file, array $vars): string {
      $body = file_get_contents(\Drupal::root() . '/modules/custom/email_temp/' . $file);
      foreach ($vars as $key => $value) {
        $body = preg_replace('/{{\s*' . preg_quote($key, '/') . '\s*}}/i', $value, $body);
      }
      return $body;
    };

    // ------------------------
    // 1. User email
    // ------------------------
    $userBody = $renderTemplate('index.html', [
      'username'          => $username,
      'sourcepage'        => $source_page,
      'source_topic_name' => $source_topic_name,
      'source_link'       => $source_link,
    ]);

    $userResult = \Drupal::service('outlook_mail.service')
      ->sendOutlookEmail($recipient, $subject, $userBody);

    // ------------------------
    // 2. Admin email
    // ------------------------
    $adminBody = $renderTemplate('product-data.html', [
      'recipient'                => !empty($recipient) ? $recipient : '-',
      'username'                 => !empty($username) ? $username : '-',
      'source_page'              => !empty($source_page) ? $source_page : '-',
      'source_topic_name'        => !empty($source_topic_name) ? $source_topic_name : '-',
      'source_link'              => !empty($source_link) ? $source_link : '-',
      'mobilePhone'              => !empty($MobilePhone) ? $MobilePhone : '-',
      'company_name'             => !empty($company_name) ? $company_name : '-',
      'product_name'             => !empty($product_name) ? $product_name : '-',
      'country_name'             => !empty($country_name) ? $country_name : '-',
      'message'                  => !empty($message) ? $message : '-',
      'pcp_grade'                => !empty($pcp_grade) ? $pcp_grade : '-',
      'dosage_form'              => !empty($dosage_form) ? $dosage_form : '-',
      'target_market'            => !empty($target_market) ? $target_market : '-',
      'reg_requirements'         => !empty($reg_requirements) ? $reg_requirements : '-',
      'purpose'                  => !empty($purpose) ? $purpose : '-',
      'end_cust_info'            => !empty($end_cust_info) ? $end_cust_info : '-',
      'dev_quantity'             => !empty($dev_quantity) ? $dev_quantity : '-',
      'annual_commercial_demand' => !empty($annual_commercial_demand) ? $annual_commercial_demand : '-'
    ]);

    $adminResult = \Drupal::service('outlook_mail.service')
      ->sendOutlookEmail('sangita@yopmail.com', "New user signup: {$username}", $adminBody);

    // ------------------------
    // Final response
    // ------------------------
    return new JsonResponse([
      'status'  => ($userResult && $adminResult) ? 'success' : 'error',
      'message' => ($userResult && $adminResult)
        ? 'Emails sent successfully to user and admin.'
        : 'Failed to send one or more emails.',
    ], ($userResult && $adminResult) ? 200 : 500);
  }
  public function sendMail(Request $request)
  {
    $data = json_decode($request->getContent(), true);

    // Extract values with defaults
    $recipient   = $data['recipient'] ?? '';
    $subject     = $data['subject'] ?? '';
    $username    = $data['username'] ?? 'Guest';
    $source_page = $data['source_page'] ?? 'other';
    $source_topic_name = $data['source_topic_name'] ?? 'other';
    $source_link = $data['source_link'] ?? 'other';
    $MobilePhone = $data['MobilePhone'] ?? '';
    $company_name = $data['company_name'] ?? '';
    $product_name = $data['product_name'] ?? '';
    $country_name = $data['country_name'] ?? '';
    $message     = $data['message'] ?? '';
    $job_title   = $data['job_title'] ?? '';

    // Helper: load template + replace placeholders
    $renderTemplate = function (string $file, array $vars): string {
      $body = file_get_contents(\Drupal::root() . '/modules/custom/email_temp/' . $file);
      foreach ($vars as $key => $value) {
        $body = preg_replace('/{{\s*' . preg_quote($key, '/') . '\s*}}/i', $value, $body);
      }
      return $body;
    };

    // ------------------------
    // 1. User email
    // ------------------------
    $userBody = $renderTemplate('index.html', [
      'username'          => $username,
      'sourcepage'        => $source_page,
      'source_topic_name' => $source_topic_name,
      'source_link'       => $source_link,
    ]);

    $userResult = \Drupal::service('outlook_mail.service')
      ->sendOutlookEmail($recipient, $subject, $userBody);

    // ------------------------
    // 2. Admin email
    // ------------------------
    $adminBody = $renderTemplate('form-data.html', [
      'recipient'          => !empty($recipient) ? $recipient : '-',
      'username'          => !empty($username) ? $username : '-',
      'source_page'       => !empty($source_page) ? $source_page : '-',
      'source_topic_name' => !empty($source_topic_name) ? $source_topic_name : '-',
      'source_link'       => !empty($source_link) ? $source_link : '-',
      'mobilePhone'       => !empty($MobilePhone) ? $MobilePhone : '-',
      'company_name'      => !empty($company_name) ? $company_name : '-',
      'product_name'      => !empty($product_name) ? $product_name : '-',
      'country_name'      => !empty($country_name) ? $country_name : '-',
      'message'           => !empty($message) ? $message : '-',
      'job_title_block'   => !empty($job_title) ? '<tr>
            <td style="border-bottom: 1px solid #dddddd; padding: 5px;">Job Title</td>
            <td style="border-bottom: 1px solid #dddddd; padding: 5px;">'.$job_title.'</td>
          </tr>' : ''
    ]);

    $adminResult = \Drupal::service('outlook_mail.service')
      ->sendOutlookEmail('sangita@yopmail.com', "New user signup: {$username}", $adminBody);

    // ------------------------
    // Final response
    // ------------------------
    return new JsonResponse([
      'status'  => ($userResult && $adminResult) ? 'success' : 'error',
      'message' => ($userResult && $adminResult)
        ? 'Emails sent successfully to user and admin.'
        : 'Failed to send one or more emails.',
    ], ($userResult && $adminResult) ? 200 : 500);
  }
}
