<?php

namespace Drupal\Tests\api_module\Unit;

use Drupal;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\HttpFoundation\Request;
use Drupal\api_module\Controller\AllDetailsPage\ApiManufactureController;
use Drupal\Core\Database\Connection;
use Drupal\Core\Database\Query\SelectInterface;
use Drupal\Core\Database\StatementInterface;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Entity\EntityTypeRepositoryInterface;
use Drupal\Core\File\FileUrlGeneratorInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\Core\Language\LanguageInterface;
use Drupal\file\FileInterface;

/**
 * Unit tests for ProductController.
 *
 * @group api_module
 */
class ApiManufactureControllerTest extends UnitTestCase
{

    /**
     * {@inheritdoc}
     */
    protected function setUp(): void
    {
        parent::setUp();

        $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
        \Drupal::setContainer($container);
    }
    /**
     * Test case: Missing product_link parameter.
     */
    public function testMissingProductLink()
    {
        $controller = new ApiManufactureController();
        $request = new Request([], [], [], [], [], [], json_encode([]));

        $response = $controller->getApiManufactureBannerDetails($request);
        $data = json_decode($response->getContent(), TRUE);
        

        $this->assertEquals(400, $response->getStatusCode());
        $this->assertFalse($data['status']);
        $this->assertEquals('Language parameter is missing', $data['message']);
    }

}
