<?php
  namespace Drupal\api_module\Controller\includes;
  use Drupal\Core\Controller\ControllerBase;
  use Symfony\Component\HttpFoundation\JsonResponse;
  use Symfony\Component\HttpFoundation\Request;
  use Exception;
  use Drupal\taxonomy\Entity\Term;

class HeaderController extends ControllerBase
{
/**
 * Returns the header menu data based on the requested language.
 *
 * @param \Symfony\Component\HttpFoundation\Request $request
 *   The request object containing the language parameter.
 *
 * @return \Symfony\Component\HttpFoundation\JsonResponse
 *   A JSON response containing the header menu data.
 */


  public function getHeaderInfo(Request $request) {
    try {
      $content = $request->getContent();
      $input = json_decode($content, TRUE);
      $langcode = $input['lan'] ?? '';

      if (empty($langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      // $storage = \Drupal::entityTypeManager()->getStorage('taxonomy_term');
      // $terms = $storage->loadTree('header', 0, NULL, TRUE);

      $terms = \Drupal::service('entity_type.manager')->getStorage('taxonomy_term')->loadTree('header', 0, NULL, TRUE);

      // Organize terms by parent
      $tree = [];
      foreach ($terms as $term) {
        if (!$term->hasTranslation($langcode)) {
          continue;
        }

        $translated = $term->getTranslation($langcode);
        $item = [
          'tid' => $translated->id(),
          'name' => $translated->label(),
          'menu_link' => $translated->hasField('field_menu_link') && !$translated->get('field_menu_link')->isEmpty()
            ? $translated->get('field_menu_link')->value
            : '',
          'children' => [],
        ];

        $parent_id = $term->parent->target_id ?? 0;
        $tree[$parent_id][] = $item;
      }

      // Recursive function to build nested tree
      $buildTree = function ($parent_id) use (&$tree, &$buildTree) {
        if (!isset($tree[$parent_id])) return [];
        foreach ($tree[$parent_id] as &$item) {
          $item['children'] = $buildTree($item['tid']);
        }
        return $tree[$parent_id];
      };

      $menu_data = $buildTree(0);

      return new JsonResponse([
        'status' => true,
        'message' => 'Header megamenu fetched successfully',
        'langcode' => $langcode,
        'data' => $menu_data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }
  public function getmodifyHeaderInfo(Request $request){
  try {
      $content = $request->getContent();
      $input = json_decode($content, TRUE);
      $langcode = $input['lan'] ?? '';
 
      if (empty($langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }
 
      $terms = \Drupal::service('entity_type.manager')
        ->getStorage('taxonomy_term')
        ->loadTree('new_header', 0, NULL, TRUE); // Change to your vocabulary machine name
 
      $tree = [];
 
    foreach ($terms as $term) {
      // Handle translation fallback
      if ($term->hasTranslation($langcode)) {
        $translated = $term->getTranslation($langcode);
      } elseif ($langcode !== 'en' && $term->hasTranslation('en')) {
        $translated = $term->getTranslation('en');
      } else {
        $translated = $term;
      }
 
      $item = [
        'tid' => $translated->id(),
        'name' => $translated->label(),
        'field_header_description' => $translated->hasField('field_header_description') && !$translated->get('field_header_description')->isEmpty()
          ? $translated->get('field_header_description')->value
          : '',
        'field_heading' => $translated->hasField('field_heading') && !$translated->get('field_heading')->isEmpty()
          ? $translated->get('field_heading')->value
          : '',
        'field_link' => $translated->hasField('field_link') && !$translated->get('field_link')->isEmpty()
          ? $translated->get('field_link')->value
          : '',
        'field_header_feature_image' => $translated->hasField('field_header_feature_image') && !$translated->get('field_header_feature_image')->isEmpty()
      ? \Drupal::service('file_url_generator')->generateAbsoluteString(
          $translated->get('field_header_feature_image')->entity->getFileUri()
        )
      : '',
        'children' => [],
      ];
 
      $parent_id = $term->parent->target_id ?? 0;
      $tree[$parent_id][] = $item;
          }
 
          // Recursive function
          $buildTree = function ($parent_id) use (&$tree, &$buildTree) {
            if (!isset($tree[$parent_id])) return [];
            foreach ($tree[$parent_id] as &$item) {
              $item['children'] = $buildTree($item['tid']);
            }
            return $tree[$parent_id];
          };
 
          $menu_data = $buildTree(0);
 
          return new JsonResponse([
            'status' => true,
            'message' => 'Header megamenu fetched successfully',
            'langcode' => $langcode,
            'data' => $menu_data,
          ]);
 
        } catch (\Exception $e) {
          return new JsonResponse([
            'status' => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
          ], 500);
        }
 
    }

}
?>
