<?php

namespace Drupal\api_module\Controller\includes;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Exception;

use Drupal\Core\Language\LanguageInterface;

class FooterController extends ControllerBase
{

    /**
     * Returns a simple response for the footer.
     */


    /*  public function getFooterLinks(Request $request){
    try {
        // Decode JSON request content
        $content = $request->getContent();
        $data = json_decode($content, TRUE);

        // Validate language parameter
        if (empty($data['lan'])) {
            return new JsonResponse([
                'status' => false,
                'message' => 'Language parameter is missing',
            ], 400);
        }

        $requested_langcode = $data['lan'];
        $database = \Drupal::database();

        // Closure to fetch footer links based on language code
        $fetchTerms = function ($langcode) use ($database) {
            $query = $database->select('taxonomy_term_field_data', 'td');
            $query->fields('td', ['tid', 'name', 'langcode']);

            // Join with menu link
            $query->leftJoin('taxonomy_term__field_menu_link', 'link', 'link.entity_id = td.tid');
            $query->addField('link', 'field_menu_link_value', 'menu_link');

            // Join with content type
            $query->leftJoin('taxonomy_term__field_content_type', 'type', 'type.entity_id = td.tid');
            $query->addField('type', 'field_content_type_value', 'content_type');

            // Filter only published taxonomy terms
            $query->condition('td.vid', 'footer_quick_links');
            $query->condition('td.status', 1);
            $query->condition('td.langcode', $langcode);

            $query->orderBy('td.name', 'ASC');

            return $query->execute()->fetchAll();
        };

        // Fetch footer terms in the requested language or fallback to English
        $results_lang = $fetchTerms($requested_langcode);
        if (empty($results_lang) && $requested_langcode !== 'en') {
            $requested_langcode = 'en';
            $results_lang = $fetchTerms('en');
        }

        // Fetch footer content from a known node
        $footer_content = '';
        $footer_content_query = $database->select('node__field_description', 'desc')
            ->fields('desc', ['field_description_value'])
            ->range(0, 1);
        $footer_node_join = $footer_content_query->leftJoin('node_field_data', 'nfd', 'nfd.nid = desc.entity_id');
        $footer_content_query->condition('nfd.status', 1);
        $footer_content_query->condition('nfd.langcode', $requested_langcode);

        $footer_result = $footer_content_query->execute()->fetchField();
        if (!empty($footer_result)) {
            $footer_content = $footer_result;
        }

        // Language name mapping
        $lang_names = \Drupal::languageManager()->getStandardLanguageList();

        $response_data = [];
        foreach ($results_lang as $term) {
            $langcode = $term->langcode;
            $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

            $response_data[] = [
                'tid'           => (int) $term->tid,
                'name'          => (string) $term->name,
                'menu_link'     => (string) ($term->menu_link ?? ''),
                'content_type'  => (string) ($term->content_type ?? ''),
                'langcode'      => $langcode,
                'language_name' => $language_name,
            ];
        }

        return new JsonResponse([
            'status'         => true,
            'message'        => 'Footer links fetched successfully.',
            'data'           => $response_data,
            'footer_content' => $footer_content,
        ]);
    } catch (\Exception $e) {
        \Drupal::logger('custom_module')->error($e->getMessage());

        return new JsonResponse([
            'status'  => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
        ], 500);
    }
  } */


    // public function getFooterLinks(Request $request)
    // {
    //     try {
    //         $content = $request->getContent();
    //         $data = json_decode($content, TRUE);

    //         if (empty($data['lan'])) {
    //             return new JsonResponse([
    //                 'status' => false,
    //                 'message' => 'Language parameter is missing',
    //             ], 400);
    //         }

    //         $requested_langcode = $data['lan'];
    //         $database = \Drupal::database();

    //         // Fetch footer links
    //         $fetchTerms = function ($langcode) use ($database) {
    //             $query = $database->select('taxonomy_term_field_data', 'td');
    //             $query->fields('td', ['tid', 'name', 'langcode']);

    //             $query->leftJoin('taxonomy_term__field_menu_link', 'link', 'link.entity_id = td.tid');
    //             $query->addField('link', 'field_menu_link_value', 'menu_link');

    //             $query->leftJoin('taxonomy_term__field_content_type', 'type', 'type.entity_id = td.tid');
    //             $query->addField('type', 'field_content_type_value', 'content_type');

    //             $query->condition('td.vid', 'footer_quick_links');
    //             $query->condition('td.status', 1);
    //             $query->condition('td.langcode', $langcode);

    //             $query->orderBy('td.name', 'ASC');

    //             return $query->execute()->fetchAll();
    //         };

    //         // Fetch footer content (page_type = 33)
    //         $fetchFooterContent = function ($langcode) use ($database) {
    //             $query = $database->select('node__field_description', 'desc');
    //             $query->fields('desc', ['field_description_value']);

    //             $query->leftJoin('node_field_data', 'nfd', 'nfd.nid = desc.entity_id');
    //             $query->leftJoin('node__field_page_type', 'nfptyp', 'nfptyp.entity_id = nfd.nid');

    //             $query->condition('nfd.status', 1);
    //             $query->condition('nfd.langcode', $langcode);
    //             $query->condition('nfptyp.field_page_type_target_id', 157);

    //             $query->orderBy('nfd.nid', 'ASC');
    //             $query->range(0, 1);
    //             return $query->execute()->fetchField();
    //         };

    //         // Try to fetch in requested language
    //         $results_lang = $fetchTerms($requested_langcode);
    //         $footer_content = $fetchFooterContent($requested_langcode);

    //         // Fallback to English
    //         if ((empty($results_lang) || empty($footer_content)) && $requested_langcode !== 'en') {
    //             if (empty($results_lang)) {
    //                 $results_lang = $fetchTerms('en');
    //             }
    //             if (empty($footer_content)) {
    //                 $footer_content = $fetchFooterContent('en');
    //             }
    //         }

    //         $lang_names = \Drupal::languageManager()->getStandardLanguageList();
    //         $response_data = [];

    //         foreach ($results_lang as $term) {
    //             $langcode = $term->langcode;
    //             $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

    //             $response_data[] = [
    //                 'tid'           => (int) $term->tid,
    //                 'name'          => (string) $term->name,
    //                 'menu_link'     => (string) ($term->menu_link ?? ''),
    //                 'content_type'  => (string) ($term->content_type ?? ''),
    //                 'langcode'      => $langcode,
    //                 'language_name' => $language_name,
    //             ];
    //         }

    //         return new JsonResponse([
    //             'status'         => true,
    //             'message'        => 'Footer links fetched successfully.',
    //             'data'           => $response_data,
    //             'footer_content' => (string) $footer_content,
    //         ]);
    //     } catch (\Exception $e) {
    //         \Drupal::logger('custom_module')->error($e->getMessage());

    //         return new JsonResponse([
    //             'status'  => false,
    //             'message' => 'An error occurred: ' . $e->getMessage(),
    //         ], 500);
    //     }
    // }
    public function getFooterLinks(Request $request)
    {
        try {
            $content = $request->getContent();
            $data = json_decode($content, TRUE);

            if (empty($data['lan'])) {
                return new JsonResponse([
                    'status' => false,
                    'message' => 'Language parameter is missing',
                ], 400);
            }

            $requested_langcode = $data['lan'];

            // Load taxonomy terms from vocabulary
            $terms = \Drupal::entityTypeManager()
                ->getStorage('taxonomy_term')
                ->loadTree('footer_quick_links', 0, NULL, TRUE);

            $lang_names = \Drupal::languageManager()->getStandardLanguageList();
            $response_data = [];

            foreach ($terms as $term) {
                // Get translated version of the term (if exists)
                if ($term->hasTranslation($requested_langcode)) {
                    $term = $term->getTranslation($requested_langcode);
                } elseif ($requested_langcode !== 'en' && $term->hasTranslation('en')) {
                    // fallback to English
                    $term = $term->getTranslation('en');
                }

                $langcode = $term->language()->getId();
                $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

                $response_data[] = [
                    'tid'           => (int) $term->id(),
                    'name'          => (string) $term->getName(),
                    'menu_link'     => (string) ($term->get('field_menu_link')->value ?? ''),
                    'content_type'  => (string) ($term->get('field_content_type')->value ?? ''),
                    'langcode'      => $langcode,
                    'language_name' => $language_name,
                ];
            }


            $nids = \Drupal::entityQuery('node')
                ->condition('status', 1)
                ->condition('field_page_type.target_id', 157)
                ->condition('langcode', $requested_langcode)
                ->range(0, 1)
                ->accessCheck(FALSE)
                ->execute();

            if (empty($nids) && $requested_langcode !== 'en') {
                // fallback to English
                $nids = \Drupal::entityQuery('node')
                    ->condition('status', 1)
                    ->condition('field_page_type.target_id', 157)
                    ->condition('langcode', 'en')
                    ->range(0, 1)
                    ->accessCheck(FALSE)
                    ->execute();
            }

            $footer_content = '';
            if (!empty($nids)) {
                $node = \Drupal\node\Entity\Node::load(reset($nids));
                if ($node->hasField('field_description')) {
                    $footer_content = $node->get('field_description')->value ?? '';
                }
            }

            return new JsonResponse([
                'status'         => true,
                'message'        => 'Footer links fetched successfully.',
                'data'           => $response_data,
                'footer_content' => (string) $footer_content,
            ]);
        } catch (\Exception $e) {
            \Drupal::logger('custom_module')->error($e->getMessage());

            return new JsonResponse([
                'status'  => false,
                'message' => 'An error occurred: ' . $e->getMessage(),
            ], 500);
        }
    }
}
