<?php

namespace Drupal\api_module\Controller\form;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Database\Database;


class RFQformController extends ControllerBase
{
  public function submitRFQ(Request $request) {
    try {
      $data = json_decode($request->getContent(), TRUE);

      // Validate required fields
      if (!$data || empty($data['email']) || empty($data['fullName'])) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Missing required fields: email and fullName are required.',
        ], 400);
      }

        // Test the external_db connection
      $connection = \Drupal\Core\Database\Database::getConnection('default', 'external_db');
      $activeDb = $connection->getKey();
      $dbInfo = $connection->getConnectionOptions();


      // Validate the connection targets the correct database
      if ($dbInfo['database'] !== 'drl_crm_buyer') {
        throw new \Exception('Connected to wrong database: ' . $dbInfo['database'] . ' instead of drl_crm_buyer');
      }

      $table1="crm_lead_details";
      $table2="crm_login_details";



      // Insert into external DB

       $leadcred= $connection->insert($table2)->fields([
          'role' => 'buyer',
          'username' => $data['email'],
          'password' => base64_encode(99999),
        ])->execute();
        if($leadcred){
          $leadDetailsSave = $connection->insert($table1)
            ->fields([
              'fullName' => $data['fullName'] ?? NULL,
              'lastName' => $data['lastName'] ?? NULL,
              'email' => $data['email'],
              'MobilePhone' => $data['MobilePhone'] ?? NULL,
              'country' => $data['country'] ?? NULL,
              'companyName' => $data['companyName'] ?? NULL,
              'description' => $data['description'] ?? NULL,
              'productName' => $data['productName'] ?? NULL,
              'product_id' => $data['product_id'] ?? NULL,
              'product_pharmacopeia_gread' => $data['product_pharmacopeia_gread'] ?? NULL,
              'dosage_form_product' => $data['dosage_form_product'] ?? NULL,
              'target_market' => $data['target_market'] ?? NULL,
              'regulatory_requirments' => $data['regulatory_requirments'] ?? NULL,
              'purpose' => $data['purpose'] ?? NULL,
              'end_customer_info' => $data['end_customer_info'] ?? NULL,
              'quantity_required_development' => $data['quantity_required_development'] ?? NULL,
              'estimated_commercial_demand' => $data['estimated_commercial_demand'] ?? NULL,
              'lead_source' => $data['lead_source'] ?? NULL,
              'source_url' => $data['source_url'] ?? NULL,
              'message' => $data['message'] ?? NULL,
              'login_id' => $leadcred
            ])
            ->execute();
        }

      return new JsonResponse([
        'status' => true,
        'message' => 'RFQ submitted successfully.',
      ]);


     /*  Mail start : */
      $outlook_mail_service = \Drupal::service('outlook_mail.service');
      $subject = 'Thank you for your RFQ Submission';
      $body = 'Hi ' . $data['fullName'] . ",\n\nThank you for submitting the RFQ. We will get back to you shortly.";
      // // Send Email
      $outlook_mail_service->sendOutlookEmail($data['email'], $subject, $body);

      return new JsonResponse([
        'status' => true,
        'message' => 'RFQ submitted successfully.',
      ]);
    }
    catch (\Exception $e) {
      \Drupal::logger('crm_lead_details')->error($e->getMessage()); // Log the error
      return new JsonResponse([
        'status' => false,
        'message' => 'Submission failed: ' . $e->getMessage(),
      ], 500);
    }
  }
}



?>
