<?php

namespace Drupal\api_module\Controller\form;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\node\Entity\Node;


class LeadFormController extends ControllerBase{
  public function storeFormData(Request $request) {
      try {
        $data = json_decode($request->getContent(), true);

        // Validate required fields.
        $required_fields = [
          'title',
          'first_name',
          'last_name',
          'work_email',
          'country',
          'organization',
          'product',
          'product_id',
          'job_title',
          'message',
          'submitted_source_type_tid', // taxonomy term ID
          'submitted_source_details',
        ];

        foreach ($required_fields as $field) {
          if (empty($data[$field])) {
            return new JsonResponse([
              'status' => false,
              'message' => "Missing required field: $field",
            ], 400);
          }
        }

        // Create the node.
        $node = Node::create([
          'type' => 'form_submitted_data',
          'title' => $data['title'], // Or use a UUID/empty title if not needed
          'field_first_name' => $data['first_name'],
          'field_last_name' => $data['last_name'],
          'field_work_email' => $data['work_email'],
          'field_country' => $data['country'],
          'field_phone_number' => $data['phone_number'] ?? NULL,
          'field_organization' => $data['organization'],
          'field_product' => $data['product'],
          'field_product_id' => $data['product_id'],
          'field_job_title' => $data['job_title'],
          'field_message' => $data['message'],
          'field_submitted_source_type' => ['target_id' => $data['submitted_source_type_tid']],
          'field_summited_source_details' => $data['submitted_source_details'],
          'status' => 1,
        ]);

        $node->save();

        return new JsonResponse([
          'status' => true,
          'message' => 'Form data submitted successfully!',
          'nid' => $node->id(),
        ]);
      }
      catch (\Exception $e) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Error: ' . $e->getMessage(),
        ], 500);
      }
  }
}
?>
