<?php

namespace Drupal\api_module\Controller\customerservice;

use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;
use Drupal\taxonomy\Entity\Term;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\paragraphs\Entity\Paragraph;
use Drupal\media\Entity\Media;
use Drupal\Core\File\FileUrlGenerator;
use Drupal\Core\Entity\TranslatableInterface;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Class CustomerserviceController.
 *
 * Provides route responses for the AllDetailsPage.
 */
class CustomerserviceController extends ControllerBase
{
  public function customerServiceBanner(Request $request)
  {
    try {
      $content = $request->getContent();
      $input = json_decode($content, TRUE);
      $requested_langcode = isset($input['lan']) ? $input['lan'] : 'en';

      if (empty($input['lan'])) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      $database = \Drupal::database();

      $fetchData = function ($langcode) use ($database) {
        $query = $database->select('node_field_data', 'nfd')
          ->fields('nfd', ['nid', 'title', 'langcode']);

        $query->leftJoin('node__field_banner_heading', 'nfbh', 'nfbh.entity_id = nfd.nid AND nfbh.delta = 0 AND nfbh.langcode = :langcode');
        $query->addField('nfbh', 'field_banner_heading_value', 'banner_heading');

        $query->leftJoin('node__field_banner_image', 'nfabi', 'nfabi.entity_id = nfd.nid AND nfabi.delta = 0 AND nfabi.langcode = :langcode');
        $query->addField('nfabi', 'field_banner_image_target_id', 'banner_image');

        $query->leftJoin('node__field_common_banner_brochure', 'nfcbb', 'nfcbb.entity_id = nfd.nid AND nfcbb.delta = 0 AND nfcbb.langcode = :langcode');
        $query->addField('nfcbb', 'field_common_banner_brochure_target_id', 'brochure');

        $query->leftJoin('node__field_navigation_link', 'nfablin', 'nfablin.entity_id = nfd.nid AND nfablin.delta = 0 AND nfablin.langcode = :langcode');
        $query->addField('nfablin', 'field_navigation_link_value', 'banner_navigation_link');

        $query->leftJoin('node__field_page_type', 'nfptyp', 'nfptyp.entity_id = nfd.nid AND nfptyp.delta = 0');
        $query->addField('nfptyp', 'field_page_type_target_id', 'page_type');

        $query->leftJoin('taxonomy_term_field_data', 'ttfd', 'ttfd.tid = nfptyp.field_page_type_target_id');
        $query->addField('ttfd', 'name', 'page_type_name');

        $query->condition('nfd.type', 'common_inner_banner_section');
        $query->condition('nfd.status', 1);
        $query->condition('nfptyp.field_page_type_target_id', 13);
        $query->condition('nfd.langcode', $langcode);
        $query->addExpression(':langcode', 'langcode', [':langcode' => $langcode]);

        $query->distinct();
        return $query->execute()->fetchAll();
      };

      $results = $fetchData($requested_langcode);
      $fallback = false;

      if (empty($results) && $requested_langcode !== 'en') {
        $requested_langcode = 'en';
        $results = $fetchData('en');
        $fallback = true;
      }

      $lang_names = \Drupal::languageManager()->getStandardLanguageList();
      $data = [];

      foreach ($results as $row) {
        $bannerImg_url = '';
        if (!empty($row->banner_image)) {
          $file = \Drupal\file\Entity\File::load($row->banner_image);
          if ($file) {
            $bannerImg_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
          }
        }

        $brochure = '';
        if (!empty($row->brochure)) {
          $brochureFile = \Drupal\file\Entity\File::load($row->brochure);
          if ($brochureFile) {
            $brochure = \Drupal::service('file_url_generator')->generateAbsoluteString($brochureFile->getFileUri());
          }
        }

        $data = [
          'nid' => $row->nid,
          'banner_navigation' => $row->banner_navigation_link ?? '',
          'banner_heading' => $row->banner_heading ?? '',
          'banner_image' => $bannerImg_url,
          'banner_download_brochure_link' => $brochure,
          'langcode' => $row->langcode,
          'language_name' => $lang_names[$row->langcode][0] ?? ucfirst($row->langcode),
        ];
      }

      return new JsonResponse([
        'status' => true,
        'message' => $fallback
          ? 'Fallback to English. No data found in requested language.'
          : 'Banner data fetched successfully',
        'data' => $data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }


  // public function customerServiceMainContent(Request $request)
  // {
  //   try {
  //     $content = $request->getContent();
  //     $input = json_decode($content, TRUE);
  //     $requested_langcode = isset($input['lan']) ? $input['lan'] : '';

  //     if (empty($requested_langcode)) {
  //       return new JsonResponse([
  //         'status' => false,
  //         'message' => 'Language parameter is missing',
  //       ], 400);
  //     }

  //     $database = \Drupal::database();

  //     $fetchData = function ($langcode) use ($database) {
  //       $query = $database->select('node_field_data', 'nfd')
  //         ->fields('nfd', ['nid', 'title', 'langcode']);

  //       $query->leftJoin(
  //         'node__field__customer_service_main_sec',
  //         'nfdes',
  //         'nfdes.entity_id = nfd.nid AND nfdes.delta = 0 AND nfdes.langcode = :langcode'
  //       );
  //       $query->addField('nfdes', 'field__customer_service_main_sec_value', 'bold_heading');

  //       $query->leftJoin(
  //         'node__field_cs_main_sec_above_heading',
  //         'nfhe',
  //         'nfhe.entity_id = nfd.nid AND nfhe.delta = 0 AND nfhe.langcode = :langcode'
  //       );
  //       $query->addField('nfhe', 'field_cs_main_sec_above_heading_value', 'small_heading');

  //       $query->leftJoin(
  //         'node__field_cs_main_sec_description',
  //         'nfsico',
  //         'nfsico.entity_id = nfd.nid AND nfsico.delta = 0 AND nfsico.langcode = :langcode'
  //       );
  //       $query->addField('nfsico', 'field_cs_main_sec_description_value', 'description');

  //       $query->leftJoin(
  //         'node__field_cs_main_sec_icon',
  //         'nfsicon',
  //         'nfsicon.entity_id = nfd.nid AND nfsicon.delta = 0 AND nfsicon.langcode = :langcode'
  //       );
  //       $query->addField('nfsicon', 'field_cs_main_sec_icon_target_id', 'icon_image');

  //       $query->leftJoin(
  //         'node__field_customer_service_main_sect',
  //         'nfsimg',
  //         'nfsimg.entity_id = nfd.nid AND nfsimg.delta = 0 AND nfsimg.langcode = :langcode'
  //       );
  //       $query->addField('nfsimg', 'field_customer_service_main_sect_target_id', 'main_image');

  //       $query->condition('nfd.type', 'customer_service_main_section');
  //       $query->condition('nfd.status', 1);
  //       $query->condition('nfd.langcode', $langcode);
  //       $query->addExpression(':langcode', 'langcode', [':langcode' => $langcode]);

  //       $query->distinct();
  //       return $query->execute()->fetchAll();
  //     };

  //     $results = $fetchData($requested_langcode);
  //     $fallback = false;

  //     if (empty($results) && $requested_langcode !== 'en') {
  //       $requested_langcode = 'en';
  //       $results = $fetchData('en');
  //       $fallback = true;
  //     }

  //     $lang_names = \Drupal::languageManager()->getStandardLanguageList();
  //     $data = [];

  //     foreach ($results as $row) {
  //       $main_img_url = '';
  //       $icon_img_url = '';

  //       if (!empty($row->main_image)) {
  //         $file = \Drupal\file\Entity\File::load($row->main_image);
  //         if ($file) {
  //           $main_img_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
  //         }
  //       }

  //       if (!empty($row->icon_image)) {
  //         $file = \Drupal\file\Entity\File::load($row->icon_image);
  //         if ($file) {
  //           $icon_img_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
  //         }
  //       }

  //       $data = [
  //         'nid' => $row->nid,
  //         'bold_heading' => $row->bold_heading ?? '',
  //         'small_heading' => $row->small_heading ?? '',
  //         'content_description' => strip_tags($row->description ?? ''),
  //         'main_img_url' => $main_img_url,
  //         'icon_img_url' => $icon_img_url,
  //         'langcode' => $row->langcode,
  //         'language_name' => $lang_names[$row->langcode][0] ?? ucfirst($row->langcode),
  //       ];
  //     }

  //     return new JsonResponse([
  //       'status' => true,
  //       'message' => $fallback
  //         ? 'Fallback to English. No data found in requested language.'
  //         : 'Customer service main section content fetched successfully',
  //       'data' => $data,
  //     ]);
  //   } catch (\Exception $e) {
  //     return new JsonResponse([
  //       'status' => false,
  //       'message' => 'An error occurred: ' . $e->getMessage(),
  //     ], 500);
  //   }
  // }
  public function customerServiceMainContent(Request $request)
  {
    try {
      $content = json_decode($request->getContent(), true);
      $requested_langcode = $content['lan'] ?? '';

      if (empty($requested_langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language code (lan) is required',
        ], 400);
      }

      $database = \Drupal::database();

      $fetchNodeIds = function ($langcode) use ($database) {
        $query = $database->select('node_field_data', 'nfd')
          ->fields('nfd', ['nid'])
          ->condition('nfd.type', 'customer_service_main_section')
          ->condition('nfd.status', 1)
          ->condition('nfd.langcode', $langcode);
        return $query->execute()->fetchCol();
      };

      $nids = $fetchNodeIds($requested_langcode);
      $fallback = false;

      // Fallback to English if no nodes found
      if (empty($nids) && $requested_langcode !== 'en') {
        $requested_langcode = 'en';
        $nids = $fetchNodeIds('en');
        $fallback = true;
      }

      $nodes = \Drupal\node\Entity\Node::loadMultiple($nids);
      $response = [];

      $language = \Drupal::languageManager()->getLanguage($requested_langcode);
      $language_name = $language ? $language->getName() : $requested_langcode;

      foreach ($nodes as $node) {
        if ($node->hasTranslation($requested_langcode)) {
          $node = $node->getTranslation($requested_langcode);
        }

        $nid = $node->id();
        $bold_heading = $node->get('field__customer_service_main_sec')->value ?? '';
        $small_heading = $node->get('field_cs_main_sec_above_heading')->value ?? '';
        $content_description = $node->get('field_cs_main_sec_description')->value ?? '';
        $main_image = $node->get('field_customer_service_main_sect')->target_id ?? '';
        $icon_image = $node->get('field_cs_main_sec_icon')->target_id ?? '';

        $main_img_url = '';
        $icon_img_url = '';
        if (!empty($main_image)) {
          $file = \Drupal\file\Entity\File::load($main_image);
          if ($file) {
            $main_img_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
          }
        }
        if (!empty($icon_image)) {
          $file = \Drupal\file\Entity\File::load($icon_image);
          if ($file) {
            $icon_img_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
          }
        }

        $data = [
          'nid' => $nid,
          'bold_heading' => $bold_heading,
          'small_heading' => $small_heading,
          'content_description' => $content_description,
          'main_img_url' => $main_img_url ?? '',
          'icon_img_url' => $icon_img_url ?? '',
          'langcode' => $requested_langcode,
          'language_name' => $language_name,
        ];
      }

      return new JsonResponse([
        'status' => true,
        'message' => $fallback
          ? 'Fallback to English. No data found in requested language.'
          : 'Customer service main section content fetched successfully',
        'data' => $data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }
  public function faqcontentDetails(Request $request)
  {
    try {
      $content = json_decode($request->getContent(), true);
      $requested_langcode = $content['lan'] ?? '';

      if (empty($requested_langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language code (lan) is required',
        ], 400);
      }

      $database = \Drupal::database();

      // Fetch node IDs for valid about_tab_year_content
      $fetchNodeIds = function ($langcode) use ($database) {
        $query = $database->select('node_field_data', 'nfd')
          ->fields('nfd', ['nid'])
          ->condition('nfd.type', 'customer_service_faq_details')
          ->condition('nfd.status', 1)
          ->condition('nfd.langcode', $langcode);
        return $query->execute()->fetchCol();
      };

      $nids = $fetchNodeIds($requested_langcode);
      $fallback = false;

      // Fallback to English if no nodes found
      if (empty($nids) && $requested_langcode !== 'en') {
        $requested_langcode = 'en';
        $nids = $fetchNodeIds('en');
        $fallback = true;
      }

      $nodes = \Drupal\node\Entity\Node::loadMultiple($nids);
      $response = [];

      $language = \Drupal::languageManager()->getLanguage($requested_langcode);
      $language_name = $language ? $language->getName() : $requested_langcode;

      foreach ($nodes as $node) {
        if ($node->hasTranslation($requested_langcode)) {
          $node = $node->getTranslation($requested_langcode);
        }

        $nid = $node->id();
        $title = $node->getTitle();
        $question = $node->get('field_customer_faq_question')->value ?? '';
        $answer = $node->get('field_customer_faq_answer')->value ?? '';
        $row = [];
        if ($node->hasField('field_customer_service_devotion') && !$node->get('field_customer_service_devotion')->isEmpty()) {
          foreach ($node->get('field_customer_service_devotion') as $para_ref) {
            $para = $para_ref->entity;
            if ($para && $para->hasTranslation($requested_langcode)) {
              $para = $para->getTranslation($requested_langcode);
            }
            $media_header = $para->get('field_media_header')->value ?? "";
            $media_footer = $para->get('field_media_footer')->value ?? "";


            $media_details = [];
            if ($para->hasField('field_media') && !$para->get('field_media')->isEmpty()) {
              foreach ($para->get('field_media') as $media_ref) {
                $media = $media_ref->entity ?? null;

                if ($media) {
                  $file = $media->get('field_media_image_2')->entity ?? null;
                  $image_url = $file ? \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri()) : '';

                  $heading = $media->get('field_heading')->value ?? '';
                  $subheading = $media->get('field_subheading')->value ?? '';
                  $list = array_column($media->get('field_lists')->getValue() ?? [], 'value');

                  $media_details[] = [
                    'icon' => $image_url,
                    'heading' => $heading,
                    'subheading' => $subheading,
                    'list' => $list,
                  ];
                }
              }
            }

            $row[] = [
              'header' => $media_header,
              'footer' => $media_footer,
              "box_data" => $media_details
            ];
          }
        }
        $response[] = [
          'nid' => $nid,
          'langcode' => $requested_langcode,
          'language_name' => $language_name,
          'title' => $title ?? "",
          'faq_question' => $question,
          'faq_answer' => $answer,
          "data" => $row
        ];
      }
      return new JsonResponse([
        'status' => true,
        'message' => $fallback == true ? 'Fallback to English. As No Data found in the requested language.' : 'Data fetch successfully',
        'data' => $response,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred' . $e->getMessage(),
      ], 500);
    }
  }


  public function customerServiceResourceTabContent(Request $request)
  {
    try {
      $content = $request->getContent();
      $input = json_decode($content, TRUE);
      $requested_langcode = isset($input['lan']) ? $input['lan'] : '';

      if (empty($requested_langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      $database = \Drupal::database();
      $term_storage = \Drupal::entityTypeManager()->getStorage('taxonomy_term');
      $term_tree = $term_storage->loadTree('home_resource');
      $term_ids = array_column($term_tree, 'tid');
      $terms = $term_storage->loadMultiple($term_ids);
      $lang_names = \Drupal::languageManager()->getStandardLanguageList();

      $fetchData = function ($langcode) use ($database, $terms) {
        $data = [];

        foreach ($terms as $term) {
          $term_id = $term->id();
          $term_name = $term->getName();

          $query = $database->select('node_field_data', 'nfd')
            ->fields('nfd', ['nid', 'title', 'langcode']);

          $query->leftJoin('node__field_customer_resource_type', 'nfctty', 'nfctty.entity_id = nfd.nid AND nfctty.langcode = :langcode', [':langcode' => $langcode]);
          $query->addField('nfctty', 'field_customer_resource_type_target_id', 'type');

          $query->leftJoin('node__field_cust_resou_details_img', 'nfctc', 'nfctc.entity_id = nfd.nid AND nfctc.langcode = :langcode');
          $query->addField('nfctc', 'field_cust_resou_details_img_target_id', 'image');

          $query->leftJoin('node__field_cust_ser_resou_detail_desc', 'nfctdes', 'nfctdes.entity_id = nfd.nid AND nfctdes.langcode = :langcode');
          $query->addField('nfctdes', 'field_cust_ser_resou_detail_desc_value', 'description');

          $query->leftJoin('node__field_cust_service_reso_details_', 'nfcthead', 'nfcthead.entity_id = nfd.nid AND nfcthead.langcode = :langcode');
          $query->addField('nfcthead', 'field_cust_service_reso_details__value', 'details_title');

          $query->condition('nfd.type', 'customer_service_resource_type');
          $query->condition('nfd.status', 1);
          $query->condition('nfd.langcode', $langcode);
          $query->condition('nfctty.field_customer_resource_type_target_id', $term_id);
          $query->addExpression(':langcode', 'langcode', [':langcode' => $langcode]);
          $query->distinct();

          $results = $query->execute()->fetchAll();
          $term_data = [];

          foreach ($results as $row) {
            $image_url = '';

            if (!empty($row->image)) {
              $file = \Drupal\file\Entity\File::load($row->image);
              if ($file) {
                $image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
              }
            }

            $term_data[] = [
              'nid' => (string) $row->nid,
              'content' => strip_tags($row->description ?? ''),
              'heading' => $row->details_title ?? '',
              'image' => $image_url,
              'langcode' => $row->langcode,
              'language_name' => $lang_names[$row->langcode][0] ?? ucfirst($row->langcode),
            ];
          }

          $data[] = [
            'resource_name' => $term_name,
            'items' => $term_data,
          ];
        }

        return $data;
      };

      $data = $fetchData($requested_langcode);
      $fallback = false;

      $has_content = false;
      foreach ($data as $term_group) {
        if (!empty($term_group['items'])) {
          $has_content = true;
          break;
        }
      }

      if (!$has_content && $requested_langcode !== 'en') {
        $requested_langcode = 'en';
        $data = $fetchData('en');
        $fallback = true;
      }

      return new JsonResponse([
        'status' => true,
        'message' => $fallback
          ? 'Fallback to English. No data found in requested language.'
          : 'Grouped resource data fetched successfully',
        'data' => $data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }


  public function customerServiceProductContent(Request $request)
  {
    try {
      $content = $request->getContent();
      $input = json_decode($content, TRUE);
      $requested_langcode = isset($input['lan']) ? $input['lan'] : '';

      if (empty($requested_langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      $database = \Drupal::database();
      $lang_names = \Drupal::languageManager()->getStandardLanguageList();

      $fetchData = function ($langcode) use ($database, $lang_names) {
        $query = $database->select('node_field_data', 'nfd')
          ->fields('nfd', ['nid', 'title', 'langcode']);

        $query->leftJoin('node__field_cs_our_products_image', 'nfcapImg', 'nfcapImg.entity_id = nfd.nid AND nfcapImg.delta = 0 AND nfcapImg.langcode = :langcode', [':langcode' => $langcode]);
        $query->addField('nfcapImg', 'field_cs_our_products_image_target_id', 'image');

        $query->leftJoin('node__field_customer_service_our_produ', 'nfcaptext', 'nfcaptext.entity_id = nfd.nid AND nfcaptext.delta = 0 AND nfcaptext.langcode = :langcode');
        $query->addField('nfcaptext', 'field_customer_service_our_produ_value', 'product_link');

        $query->leftJoin('node__field__customer_service_our_prod', 'nfcsop', 'nfcsop.entity_id = nfd.nid AND nfcsop.delta = 0 AND nfcsop.langcode = :langcode');
        $query->addField('nfcsop', 'field__customer_service_our_prod_value', 'product_value');

        $query->condition('nfd.type', 'customer_service_our_products');
        $query->condition('nfd.status', 1);
        $query->condition('nfd.langcode', $langcode);
        $query->addExpression(':langcode', 'langcode', [':langcode' => $langcode]);
        $query->distinct();

        $result = $query->execute();
        $data = [];

        foreach ($result as $row) {
          $nid = $row->nid;

          $img_url = '';
          if (!empty($row->image)) {
            $file = \Drupal\file\Entity\File::load($row->image);
            if ($file) {
              $img_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
            }
          }

          $data[] = [
            'nid' => $nid,
            'product_value' => $row->product_value ?? '',
            'product_link' => $row->product_link ?? '',
            'image' => $img_url,
            'langcode' => $row->langcode,
            'language_name' => $lang_names[$row->langcode][0] ?? ucfirst($row->langcode),
          ];
        }

        return $data;
      };

      $data = $fetchData($requested_langcode);
      $fallback = false;

      if (empty($data) && $requested_langcode !== 'en') {
        $requested_langcode = 'en';
        $data = $fetchData('en');
        $fallback = true;
      }

      return new JsonResponse([
        'status' => true,
        'message' => $fallback
          ? 'Fallback to English. No data found in requested language.'
          : 'Customer Our Product section data fetched successfully',
        'data' => $data,
      ]);
    } catch (\Throwable $th) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $th->getMessage(),
      ], 500);
    }
  }
}
