<?php

namespace Drupal\api_module\Controller;

use Exception;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\file\Entity\File;
use Drupal\node\Entity\Node;
use Drupal\taxonomy\Entity\Term;


class ResourceController extends ControllerBase
{
  /**
   * Returns a JSON response.
   */

  public function getResourceList(Request $request)
  {
    // try {
    //   $content = $request->getContent();
    //   $data = json_decode($content, TRUE);

    //   if (empty($data['lan'])) {
    //       return new JsonResponse([
    //           'status' => false,
    //           'message' => 'Language parameter is missing',
    //       ], 400);
    //   }

    //   $requested_langcode = $data['lan'];
    //   $database = \Drupal::database();

    //   $fetchTerms = function ($langcode) use ($database) {
    //     $query = $database->select('taxonomy_term_field_data', 'td');
    //     $query->fields('td', ['tid', 'name', 'langcode']);

    //     $query->leftJoin('taxonomy_term__field_resource_link', 'link', 'link.entity_id = td.tid');
    //     $query->addField('link', 'field_resource_link_value', 'resource_link');

    //     $query->leftJoin('taxonomy_term__field_resource_icon', 'img', 'img.entity_id = td.tid');
    //     $query->addField('img', 'field_resource_icon_target_id', 'resource_img');

    //     $query->condition('td.vid', 'home_resource');
    //     $query->condition('td.status', 1);
    //     $query->condition('td.langcode', $langcode);
    //     $query->orderBy('td.tid', 'ASC');
    //     return $query->execute()->fetchAll();
    //   };

    //   $results_lang = $fetchTerms($requested_langcode);
    //   if (empty($results_lang) || $requested_langcode !== 'en') {
    //         if (empty($results_lang)) {
    //             $results_lang = $fetchTerms('en');
    //         }
    //   }
    //   $lang_names = \Drupal::languageManager()->getStandardLanguageList();
    //   $response_data = [];
    //   foreach ($results_lang as $term) {
    //       $langcode = $term->langcode;
    //       $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

    //       $resource_icon_url = '';
    //       if (!empty($term->resource_img)) {
    //         $file = \Drupal\file\Entity\File::load($term->resource_img);
    //         if ($file) {
    //           $resource_icon_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
    //         }
    //       }

    //       $response_data[] = [
    //           'tid'           => (int) $term->tid,
    //           'name'          => (string) $term->name,
    //           'resource_link' => (string) ($term->resource_link ?? ''),
    //           'resource_icon' => $resource_icon_url,
    //           'langcode'      => $langcode,
    //           'language_name' => $language_name,
    //       ];
    //   }
    //     return new JsonResponse([
    //         'status'         => true,
    //         'message'        => 'Resource List fetched successfully.',
    //         'data'           => $response_data,
    //     ]);
    // } catch (\Exception $th) {
    //   //throw $th;
    //   \Drupal::logger('custom_module')->error($th->getMessage());

    //     return new JsonResponse([
    //         'status'  => false,
    //         'message' => 'An error occurred: ' . $th->getMessage(),
    //     ], 500);
    // }
    try {
      $content = $request->getContent();
      $data = json_decode($content, TRUE);

      $fallback = false;
      if (empty($data['lan'])) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      $requested_langcode = $data['lan'];
      $lang_names = \Drupal::languageManager()->getStandardLanguageList();

      // Load all published terms from 'home_resource' vocab with accessCheck disabled
      $term_ids = \Drupal::entityQuery('taxonomy_term')
        ->accessCheck(FALSE)
        ->condition('vid', 'home_resource')
        ->condition('status', 1)
        ->execute();

      $terms = Term::loadMultiple($term_ids);
      $response_data = [];

      foreach ($terms as $term) {
        // Translation fallback logic
        if ($term->hasTranslation($requested_langcode)) {
          $term = $term->getTranslation($requested_langcode);
        } elseif ($requested_langcode !== 'en' && $term->hasTranslation('en')) {
          $fallback = true;
          $term = $term->getTranslation('en');
        }

        $langcode = $term->language()->getId();
        $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

        // Handle image URL
        $resource_icon_url = '';
        $resource_img_id = $term->get('field_resource_icon')->target_id ?? null;
        if (!empty($resource_img_id)) {
          $file = File::load($resource_img_id);
          if ($file) {
            $resource_icon_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
          }
        }

        $response_data[] = [
          'tid'           => (int) $term->id(),
          'name'          => $term->label(),
          'resource_link' => $term->get('field_resource_link')->value ?? '',
          'resource_icon' => $resource_icon_url,
          'langcode'      => $langcode,
          'language_name' => $language_name,
        ];
      }

      return new JsonResponse([
        'status'  => true,
        'message' => $fallback == true ? 'Fallback to English. No content found in the requested language.' : 'Resource List fetched successfully.',
        'data'    => $response_data,
      ]);
    } catch (\Exception $th) {
      \Drupal::logger('custom_module')->error($th->getMessage());

      return new JsonResponse([
        'status'  => false,
        'message' => 'An error occurred: ' . $th->getMessage(),
      ], 500);
    }
  }



  public function yearWiseResourceList(Request $request)
  {
    try {
      $content = $request->getContent();
      $data = json_decode($content, TRUE);

      $langcode = $data['lan'] ?? '';
      $resource_id = $data['resource_id'] ?? null;
      $resource_menu_link = $data['resource_menu_link'] ?? null;

      if (empty($langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      // 🔹 Single resource by menu_link
      if (!empty($resource_menu_link)) {
        $result = [];

        $nids = \Drupal::entityQuery('node')
          ->condition('type', 'resources_details')
          ->condition('status', 1)
          ->accessCheck(TRUE)
          ->execute();

        foreach ($nids as $nid) {
          $node = \Drupal\node\Entity\Node::load($nid);
          $translated_node = $node->hasTranslation($langcode) ? $node->getTranslation($langcode) : $node;

          if ($translated_node->hasField('field_resource_details') && !$translated_node->get('field_resource_details')->isEmpty()) {
            foreach ($translated_node->get('field_resource_details') as $yearwise_item) {
              $yearwise_para = $yearwise_item->entity;
              if (!$yearwise_para || $yearwise_para->getType() !== 'resource_year_wise') continue;

              $translated_yearwise_para = $yearwise_para->hasTranslation($langcode)
                ? $yearwise_para->getTranslation($langcode)
                : $yearwise_para;

              if ($translated_yearwise_para->hasField('field_res_details') && !$translated_yearwise_para->get('field_res_details')->isEmpty()) {
                foreach ($translated_yearwise_para->get('field_res_details') as $entry_item) {
                  $entry_para = $entry_item->entity;
                  if (!$entry_para || $entry_para->getType() !== 'resource_details') continue;

                  $translated_entry_para = $entry_para->hasTranslation($langcode)
                    ? $entry_para->getTranslation($langcode)
                    : $entry_para;

                  $term = $translated_entry_para->get('field_resource_name')->entity ?? null;
                  if ($term) {
                    $translated_term = $term->hasTranslation($langcode) ? $term->getTranslation($langcode) : $term;
                    $menu_link = $translated_term->get('field_menu_link')->value ?? '';

                    if ($menu_link === $resource_menu_link) {
                      $result = [
                        'title' => $translated_entry_para->get('field_resource_main_heading')->value ?? '',
                        'description' => $translated_entry_para->get('field_res_description')->value ?? '',
                        'date' => $translated_entry_para->get('field_resource_date')->value ?? '',
                        'image' => !$translated_entry_para->get('field_resource_main_image')->isEmpty()
                          ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_resource_main_image')->entity->getFileUri())
                          : '',
                        'feature_image' => !$translated_entry_para->get('field_resource_feat_image')->isEmpty()
                          ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_resource_feat_image')->entity->getFileUri())
                          : '',
                        'banner_image' => !$translated_entry_para->get('field_resource_banner_image')->isEmpty()
                          ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_resource_banner_image')->entity->getFileUri())
                          : '',
                        'download_brochure' => !$translated_entry_para->get('field_download_brochure')->isEmpty()
                          ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_download_brochure')->entity->getFileUri())
                          : '',
                        'resource_type_name' => $translated_term->label(),
                        'menu_link' => $menu_link,
                      ];

                      return new JsonResponse([
                        'status' => true,
                        'data' => $result,
                      ]);
                    }
                  }
                }
              }
            }
          }
        }

        return new JsonResponse([
          'status' => false,
          'message' => 'Resource not found for this menu link',
        ], 404);
      }

      // 🔹 Year-wise grouped listing
      if (!$resource_id) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Resource ID is missing',
        ], 400);
      }

      $nids = \Drupal::entityQuery('node')
        ->condition('type', 'resources_details')
        ->condition('status', 1)
        ->condition('field_res_type', $resource_id)
        ->accessCheck(TRUE)
        ->execute();

      if (empty($nids)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'No content found for this resource ID',
        ], 404);
      }

      $output = [];

      foreach ($nids as $nid) {
        $node = \Drupal\node\Entity\Node::load($nid);
        $translated_node = $node->hasTranslation($langcode) ? $node->getTranslation($langcode) : $node;

        if ($translated_node->hasField('field_resource_details') && !$translated_node->get('field_resource_details')->isEmpty()) {
          foreach ($translated_node->get('field_resource_details') as $yearwise_item) {
            $yearwise_para = $yearwise_item->entity;
            if (!$yearwise_para || $yearwise_para->getType() !== 'resource_year_wise') continue;

            $translated_yearwise_para = $yearwise_para->hasTranslation($langcode)
              ? $yearwise_para->getTranslation($langcode)
              : $yearwise_para;

            $year = $translated_yearwise_para->get('field_year')->value ?? '';
            $entries = [];

            if ($translated_yearwise_para->hasField('field_res_details') && !$translated_yearwise_para->get('field_res_details')->isEmpty()) {
              foreach ($translated_yearwise_para->get('field_res_details') as $entry_item) {
                $entry_para = $entry_item->entity;
                if (!$entry_para || $entry_para->getType() !== 'resource_details') continue;

                $translated_entry_para = $entry_para->hasTranslation($langcode)
                  ? $entry_para->getTranslation($langcode)
                  : $entry_para;

                $title = $translated_entry_para->get('field_resource_main_heading')->value ?? '';
                $description = $translated_entry_para->get('field_res_description')->value ?? '';
                $date = $translated_entry_para->get('field_resource_date')->value ?? '';

                $main_image_url = !$translated_entry_para->get('field_resource_main_image')->isEmpty()
                  ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_resource_main_image')->entity->getFileUri())
                  : '';

                $feature_image_url = !$translated_entry_para->get('field_resource_feat_image')->isEmpty()
                  ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_resource_feat_image')->entity->getFileUri())
                  : '';

                $banner_image_url = !$translated_entry_para->get('field_resource_banner_image')->isEmpty()
                  ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_resource_banner_image')->entity->getFileUri())
                  : '';

                $download_brochure = !$translated_entry_para->get('field_download_brochure')->isEmpty()
                  ? \Drupal::service('file_url_generator')->generateAbsoluteString($translated_entry_para->get('field_download_brochure')->entity->getFileUri())
                  : '';

                $resource_type_name = '';
                $menu_link = '';
                if (!$translated_entry_para->get('field_resource_name')->isEmpty()) {
                  $term = $translated_entry_para->get('field_resource_name')->entity;
                  if ($term) {
                    $translated_term = $term->hasTranslation($langcode) ? $term->getTranslation($langcode) : $term;
                    $resource_type_name = $translated_term->label();
                    $menu_link = $translated_term->get('field_menu_link')->value ?? '';
                  }
                }

                $entry = [
                  'title' => $title,
                  'banner_heading' => $title,
                  'description' => $description,
                  'date' => $date,
                  'image' => $main_image_url,
                  'feature_image' => $feature_image_url,
                  'banner_image' => $banner_image_url,
                  'download_brochure' => $download_brochure,
                  'resource_type_name' => $resource_type_name,
                  'menu_link' => $menu_link,
                ];

                if ($resource_id == 7 || $resource_id == 8) {
                  $entry['year'] = $year;
                  $output[] = $entry;
                } else {
                  $entries[] = $entry;
                }
              }
            }

            if (($resource_id != 7 || $resource_id != 8) && ($year != null) && !empty($entries)) {
              $output[] = [
                'year' => $year,
                'resources' => $entries,
              ];
            }
          }
        }
      }

      return new JsonResponse([
        'status' => true,
        'data' => $output,
      ]);
    } catch (\Throwable $th) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $th->getMessage(),
      ], 500);
    }
  }

  public function resourceBannerDetails(Request $request)
  {
    try {
      $content = $request->getContent();
      $data = json_decode($content, TRUE);

      // Validate language
      if (empty($data['lan'])) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      $requested_langcode = $data['lan'];
      $resource_id = $data['resource_id'] ?? null;

      if (!$resource_id) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Resource ID is missing',
        ], 400);
      }

      $database = \Drupal::database();

      // Function to fetch only home_resource terms
      $fetchTerms = function ($langcode, $resource_id) use ($database) {
        $query = $database->select('taxonomy_term_field_data', 'td')
          ->fields('td', ['tid', 'name', 'langcode']);

        $query->leftJoin('taxonomy_term__field_banner', 'banner', 'banner.entity_id = td.tid');
        $query->addField('banner', 'field_banner_target_id', 'resource_banner_img');

        $query->leftJoin('taxonomy_term__field_brochure_link', 'brochure_link', 'brochure_link.entity_id = td.tid');
        $query->addField('brochure_link', 'field_brochure_link_target_id', 'brochure');

        $query->condition('td.vid', 'home_resource'); // 🔥 Only include 'home_resource' terms
        $query->condition('banner.entity_id', $resource_id);
        $query->condition('td.status', 1);
        $query->condition('td.langcode', $langcode);
        $query->orderBy('td.tid', 'ASC');

        return $query->execute()->fetchAll();
      };

      // Try requested language first
      $terms = $fetchTerms($requested_langcode, $resource_id);

      // Fallback to English
      if (empty($terms) && $requested_langcode !== 'en') {
        $terms = $fetchTerms('en', $resource_id);
      }

      $lang_names = \Drupal::languageManager()->getStandardLanguageList();
      $response_data = [];

      foreach ($terms as $term) {
        $langcode = $term->langcode;
        $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

        $banner_img_url = '';
        if (!empty($term->resource_banner_img)) {
          $file = \Drupal\file\Entity\File::load($term->resource_banner_img);
          if ($file) {
            $banner_img_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
          }
        }

        $brochure = '';
        if (!empty($term->brochure)) {
          $brochureFile = \Drupal\file\Entity\File::load($term->brochure);
          if ($file) {
            $brochure = \Drupal::service('file_url_generator')->generateAbsoluteString($brochureFile->getFileUri());
          }
        }

        $response_data = [
          'tid' => (int) $term->tid,
          'name' => (string) $term->name,
          'banner_heading' => (string) $term->name,
          'banner_image' => $banner_img_url,
          'banner_navigation' => (string) $term->name,
          'brochure_link' => $brochure,
          'langcode' => $langcode,
          'language_name' => $language_name,
        ];
      }

      return new JsonResponse([
        'status' => true,
        'message' => 'Home resource banner details fetched successfully.',
        'data' => $response_data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }

  // public function getResourceDetailsList(Request $request)
  // {
  //   try {
  //     $content = $request->getContent();
  //     $data = json_decode($content, TRUE);

  //     // Validate language
  //     if (empty($data['lan'])) {
  //       return new JsonResponse([
  //         'status' => false,
  //         'message' => 'Language parameter is missing',
  //       ], 400);
  //     }

  //     $resource_id = $data['resource_id'] ?? null;
  //     $requested_langcode = $data['lan'];
  //     $database = \Drupal::database();

  //     if (!$resource_id) {
  //       return new JsonResponse([
  //         'status' => false,
  //         'message' => 'Resource ID is missing',
  //       ], 400);
  //     }

  //     // Term fetch logic
  //     $fetchTerms = function ($langcode, $resource_id) use ($database) {
  //       $query = $database->select('taxonomy_term_field_data', 'td');
  //       $query->fields('td', ['tid', 'name', 'langcode']);

  //       $query->leftJoin('taxonomy_term__field_menu_link', 'link', 'link.entity_id = td.tid');
  //       $query->addField('link', 'field_menu_link_value', 'resource_link');

  //       $query->leftJoin('taxonomy_term__field_home_resource_type', 'rc_type', 'rc_type.entity_id = td.tid');
  //       $query->addField('rc_type', 'field_home_resource_type_target_id', 'target_id');

  //       $query->condition('rc_type.field_home_resource_type_target_id', $resource_id);
  //       $query->condition('td.status', 1);
  //       $query->condition('td.langcode', $langcode);
  //       $query->orderBy('td.tid', 'ASC');

  //       return $query->execute()->fetchAll();
  //     };

  //     // Try requested language first
  //     $terms = $fetchTerms($requested_langcode, $resource_id);

  //     // Fallback to English if no result
  //     if (empty($terms) && $requested_langcode !== 'en') {
  //       $terms = $fetchTerms('en', $resource_id);
  //     }

  //     // Language list
  //     $lang_names = \Drupal::languageManager()->getStandardLanguageList();
  //     $response_data = [];

  //     foreach ($terms as $term) {
  //       $langcode = $term->langcode;
  //       $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

  //       $entry = [
  //         'tid'           => (int) $term->tid,
  //         'name'          => (string) $term->name,
  //         'resource_link' => (string) ($term->resource_link ?? ''),
  //         'langcode'      => $langcode,
  //         'language_name' => $language_name,
  //       ];

  //       // If resource_id is 10, fetch image, date, year
  //       if ((int)$resource_id === 10) {
  //         // Get related node(s) from term
  //         $node_ids = \Drupal::entityQuery('node')
  //           ->accessCheck(TRUE)
  //           ->condition('type', 'webinar_details') // Adjust to your actual content type
  //           ->condition('status', 1)
  //           ->condition('field_webinar_name.target_id', $term->tid)
  //           ->execute();

  //         $nodes = \Drupal\node\Entity\Node::loadMultiple($node_ids);
  //         $extra_data = [];

  //         foreach ($nodes as $node) {
  //           $image_url = '';
  //           if ($node->hasField('field_webinar_main_image') && !$node->get('field_webinar_main_image')->isEmpty()) {
  //             $image_file = $node->get('field_webinar_main_image')->entity;
  //             if ($image_file) {
  //               $image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($image_file->getFileUri());
  //             }
  //           }

  //           $date_value = '';
  //           if ($node->hasField('field_date') && !$node->get('field_date')->isEmpty()) {
  //             $date_value = $node->get('field_date')->value;
  //           }

  //           $extra_data[] = [
  //             'image' => $image_url,
  //             'date'  => $date_value,
  //             // using term name as year
  //           ];
  //         }

  //         $entry['details'] = $extra_data;
  //       }

  //       $response_data[] = $entry;
  //     }

  //     return new JsonResponse([
  //       'status'  => true,
  //       'message' => 'Resource details fetched successfully.',
  //       'data'    => $response_data,
  //     ]);
  //   } catch (\Exception $e) {
  //     return new JsonResponse([
  //       'status' => false,
  //       'message' => 'An error occurred: ' . $e->getMessage(),
  //     ], 500);
  //   }
  // }
  public function getResourceDetailsList(Request $request)
  {
    try {
      $content = $request->getContent();
      $data = json_decode($content, TRUE);

      // Validate language
      if (empty($data['lan'])) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      $resource_id = $data['resource_id'] ?? null;
      $requested_langcode = $data['lan'];

      if (!$resource_id) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Resource ID is missing',
        ], 400);
      }

      // Load taxonomy terms
      $terms = \Drupal::entityTypeManager()
        ->getStorage('taxonomy_term')
        ->loadByProperties([
          'field_home_resource_type' => $resource_id,
          'status' => 1,
        ]);

      $lang_manager = \Drupal::languageManager();
      $lang_names = $lang_manager->getStandardLanguageList();

      $response_data = [];
      $found_in_requested_lang = false;

      // ----------- MAIN LOOP -----------
      foreach ($terms as $term) {
        if (!($term instanceof \Drupal\Core\Entity\TranslatableInterface) || !$term->hasTranslation($requested_langcode)) {
          continue; // term missing translation → skip
        }

        $term_translated = $term->getTranslation($requested_langcode);
        $langcode = $term_translated->language()->getId();
        $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

        $entry = [
          'tid'           => (int) $term_translated->id(),
          'name'          => (string) $term_translated->label(),
          'resource_link' => $term_translated->get('field_menu_link')->value ?? '',
          'langcode'      => $langcode,
          'language_name' => $language_name,
        ];

        // Check webinars only if resource_id == 10
        if ((int) $resource_id === 10) {
          $node_ids = \Drupal::entityQuery('node')
            ->accessCheck(TRUE)
            ->condition('type', 'webinar_details')
            ->condition('status', 1)
            ->condition('field_webinar_name.target_id', $term->id())
            ->execute();

          $nodes = \Drupal\node\Entity\Node::loadMultiple($node_ids);
          $extra_data = [];

          foreach ($nodes as $node) {
            if (!($node instanceof \Drupal\Core\Entity\TranslatableInterface) || !$node->hasTranslation($requested_langcode)) {
              continue; // node missing translation → skip
            }

            $node = $node->getTranslation($requested_langcode);

            $image_url = '';
            if ($node->hasField('field_webinar_main_image') && !$node->get('field_webinar_main_image')->isEmpty()) {
              $image_file = $node->get('field_webinar_main_image')->entity;
              if ($image_file) {
                $image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($image_file->getFileUri());
              }
            }

            $date_value = '';
            if ($node->hasField('field_date') && !$node->get('field_date')->isEmpty()) {
              $date_value = $node->get('field_date')->value;
            }

            $extra_data[] = [
              'image' => $image_url,
              'date'  => $date_value,
            ];
          }

          // ✅ Only add if term AND node(s) have translation
          if (empty($extra_data)) {
            continue;
          }
          $entry['details'] = $extra_data;
        }

        $response_data[] = $entry;
        $found_in_requested_lang = true;
      }

      // ----------- FALLBACK TO ENGLISH -----------
      if (!$found_in_requested_lang) {
        $response_data = [];
        $fallback_lang = 'en';

        foreach ($terms as $term) {
          if (!($term instanceof \Drupal\Core\Entity\TranslatableInterface) || !$term->hasTranslation($fallback_lang)) {
            continue;
          }

          $term_translated = $term->getTranslation($fallback_lang);
          $langcode = $term_translated->language()->getId();
          $language_name = $lang_names[$langcode][0] ?? ucfirst($langcode);

          $entry = [
            'tid'           => (int) $term_translated->id(),
            'name'          => (string) $term_translated->label(),
            'resource_link' => $term_translated->get('field_menu_link')->value ?? '',
            'langcode'      => $langcode,
            'language_name' => $language_name,
          ];

          if ((int) $resource_id === 10) {
            $node_ids = \Drupal::entityQuery('node')
              ->accessCheck(TRUE)
              ->condition('type', 'webinar_details')
              ->condition('status', 1)
              ->condition('field_webinar_name.target_id', $term->id())
              ->execute();

            $nodes = \Drupal\node\Entity\Node::loadMultiple($node_ids);
            $extra_data = [];

            foreach ($nodes as $node) {
              if (!($node instanceof \Drupal\Core\Entity\TranslatableInterface) || !$node->hasTranslation($fallback_lang)) {
                continue;
              }

              $node = $node->getTranslation($fallback_lang);

              $image_url = '';
              if ($node->hasField('field_webinar_main_image') && !$node->get('field_webinar_main_image')->isEmpty()) {
                $image_file = $node->get('field_webinar_main_image')->entity;
                if ($image_file) {
                  $image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($image_file->getFileUri());
                }
              }

              $date_value = '';
              if ($node->hasField('field_date') && !$node->get('field_date')->isEmpty()) {
                $date_value = $node->get('field_date')->value;
              }

              $extra_data[] = [
                'image' => $image_url,
                'date'  => $date_value,
              ];
            }

            if (empty($extra_data)) {
              continue;
            }
            $entry['details'] = $extra_data;
          }

          $response_data[] = $entry;
        }

        return new JsonResponse([
          'status'  => true,
          'message' => 'No data found in requested language. Falling back to English.',
          'data'    => $response_data,
        ]);
      }

      return new JsonResponse([
        'status'  => true,
        'message' => 'Resource details fetched successfully.',
        'data'    => $response_data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }



  /**
   * Helper to load image URL from a paragraph field.
   */
  protected function loadImageFromParagraph($paragraph, $field_name)
  {
    if ($paragraph->hasField($field_name) && !$paragraph->get($field_name)->isEmpty()) {
      $fid = $paragraph->get($field_name)->target_id;
      if ($fid) {
        $file = \Drupal\file\Entity\File::load($fid);
        if ($file) {
          return \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
        }
      }
    }
    return '';
  }

  public function resourceWebinarDetails(Request $request)
  {
    try {
      $content = $request->getContent();
      $input = json_decode($content, TRUE);
      $requested_langcode = $input['lan'] ?? 'en';
      $menu_link_value = $input['webiners_menu_link'] ?? null;

      if (empty($requested_langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language parameter is missing',
        ], 400);
      }

      if (empty($menu_link_value)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'webiners_menu_link is required.',
        ], 400);
      }

      // Find taxonomy term with field_menu_link matching input
      $term_ids = \Drupal::entityQuery('taxonomy_term')
        ->accessCheck(FALSE) // 👈 REQUIRED!
        ->condition('vid', 'webinar')
        ->condition('field_menu_link', $menu_link_value)
        ->range(0, 1)
        ->execute();

      if (empty($term_ids)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Invalid menu link or taxonomy term not found for alias: ' . $menu_link_value,
        ], 404);
      }

      $term_id = reset($term_ids);

      // Find node referencing the term via field_webinar_name
      $node_ids = \Drupal::entityQuery('node')
        ->accessCheck(FALSE) // 👈 REQUIRED to bypass permission checks if needed
        ->condition('type', 'webinar_details') // ✅ Corrected content type
        ->condition('status', 1)
        ->condition('field_webinar_name.target_id', $term_id)
        ->range(0, 1)
        ->execute();


      if (empty($node_ids)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'No webinar node found for the provided menu link.',
        ], 404);
      }

      $node = Node::load(reset($node_ids));

      if (!$node || !$node->hasTranslation($requested_langcode)) {
        if ($requested_langcode !== 'en' && $node->hasTranslation('en')) {
          $node = $node->getTranslation('en');
          $fallback = true;
        } else {
          return new JsonResponse([
            'status' => false,
            'message' => 'Node not found in the requested language or fallback.',
          ], 404);
        }
      } else {
        $node = $node->getTranslation($requested_langcode);
        $fallback = false;
      }

      // Helper for file URL
      $getImageUrl = function ($fid) {
        if ($fid && ($file = File::load($fid))) {
          return \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
        }
        return '';
      };

      // Speakers
      $speakers = [];
      if ($node->hasField('field_speakers') && !$node->get('field_speakers')->isEmpty()) {
        foreach ($node->get('field_speakers') as $item) {
          $para = $item->entity;
          if ($para && $para->hasTranslation($requested_langcode)) {
            $para = $para->getTranslation($requested_langcode);
          }
          $speakers[] = [
            'name' => $para->get('field_name')->value ?? '',
            'designation' => $para->get('field_designation')->value ?? '',
            'profile_image' => $getImageUrl($para->get('field_profile_image')->target_id ?? null),
          ];
        }
      }

      // What you'll learn section
      $learning = [];
      if ($node->hasField('field_what_will_you_learn_sectio') && !$node->get('field_what_will_you_learn_sectio')->isEmpty()) {
        foreach ($node->get('field_what_will_you_learn_sectio') as $item) {
          $para = $item->entity;
          if ($para && $para->hasTranslation($requested_langcode)) {
            $para = $para->getTranslation($requested_langcode);
          }
          $learning[] = [
            'icon' => $getImageUrl($para->get('field_icon')->target_id ?? null),
            'text' => $para->get('field_text')->value ?? '',
          ];
        }
      }

      // Taxonomy fields
      $webinar_name = '';
      $home_resource_type = '';
      $menu_link_field_value = '';

      if ($node->hasField('field_webinar_name') && !$node->get('field_webinar_name')->isEmpty()) {
        $term = $node->get('field_webinar_name')->entity;
        if ($term && $term->hasTranslation($requested_langcode)) {
          $term = $term->getTranslation($requested_langcode);
        }
        $webinar_name = $term->label();
        $menu_link_field_value = $term->get('field_menu_link')->value ?? '';
        if ($term->hasField('field_home_resource_type') && !$term->get('field_home_resource_type')->isEmpty()) {
          $home_term = $term->get('field_home_resource_type')->entity;
          $home_resource_type = $home_term ? $home_term->label() : '';
        }
      }

      // Final response
      $response = [
        'nid' => $node->id(),
        'title' => $node->label(),
        'heading' => $node->get('field_webinar_heading')->value ?? '',
        'sub_heading' => $node->get('field_webinar_sub_heading')->value ?? '',
        'banner_image' => $getImageUrl($node->get('field_webinar_banner_image')->target_id ?? null),
        'main_image' => $getImageUrl($node->get('field_webinar_main_image')->target_id ?? null),
        'description' => $node->get('field_webinar_main_description')->value ?? '',
        'summary' => $node->get('field_webinar_summary')->value ?? '',
        'webinar_date' => $node->get('field_date')->value ?? '',
        'featuring_image' => $getImageUrl($node->get('field_webinar_featuring_image')->target_id ?? null),
        'speakers' => $speakers,
        'learning_section' => $learning,
        'langcode' => $requested_langcode,
        'fallback' => $fallback ?? false,
      ];

      return new JsonResponse([
        'status' => true,
        'message' => ($fallback ?? false) ? 'Fallback to English.' : 'Data fetched successfully.',
        'data' => $response,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }
  public function eventListingNew(Request $request)
  {
    try {
      $content = json_decode($request->getContent(), true);
      $requested_langcode = $content['lan'] ?? '';


      if (empty($requested_langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language code (lan) is required',
        ], 400);
      }

      $database = \Drupal::database();

      $fetchNodeIds = function ($langcode) use ($database) {
        $query = $database->select('node_field_data', 'nfd')
          ->fields('nfd', ['nid'])
          ->condition('nfd.type', 'custom_event_details')
          ->condition('nfd.status', 1)
          ->condition('nfd.langcode', $langcode);
        return $query->execute()->fetchCol();
      };

      $nids = $fetchNodeIds($requested_langcode);
      $fallback = false;

      if (empty($nids) && $requested_langcode !== 'en') {
        $requested_langcode = 'en';
        $nids = $fetchNodeIds('en');
        $fallback = true;
      }

      $nodes = \Drupal\node\Entity\Node::loadMultiple($nids);
      $language = \Drupal::languageManager()->getLanguage($requested_langcode);
      $language_name = $language ? $language->getName() : $requested_langcode;

      foreach ($nodes as $node) {

        if ($node->hasTranslation($requested_langcode)) {
          $node = $node->getTranslation($requested_langcode);
        }

        $nid = $node->id();
        $event_date = $node->get('field_event_start_date')->value ?? '';
        $event_location = $node->get('field_evnt_location')->value ?? '';
        $img_id = $node->get('field_event_feature_image')->target_id ?? '';
        $image = '';
        if (!empty($img_id)) {
          $file = \Drupal\file\Entity\File::load($img_id);
          if ($file) {
            $image = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
          }
        }
        $term = $node->get('field_select_event')->entity;
        $menu_link = "";
        $event_name = "";
        if ($term) {
          $event_name = $term->label();   // This gives the taxonomy term name
        }
        if ($term && $term->hasField('field_menu_link')) {
          $menu_link = $term->get('field_menu_link')->value;
        }
        $data[] = [
          'nid' => $nid ?? '',
          'langcode' => $requested_langcode,
          'language_name' => $language_name,
          'event_name' => $event_name ?? '',
          'event_link' => $menu_link ?? '',
          'date' => $event_date ?? '',
          'location' => $event_location ?? '',
          'image' => $image ?? ''
        ];
      }

      return new JsonResponse([
        'status' => true,
        'message' => $fallback
          ? 'Fallback to English. No data found in requested language.'
          : 'Data fetched successfully',
        'data' => $data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }
}
