<?php

namespace Drupal\api_module\Controller;

use Exception;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\node\Entity\Node;

class MetaController extends ControllerBase
{
  public function getMetaDetailsByPageName(Request $request) {
    try {
      $content = json_decode($request->getContent(), true);
      $langcode = $content['lan'] ?? 'en';
      $page_name = $content['page_name'] ?? '';
      $links = [
        'articles_link' => ['field' => 'field_all_articles_details', 'vocab' => 'articles'],
        'white_paper_link' => ['field' => 'field_all_white_papers', 'vocab' => 'white_paper_'],
        'webiners_link' => ['field' => 'field_all_webiners_details', 'vocab' => 'webiner'],
        'news_link' => ['field' => 'field_all_news_details', 'vocab' => 'news'],
        'event_link' => ['field' => 'field_all_events_details', 'vocab' => 'event'],
        'product_link' => ['field' => 'field_product_details', 'vocab' => 'api_products'],
      ];

      $meta_nids = [];

      // Check if all links are blank
      $all_blank = true;
      foreach ($links as $key => $info) {
        if (!empty($content[$key])) {
          $all_blank = false;

          $term = \Drupal::entityTypeManager()->getStorage('taxonomy_term')->loadByProperties([
            'field_menu_link' => $content[$key],
            'vid' => $info['vocab'],
          ]);
          $term = reset($term);

          if ($term) {
            $query = \Drupal::entityQuery('node')
              ->accessCheck(TRUE)
              ->condition('type', 'meta_details')
              ->condition($info['field'], $term->id());
            $meta_nids = $query->execute();
            break; // stop at first match
          }
        }
      }

      // If all links are blank, fetch based on page_name (from field_page_types term)
      if ($all_blank && !empty($page_name)) {
        $page_term = \Drupal::entityTypeManager()->getStorage('taxonomy_term')->loadByProperties([
          'field_menu_link' => $page_name,
          'vid' => 'page_type',
        ]);
        $page_term = reset($page_term);

        if ($page_term) {
          $query = \Drupal::entityQuery('node')
            ->accessCheck(TRUE)
            ->condition('type', 'meta_details')
            ->condition('field_page_types', $page_term->id());
          $meta_nids = $query->execute();
        }
      }

      if (empty($meta_nids)) {
        return new JsonResponse(['status' => false, 'message' => 'No data found.'], 200);
      }

      $nodes = \Drupal\node\Entity\Node::loadMultiple($meta_nids);
      $response = [];

      foreach ($nodes as $node) {
        // Try to get the translation; fallback to English if not available
        $translated_node = $node->hasTranslation($langcode)
          ? $node->getTranslation($langcode)
          : $node->getTranslation('en');

        $response = [
          'body' => $translated_node->get('body')->value ?? '',
          'nid' => $translated_node->id(),
          'title' => $translated_node->label(),
          'langcode' => $translated_node->language()->getId(),
        ];
      }

      return new JsonResponse([
        'status' => true,
        'data' => $response,
      ]);

    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'Error: ' . $e->getMessage(),
      ], 500);
  }
}


}
?>
