<?php

namespace Drupal\api_module\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Core\Controller\ControllerBase;
use Exception;
use Symfony\Component\HttpFoundation\Request;

class HomeTabServiceController extends ControllerBase
{
    public function getTabContent(Request $request)
    {

      try {
        // Get JSON payload
        $content = json_decode($request->getContent(), true);
        $langcode = $content['lan'] ?? '';

        if (empty($langcode)) {
          return new JsonResponse([
            'status' => false,
            'message' => 'Language code (lan) is required',
          ], 400);
        }

        $database = \Drupal::database();
        $query = $database->select('node_field_data', 'nfd')
          ->fields('nfd', ['nid', 'langcode'])
          ->condition('nfd.type', 'home_tab_section')
          ->condition('nfd.status', 1)
          ->condition('nfd.langcode', $langcode) // Filter by langcode from request
          ->distinct();

        $query->leftJoin('node__field_tab_name', 'nfauc', 'nfauc.entity_id = nfd.nid AND nfauc.langcode = nfd.langcode AND nfauc.delta = 0');
        $query->addField('nfauc', 'field_tab_name_value', 'tab_name');

        $query->leftJoin('node__field_tab_image', 'nfauci', 'nfauci.entity_id = nfd.nid AND nfauci.langcode = nfd.langcode AND nfauci.delta = 0');
        $query->addField('nfauci', 'field_tab_image_target_id', 'tab_image');

        $query->leftJoin('node__field_tab_feature_image', 'nftfi', 'nftfi.entity_id = nfd.nid AND nftfi.langcode = nfd.langcode AND nftfi.delta = 0');
        $query->addField('nftfi', 'field_tab_feature_image_target_id', 'tab_feature_image');

        $query->leftJoin('node__field_icon', 'nfaucicon', 'nfaucicon.entity_id = nfd.nid AND nfaucicon.langcode = nfd.langcode AND nfaucicon.delta = 0');
        $query->addField('nfaucicon', 'field_icon_target_id', 'icon');


        $query->leftJoin('node__field_teaser_description', 'nfades', 'nfades.entity_id = nfd.nid AND nfades.langcode = nfd.langcode AND nfades.delta = 0');
        $query->addField('nfades', 'field_teaser_description_value', 'teaser_description');

        $query->leftJoin('node__field_detailed_description', 'nfaddees', 'nfaddees.entity_id = nfd.nid AND nfaddees.langcode = nfd.langcode AND nfaddees.delta = 0');
        $query->addField('nfaddees', 'field_detailed_description_value', 'detailed_description');

       // $query->leftJoin('node__field_tab_feature_list', 'nfeature', 'nfeature.entity_id = nfd.nid AND nfeature.langcode = nfd.langcode AND nfeature.delta = 0');
       $query->leftJoin('node__field_tab_feature_list', 'nfeature', 'nfeature.entity_id = nfd.nid AND nfeature.langcode = nfd.langcode');
       $query->addField('nfeature', 'field_tab_feature_list_value', 'feature_list');

        $query->leftJoin('node__field_feature_tab_url', 'taburl', 'taburl.entity_id = nfd.nid AND taburl.langcode = nfd.langcode');
       $query->addField('taburl', 'field_feature_tab_url_value', 'feature_tab_url');



        $result = $query->execute();
        $data = [];

        foreach ($result as $row) {
            $nid = $row->nid;

            // Initialize data only once per nid
            if (!isset($data[$nid])) {
                $tab_image_url = '';
                if (!empty($row->tab_image)) {
                    $file = \Drupal\file\Entity\File::load($row->tab_image);
                    if ($file) {
                        $tab_image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
                    }
                }
                $tab_feature_image_url = '';
                if (!empty($row->tab_feature_image)) {
                    $file = \Drupal\file\Entity\File::load($row->tab_feature_image);
                    if ($file) {
                        $tab_feature_image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
                    }
                }

                $icon_url = '';
                if (!empty($row->icon)) {
                    $file = \Drupal\file\Entity\File::load($row->icon);
                    if ($file) {
                        $icon_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
                    }
                }

                $language = \Drupal::languageManager()->getLanguage($langcode);
                $language_name = $language ? $language->getName() : $langcode;

                $data[$nid] = [
                    'nid' => $nid,
                    'langcode' => $langcode,
                    'language_name' => $language_name,
                    'tab_name' => $row->tab_name ?? '',
                    'tab_image' => $tab_image_url,
                    'icon' => $icon_url,
                    'feature_list' => [],
                    'feature_image' => $tab_feature_image_url,
                    'teaser_description' => $row->teaser_description ?? '',
                    'detailed_description' => $row->detailed_description ?? '',
                    'feature_tab_url' => $row->feature_tab_url ?? '',
                ];
            }

            // Append feature list value (multiple rows possible per nid)
            if (!empty($row->feature_list) && empty($row->tab_feature_image)) {
                $data[$nid]['feature_list'][] = $row->feature_list;
            }
        }

        $finalData = array_values($data);
        return new JsonResponse([
            'status' => true,
            'message' => 'About Content data fetched successfully',
            'data' => $finalData,
        ]);
      } catch (\Exception $e) {
        return new JsonResponse([
          'status' => false,
          'message' => 'An error occurred: ' . $e->getMessage(),
        ], 500);
      }
    }
}
