<?php

namespace Drupal\api_module\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Core\Controller\ControllerBase;
use Exception;

class HPAPIsController extends ControllerBase
{
    //TESTED WITH TRANSLATION
    public function getMainSectionData(Request $request)
    {
        try {
            $content = json_decode($request->getContent(), true);
            $requested_langcode = $content['lan'] ?? '';

            if (empty($requested_langcode)) {
                return new JsonResponse([
                    'status' => false,
                    'message' => 'Language code (lan) is required',
                ], 400);
            }

            $database = \Drupal::database();

            // Fetch node IDs for valid about_tab_year_content
            $fetchNodeIds = function ($langcode) use ($database) {
                $query = $database->select('node_field_data', 'nfd')
                    ->fields('nfd', ['nid'])
                    ->condition('nfd.type', 'hpapis_main_section')
                    ->condition('nfd.status', 1)
                    ->condition('nfd.langcode', $langcode);
                return $query->execute()->fetchCol();
            };

            $nids = $fetchNodeIds($requested_langcode);
            $fallback = false;

            // Fallback to English if no nodes found
            if (empty($nids) && $requested_langcode !== 'en') {
                $requested_langcode = 'en';
                $nids = $fetchNodeIds('en');
                $fallback = true;
            }

            $nodes = \Drupal\node\Entity\Node::loadMultiple($nids);
            $response = [];

            $language = \Drupal::languageManager()->getLanguage($requested_langcode);
            $language_name = $language ? $language->getName() : $requested_langcode;

            foreach ($nodes as $node) {
                if ($node->hasTranslation($requested_langcode)) {
                    $node = $node->getTranslation($requested_langcode);
                }

                $nid = $node->id();
                $top_text = $node->get('field_hpapis_main_section_top_te')->value ?? '';
                $bottom_text = $node->get('field_hpapis_main_section_bottom')->value ?? '';
                $response = [
                    'nid' => $nid,
                    'langcode' => $requested_langcode,
                    'language_name' => $language_name,
                    'top_text' => $top_text,
                    'bottom_text' => $bottom_text,
                ];
            }
            return new JsonResponse([
                'status' => true,
                'message' => $fallback == true ? 'Fallback to English. As No Data found in the requested language.' : 'Data fetch successfully',
                'data' => $response,
            ]);
        } catch (\Exception $e) {
            return new JsonResponse([
                'status' => false,
                'message' => 'An error occurred: ' . $e->getMessage(),
            ], 500);
        } catch (Exception $e) {
            return new JsonResponse([
                'status' => false,
                'message' => 'An error occurred: ' . $e->getMessage(),
            ], 500);
        }
    }
}
