<?php

namespace Drupal\api_module\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Core\Controller\ControllerBase;
use Drupal\file\Entity\File;
use Symfony\Component\HttpFoundation\Request;

class BannerController extends ControllerBase
{
  public function getBannerData(Request $request)
  {
    try {
      $content = json_decode($request->getContent(), true);
      $langcode = $content['lan'] ?? '';

      if (empty($langcode)) {
        return new JsonResponse([
          'status' => false,
          'message' => 'Language code (lan) is required',
        ], 400);
      }

      $nids = \Drupal::entityQuery('node')
        ->condition('type', 'slider') // Replace 'banner' with your actual content type if different
        ->condition('status', 1)
        ->accessCheck(TRUE)
        ->execute();

      $nodes = \Drupal\node\Entity\Node::loadMultiple($nids);
      $language = \Drupal::languageManager()->getLanguage($langcode);
      $language_name = $language ? $language->getName() : $langcode;

      $data = [];

      foreach ($nodes as $node) {
        if ($node->hasTranslation($langcode)) {
          $node = $node->getTranslation($langcode);
        }

        $nid = $node->id();
        $title = $node->label();
        $banner_short_text = $node->get('field_banner_short_text')->value ?? 'Default Banner Title';
        $banner_sub_short_text = $node->get('field_banner_sub_short_text')->value ?? '';
        $banner_title = $node->get('field_banner_title')->value ?? '';
        $banner_link = $node->get('field_banner_url')->value ?? '';
        $banner_sq = $node->get('field_banner_sequence')->value ?? '';


        // Banner Image
        $image_url = '';
        if (!$node->get('field_banner_main_image')->isEmpty()) {
          $image_file = $node->get('field_banner_main_image')->entity;
          if ($image_file) {
            $image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($image_file->getFileUri());
          }
        }

        // Banner Logo
        $logo_url = '';
        if (!$node->get('field_banner_logo')->isEmpty()) {
          $logo_file = $node->get('field_banner_logo')->entity;
          if ($logo_file) {
            $logo_url = \Drupal::service('file_url_generator')->generateAbsoluteString($logo_file->getFileUri());
          }
        }

        $data[] = [
          'nid' => $nid,
          'langcode' => $langcode,
          'language_name' => $language_name,
          'banner_image' => $image_url,
          'banner_logo' => $logo_url,
          'banner_short_text' => $banner_short_text,
          'banner_sub_short_text' => $banner_sub_short_text,
          'banner_title_text' => $banner_title,
          'banner_url' => $banner_link,
          'banner_sequence' => $banner_sq
        ];
      }

      return new JsonResponse([
        'status' => true,
        'message' => 'Banner data fetched successfully',
        'data' => $data,
      ]);
    } catch (\Exception $e) {
      return new JsonResponse([
        'status' => false,
        'message' => 'An error occurred: ' . $e->getMessage(),
      ], 500);
    }
  }
}
