<?php
namespace Drupal\api_module\Controller\AllDetailsPage;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

  class WhitePaperDetailsController extends ControllerBase {

    public function whitePaperdetailspageContent(Request $request) {
      try {
        $content = $request->getContent();
          $data = json_decode($content, TRUE);

          $paper_name = $data['paper_name'] ?? NULL;

          if (!$paper_name) {
              return new JsonResponse([
                  'status' => false,
                  'message' => 'paper_name parameter is missing',
              ], 400);
          }
          $database = \Drupal::database();
          $query = $database->select('node_revision', 'nr')
              ->fields('nr', ['nid', 'revision_uid']);

          $query = $database->select('node_field_data', 'nfd')
              ->fields('nfd', ['nid', 'title']);

          $query->leftJoin('node__field_white_paper_details_descri', 'nfwpdes', 'nfwpdes.entity_id = nfd.nid AND nfwpdes.delta = 0');
          $query->addField('nfwpdes', 'field_white_paper_details_descri_value', 'description');

          $query->leftJoin('node__field_white_paper_details_main_h', 'nfwpdhe', 'nfwpdhe.entity_id = nfd.nid AND nfwpdhe.delta = 0');
          $query->addField('nfwpdhe', 'field_white_paper_details_main_h_value', 'main_heading');

          $query->leftJoin('node__field_white_paper_details_main_i', 'nfablin', 'nfablin.entity_id = nfd.nid AND nfablin.delta = 0');
          $query->addField('nfablin', 'field_white_paper_details_main_i_target_id', 'content_image');

          $query->leftJoin('node__field_white_paper_details_other_', 'nfbdnlink', 'nfbdnlink.entity_id = nfd.nid AND nfbdnlink.delta = 0');
          $query->addField('nfbdnlink', 'field_white_paper_details_other__value', 'other_link');


          $query->leftJoin('node__field_white_paper_name', 'nffwpn', 'nffwpn.entity_id = nfd.nid AND nffwpn.delta = 0');
          $query->addField('nffwpn', 'field_white_paper_name_target_id', 'details_page_name');

          $query->leftJoin('taxonomy_term_field_data', 'ttfd', 'ttfd.tid = nffwpn.field_white_paper_name_target_id');
          $query->addField('ttfd', 'name', 'page_type_name');
          $query->condition('ttfd.name', $paper_name, 'LIKE');

          $query->condition('nfd.type', 'white_paper_details_content');
          $query->condition('nfd.status', 1);

          $result = $query->execute();

          $data = [];
          foreach ($result as $row) {
              $content_image_url = '';
              if (!empty($row->content_image)) {
                  $file = \Drupal\file\Entity\File::load($row->content_image);
                  if ($file) {
                      $content_image_url = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
                  }
              }

              $data = [
                  'nid' => $row->nid,
                  'page_type_name' => $row->page_type_name,
                  'description' => $row->description ?? '',
                  'main_heading' => $row->main_heading ?? '',
                  'content_image' => $content_image_url,
                  'other_link' => $row->other_link ?? '',
              ];
          }

          return new JsonResponse([
              'status' => true,
              'message' => 'Content data fetched successfully',
              'data' => $data,
          ]);
      } catch (\Exception $e) {
          return new JsonResponse([
              'status' => false,
              'message' => 'An error occurred: ' . $e->getMessage(),
          ], 500);
      }
    }

    public function whitepaperBannerDetails(Request $request) {
      try {
        $content = $request->getContent();
          $data = json_decode($content, TRUE);

          $paper_name = $data['paper_name'] ?? NULL;

          if (!$paper_name) {
              return new JsonResponse([
                  'status' => false,
                  'message' => 'paper_name parameter is missing',
              ], 400);
          }
          $database = \Drupal::database();
          $query = $database->select('node_revision', 'nr')
              ->fields('nr', ['nid', 'revision_uid']);

          $query = $database->select('node_field_data', 'nfd')
              ->fields('nfd', ['nid', 'title']);

          $query->leftJoin('node__field_wp_details_banner_heading', 'nfwdbh', 'nfwdbh.entity_id = nfd.nid AND nfwdbh.delta = 0');
          $query->addField('nfwdbh', 'field_wp_details_banner_heading_value', 'heading');

          $query->leftJoin('node__field_wp_details_banner_img', 'nfwdbi', 'nfwdbi.entity_id = nfd.nid AND nfwdbi.delta = 0');
          $query->addField('nfwdbi', 'field_wp_details_banner_img_target_id', 'banner_image');

          $query->leftJoin('node__field_wp_details_breadcrumb', 'nfwdbread', 'nfwdbread.entity_id = nfd.nid AND nfwdbread.delta = 0');
          $query->addField('nfwdbread', 'field_wp_details_breadcrumb_value', 'breadcrumb');

          $query->leftJoin('node__field_wp_details_brochure_link', 'nfbdnlink', 'nfbdnlink.entity_id = nfd.nid AND nfbdnlink.delta = 0');
          $query->addField('nfbdnlink', 'field_wp_details_brochure_link_value', 'brochure_link');

          $query->leftJoin('node__field_wp_details_cas_no_', 'nfwdcn', 'nfwdcn.entity_id = nfd.nid AND nfwdcn.delta = 0');
          $query->addField('nfwdcn', 'field_wp_details_cas_no__value', 'cas_no');

          $query->leftJoin('node__field_wp_details_type', 'nfwdt', 'nfwdt.entity_id = nfd.nid AND nfwdt.delta = 0');
          $query->addField('nfwdt', 'field_wp_details_type_target_id', 'details_page_name');

          $query->leftJoin('taxonomy_term_field_data', 'ttfd', 'ttfd.tid = nfwdt.field_wp_details_type_target_id');
          $query->addField('ttfd', 'name', 'page_type_name');
          $query->condition('ttfd.name', $paper_name, 'LIKE');

          $query->condition('nfd.type', 'white_paper_details_banner');
          $query->condition('nfd.status', 1);

          $result = $query->execute();


          foreach ($result as $row) {
              $banner_image = '';
              if (!empty($row->banner_image)) {
                  $file = \Drupal\file\Entity\File::load($row->banner_image);
                  if ($file) {
                      $banner_image = \Drupal::service('file_url_generator')->generateAbsoluteString($file->getFileUri());
                  }
              }

              $data = [
                  'nid' => $row->nid,
                  'page_type_name' => $row->page_type_name,
                  'banner_heading' => $row->heading ?? '',
                  'banner_negvigation' => $row->breadcrumb ?? '',
                  'banner_image' => $banner_image,
                  'banner_download_brochure_link' => $row->brochure_link ?? '',
                  'cas_no' => $row->cas_no ?? '',
              ];
          }

          return new JsonResponse([
              'status' => true,
              'message' => 'Banner data fetched successfully',
              'data' => $data,
          ]);
      } catch (\Exception $e) {
          return new JsonResponse([
              'status' => false,
              'message' => 'An error occurred: ' . $e->getMessage(),
          ], 500);
      }
    }
  }
?>
