<?php

namespace Drupal\miniorange_webauthn\MoProtector\MoStorage;

use ParagonIE\ConstantTime\Base64UrlSafe;
use Webauthn\PublicKeyCredentialOptions;
use Webauthn\PublicKeyCredentialUserEntity;

final readonly class MoItem
{
  public function __construct(
    private PublicKeyCredentialOptions $publicKeyCredentialOptions,
    private ?PublicKeyCredentialUserEntity $publicKeyCredentialUserEntity
  ) {
  }

  public static function create(
    PublicKeyCredentialOptions $publicKeyCredentialOptions,
    ?PublicKeyCredentialUserEntity $publicKeyCredentialUserEntity
  ): self {

    return new self($publicKeyCredentialOptions, $publicKeyCredentialUserEntity);
  }

  public function getPublicKeyCredentialOptions(): PublicKeyCredentialOptions
  {
    return $this->publicKeyCredentialOptions;
  }

  public function getPublicKeyCredentialUserEntity(): ?PublicKeyCredentialUserEntity
  {
    return $this->publicKeyCredentialUserEntity;
  }
}
