<?php

namespace Drupal\miniorange_webauthn\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\user\UserInterface;

/**
 * Checks access for User credential forms.
 */
class WebAuthnDeviceFormAccessCheck implements AccessInterface {

  /**
   * Checks access to any User credential forms.
   *
   * @param AccountInterface $account
   *   The currently logged in account.
   * @param UserInterface|null $user
   *   The current display user.
   *
   * @return AccessResultInterface
   *   The access result.
   */
  public function access(AccountInterface $account, UserInterface $user = NULL) {
    if ($account->hasPermission('administer users')) {
      return AccessResult::allowed();
    }
    elseif ($account->hasPermission('mo_access_user_profile') && $account->id() === $user->id()) {
      return AccessResult::allowed();
    }

    return AccessResult::forbidden();
  }

}
